/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.graphics.ps.PsDocument;
import gov.nasa.giss.graphics.ps.PsGraphics2D;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.map.overlay.AbstractOverlay;
import gov.nasa.giss.map.overlay.MaskOverlay;
import gov.nasa.giss.map.overlay.OverlayFilenameFilter;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.gui.ProjBooleanField;
import gov.nasa.giss.map.proj.gui.ProjDoubleField;
import gov.nasa.giss.map.proj.gui.ProjField;
import gov.nasa.giss.map.proj.gui.ProjListField;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanDisplayFrame;
import gov.nasa.giss.panoply.PanFileUtilities;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanOverlayMenu;
import gov.nasa.giss.panoply.PanOverlayPanel;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProjectionMenu;
import gov.nasa.giss.panoply.PanProjectionPrefs;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.panoply.actions.PanSaveImageAsAction;
import gov.nasa.giss.text.DoubleDocument;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PanOverlayBrowser
extends PanDisplayFrame
implements DropTargetListener,
Printable {
    private static final int LABEL_FHGT = 12;
    private static final int LABEL_HGT = 18;
    private static final Font LABEL_FONT = new Font("SansSerif", 0, 12);
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private static PanOverlayBrowser oframe_;
    private JPanel contentPanel_;
    private PanOverlayMenu overlayMenu_;
    private PanOverlayPanel overlayPanel_;
    private JCheckBox oInvertCB_;
    private PanProjectionMenu projMenu_;
    private JTextField copLonTF_;
    private JTextField copLatTF_;
    private QuickBox projCenterBox_;
    private QuickBox copLonBox_;
    private QuickBox copLatBox_;
    private QuickBox paramBox_;
    private QuickBox boxesBox_;
    private Hashtable<String, String> paramHash_ = new Hashtable(25);
    private String lastproj_;

    public static PanOverlayBrowser findFrame(boolean create) {
        if (oframe_ == null && create) {
            oframe_ = new PanOverlayBrowser();
        }
        return oframe_;
    }

    private PanOverlayBrowser() {
        super("Overlays");
        Action a;
        this.setName(this.getTitle());
        this.setResizable(false);
        PanMenuBar mbar = new PanMenuBar(this);
        this.setPanMenuBar(mbar);
        if (mbar != null && (a = mbar.getItemActionByName("file-menu", "save-image")) != null) {
            a.setEnabled(false);
        }
        JLabel overlayLabel = new JLabel("Overlay: ");
        AbstractOverlay overlay = (AbstractOverlay)PREFS.get("plot:lonlat.map.overlay");
        this.overlayMenu_ = new PanOverlayMenu(false);
        this.overlayPanel_ = new PanOverlayPanel();
        if (this.overlayMenu_.getItemCount() < 1) {
            this.overlayMenu_.setEnabled(false);
        } else if (overlay == null) {
            this.overlayPanel_.setOverlay((AbstractOverlay)this.overlayMenu_.getSelectedItem());
        } else {
            this.overlayMenu_.setSelectedItem(overlay);
        }
        this.oInvertCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Invert", PREFS.getBoolean("plot:lonlat.map.overlay.invert"));
        JLabel projLabel = new JLabel("Projection: ");
        this.projMenu_ = PanWidgetUtils.getProjectionMenu(PanWidgetUtils.Size.NORMAL, null, false, false);
        this.projMenu_.setSelectedItemByName(PREFS.getString("plot:lonlat.map.projection"));
        this.projMenu_.setMaximumSize(this.projMenu_.getPreferredSize());
        JLabel centerLabel = new JLabel("Center on: ");
        JLabel lonLabel = new JLabel("Lon. ");
        JLabel degELabel = new JLabel("\u00b0E");
        JLabel latLabel = new JLabel(", Lat. ");
        JLabel degNLabel = new JLabel("\u00b0N");
        this.copLonTF_ = new JTextField(new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(PREFS.getDouble("plot:lonlat.map.center.lon")), 5);
        this.copLatTF_ = new JTextField(new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(PREFS.getDouble("plot:lonlat.map.center.lat")), 5);
        this.copLonTF_.setMaximumSize(this.copLonTF_.getPreferredSize());
        this.copLatTF_.setMaximumSize(this.copLatTF_.getPreferredSize());
        this.copLonTF_.setHorizontalAlignment(4);
        this.copLatTF_.setHorizontalAlignment(4);
        this.copLonBox_ = QuickBox.createHorizontalBox(lonLabel, this.copLonTF_, degELabel);
        this.copLatBox_ = QuickBox.createLeftBox(latLabel, this.copLatTF_, degNLabel);
        this.projCenterBox_ = QuickBox.createHorizontalBox(this.copLonBox_, this.copLatBox_);
        this.paramBox_ = QuickBox.createHorizontalBox(new Component[0]);
        this.boxesBox_ = QuickBox.createLeftBox(centerLabel, this.projCenterBox_, this.paramBox_);
        Dimension lsize = projLabel.getPreferredSize();
        overlayLabel.setPreferredSize(lsize);
        overlayLabel.setMaximumSize(lsize);
        centerLabel.setPreferredSize(lsize);
        centerLabel.setMaximumSize(lsize);
        this.contentPanel_ = new JPanel();
        this.contentPanel_.setLayout(new BoxLayout(this.contentPanel_, 1));
        this.contentPanel_.setBorder(PanGuiConstants.PADDED_UNFOCUSED_BORDER);
        this.contentPanel_.add(this.overlayPanel_);
        this.contentPanel_.add(Box.createVerticalStrut(2));
        this.contentPanel_.add(QuickBox.createLeftBox(overlayLabel, this.overlayMenu_, this.oInvertCB_));
        this.contentPanel_.add(Box.createVerticalStrut(2));
        this.contentPanel_.add(QuickBox.createLeftBox(projLabel, this.projMenu_));
        this.contentPanel_.add(Box.createVerticalStrut(2));
        this.contentPanel_.add(this.boxesBox_);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.contentPanel_);
        contentPane.add(this.createStatusBar());
        GuiUtilities.makeRecursiveDropTarget(this.overlayPanel_, this);
        this.refresh();
        this.addListeners();
        this.pack();
        java.awt.Rectangle rr = GuiUtilities.getMainScreenBounds();
        if (rr == null) {
            this.setLocation(25, 25);
        } else {
            Dimension psize = this.getContentPane().getPreferredSize();
            int x = (rr.width - psize.width) / 2;
            int y = (rr.height - psize.height) / 2;
            this.setLocation(rr.x + x, rr.y + y);
        }
    }

    private void addListeners() {
        this.overlayMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanOverlayBrowser.this.overlayPanel_.setOverlay(PanOverlayBrowser.this.overlayMenu_.getOverlay());
                PanOverlayBrowser.this.refresh();
            }
        });
        this.oInvertCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanOverlayBrowser.this.overlayPanel_.setOverlayInverted(e.getStateChange() == 1);
            }
        });
        this.projMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                String pname = PanOverlayBrowser.this.projMenu_.getSelectedItem().toString();
                PanOverlayBrowser.this.overlayPanel_.setProjection(pname);
                PanMenuBar mbar = PanOverlayBrowser.this.getPanMenuBar();
                Action a = mbar.getItemActionByName("file-menu", "save-image-as");
                if (a != null) {
                    ((PanSaveImageAsAction)a).setFnameRoot(pname.toLowerCase());
                }
                PanOverlayBrowser.this.refresh();
            }
        });
        FocusListener lonlatFL = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PanOverlayBrowser.this.handleCoP();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        ActionListener lonlatAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanOverlayBrowser.this.handleCoP();
            }
        };
        this.copLonTF_.addFocusListener(lonlatFL);
        this.copLatTF_.addFocusListener(lonlatFL);
        this.copLonTF_.addActionListener(lonlatAL);
        this.copLatTF_.addActionListener(lonlatAL);
    }

    private void handleCoP() {
        boolean shifted;
        double lon = 0.0;
        double lat = 0.0;
        try {
            shifted = false;
            for (lon = TextUtilities.parseDouble(this.copLonTF_.getText()); lon > 180.0; lon -= 360.0) {
                shifted = true;
            }
            while (lon < -180.0) {
                lon += 360.0;
                shifted = true;
            }
            if (shifted) {
                this.copLonTF_.setText(PanConstants.PFORMAT_2.sprintf(lon));
            }
        }
        catch (Exception exc) {
            lon = this.overlayPanel_.getProjection().getCenter().getLon();
            this.copLonTF_.setText(PanConstants.PFORMAT_2.sprintf(lon));
        }
        try {
            lat = TextUtilities.parseDouble(this.copLatTF_.getText());
            shifted = false;
            if (lat > 90.0) {
                lat = 90.0;
                shifted = true;
            }
            if (lat < -90.0) {
                lat = -90.0;
                shifted = true;
            }
            if (shifted) {
                this.copLatTF_.setText(PanConstants.PFORMAT_2.sprintf(lat));
            }
        }
        catch (Exception exc) {
            lon = this.overlayPanel_.getProjection().getCenter().getLat();
            this.copLatTF_.setText(PanConstants.PFORMAT_2.sprintf(lat));
        }
        this.overlayPanel_.getProjection().setCenter(lon, lat);
        this.overlayPanel_.repaint();
    }

    @Override
    public void refresh() {
        this.oInvertCB_.setEnabled(this.overlayMenu_.getOverlay() instanceof MaskOverlay);
        final AbstractProjection proj = this.overlayPanel_.getProjection();
        final String projname = proj.getName();
        if (this.lastproj_ != null && projname.equals(this.lastproj_)) {
            return;
        }
        this.lastproj_ = projname;
        if (proj.isOblique()) {
            this.projCenterBox_.add(this.copLatBox_);
            this.copLonTF_.setEnabled(true);
            this.copLatTF_.setEnabled(true);
            this.copLatBox_.setVisible(true);
        } else if (proj.isInterrupted()) {
            this.projCenterBox_.remove(this.copLatBox_);
            this.copLonTF_.setEnabled(proj.isRecenterableLon());
            this.copLatTF_.setEnabled(false);
            this.copLatBox_.setVisible(false);
        } else {
            this.projCenterBox_.remove(this.copLatBox_);
            this.copLonTF_.setEnabled(true);
            this.copLatTF_.setEnabled(false);
            this.copLatBox_.setVisible(false);
        }
        this.paramBox_.removeAll();
        int pcount = proj.getParameterCount();
        for (int i = 0; i < pcount; ++i) {
            if (i == 0) {
                this.paramBox_.add(new JLabel("; "));
            } else {
                this.paramBox_.add(new JLabel(", "));
            }
            final int pid = i;
            final ProjField pf = proj.getParameterField(i);
            this.paramBox_.add(pf);
            pf.setMaximumSize(pf.getPreferredSize());
            pf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanOverlayBrowser.this.overlayPanel_.repaint();
                    PanOverlayBrowser.this.paramHash_.put(projname + "-" + pid, pf.getStringValue());
                    try {
                        if (proj.isInterrupted()) {
                            PanOverlayBrowser.this.copLonTF_.setEnabled(proj.isRecenterableLon());
                            PanOverlayBrowser.this.copLonTF_.setText(PanConstants.PFORMAT_2.sprintf(proj.getCenter().getLon()));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            String value = this.paramHash_.get(projname + "-" + pid);
            if (value == null || value.length() == 0) {
                value = PanProjectionPrefs.getParam(projname, pid);
            }
            if (value == null || value.length() == 0) continue;
            try {
                if (pf instanceof ProjDoubleField) {
                    ((ProjDoubleField)pf).setValue(TextUtilities.parseDouble(value));
                    continue;
                }
                if (pf instanceof ProjBooleanField) {
                    ((ProjBooleanField)pf).setSelected(Boolean.valueOf(value));
                    continue;
                }
                if (!(pf instanceof ProjListField)) continue;
                ((ProjListField)pf).setValue(value);
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        this.projCenterBox_.setMaximumSize(this.projCenterBox_.getPreferredSize());
        this.paramBox_.setMaximumSize(this.paramBox_.getPreferredSize());
        this.projCenterBox_.invalidate();
        this.paramBox_.invalidate();
        this.boxesBox_.invalidate();
        this.validate();
        this.repaint();
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.contentPanel_.setBorder(PanGuiConstants.PADDED_FOCUSED_BORDER);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            try {
                List flist = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                for (Object fobj : flist) {
                    File f = (File)fobj;
                    AbstractOverlay o = null;
                    try {
                        if (OverlayFilenameFilter.isOverlayName(f)) {
                            o = (AbstractOverlay)PanFileUtilities.openLocalFile(this, f);
                        }
                    }
                    catch (Exception exc) {
                        PanFileUtilities.showFileError((Component)this, f.getName(), exc.toString());
                    }
                    if (o == null) continue;
                    this.overlayMenu_.setSelectedItem(o);
                    this.overlayPanel_.setOverlay(o);
                }
                e.dropComplete(true);
                this.repaint();
            }
            catch (Exception exc) {
                exc.printStackTrace();
                e.dropComplete(false);
            }
        } else {
            e.rejectDrop();
        }
        this.contentPanel_.setBorder(PanGuiConstants.PADDED_UNFOCUSED_BORDER);
        this.repaint();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.contentPanel_.setBorder(PanGuiConstants.PADDED_UNFOCUSED_BORDER);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.contentPanel_.setBorder(PanGuiConstants.PADDED_FOCUSED_BORDER);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.contentPanel_.setBorder(PanGuiConstants.PADDED_UNFOCUSED_BORDER);
        this.repaint();
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        Dimension size = this.overlayPanel_.getSize();
        double scaleX = pf.getImageableHeight() / (double)size.width;
        double scaleY = pf.getImageableWidth() / (double)(size.height + 18);
        double scale = Math.min(scaleY, scaleX);
        double tranX = 0.5 * (pf.getImageableWidth() + scale * (double)this.overlayPanel_.getHeight());
        g2d.translate(pf.getImageableX() + tranX, pf.getImageableY());
        g2d.rotate(1.5707963267948966);
        g2d.scale(scale, scale);
        this.overlayPanel_.print(g2d);
        this.printLabel(g2d);
        return 0;
    }

    @Override
    public BufferedImage getImage() {
        return this.overlayPanel_.getImage();
    }

    @Override
    public void paintImage(BufferedImage img) {
        this.overlayPanel_.paintImage(img);
    }

    @Override
    public void paintContentPDF(PdfWriter writer, Document document) {
        PdfContentByte cb = writer.getDirectContent();
        Rectangle pageSize = document.getPageSize();
        Dimension useSize = new Dimension((int)(pageSize.width() - 144.0f), (int)(pageSize.height() - 144.0f));
        Dimension plotLayout = this.overlayPanel_.getSize();
        float scaleX = (float)useSize.width / (float)plotLayout.width;
        float scaleY = (float)useSize.height / (float)(plotLayout.height + 18);
        float scale = Math.min(scaleX, scaleY);
        cb.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, (pageSize.width() - (float)plotLayout.width * scale) / 2.0f, (pageSize.height() - (float)plotLayout.height * scale) / 2.0f);
        cb.concatCTM(scale, 0.0f, 0.0f, scale, 0.0f, 0.0f);
        Graphics2D g2d = cb.createGraphicsShapes(plotLayout.width, plotLayout.height + 18);
        this.overlayPanel_.print(g2d);
        this.printLabel(g2d);
        g2d.dispose();
        cb.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, plotLayout.height);
    }

    @Override
    public void paintContentPs(PsDocument document) {
        PsGraphics2D g2d = document.createGraphics(false);
        Dimension pageSize = document.getSize();
        Dimension useSize = new Dimension((int)((float)pageSize.width - 144.0f), (int)((float)pageSize.height - 144.0f));
        Dimension plotLayout = this.overlayPanel_.getSize();
        float scaleX = (float)useSize.width / (float)plotLayout.width;
        float scaleY = (float)useSize.height / (float)plotLayout.height;
        float scale = Math.min(scaleY, scaleX);
        ((Graphics2D)g2d).translate(((float)pageSize.width - (float)plotLayout.width * scale) / 2.0f, ((float)pageSize.height - (float)plotLayout.height * scale) / 2.0f);
        ((Graphics2D)g2d).scale(scale, scale);
        this.overlayPanel_.print(g2d);
        this.printLabel(g2d);
        ((Graphics)g2d).dispose();
    }

    private void printLabel(Graphics2D g2d) {
        g2d.setFont(LABEL_FONT);
        AbstractProjection proj = this.overlayPanel_.getProjection();
        String projname = proj.getName();
        FontMetrics fm = g2d.getFontMetrics();
        String s = this.overlayMenu_.getSelectedItem().toString() + " - " + projname + " Projection";
        GraphicUtilities.drawString(g2d, s, (int)(0.5 * (double)(this.overlayPanel_.getWidth() - fm.stringWidth(s))), this.overlayPanel_.getHeight() + 15);
    }
}

