/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.filechooser.OpenFileChooser;
import gov.nasa.giss.panoply.PanFileConstants;
import gov.nasa.giss.panoply.PanPreferences;
import java.io.File;

public class PanOpenFileChooser
extends OpenFileChooser {
    private boolean updated_;
    private static PanOpenFileChooser dataChooser_;
    private static PanOpenFileChooser readableChooser_;
    private static PanOpenFileChooser settingsChooser_;

    public static PanOpenFileChooser getDataChooser() {
        if (dataChooser_ == null) {
            dataChooser_ = new PanOpenFileChooser();
            dataChooser_.addChoosableFileFilter(PanFileConstants.DATASETS_FILTER);
            dataChooser_.addChoosableFileFilter(PanFileConstants.NC_FILTER);
            dataChooser_.addChoosableFileFilter(PanFileConstants.HDF_FILTER);
            dataChooser_.addChoosableFileFilter(PanFileConstants.GRIB_FILTER);
            dataChooser_.addChoosableFileFilter(PanFileConstants.ALL_FILES_FILTER);
            dataChooser_.setFileFilter(PanFileConstants.DATASETS_FILTER);
        }
        return dataChooser_;
    }

    public static PanOpenFileChooser getReadableChooser() {
        if (readableChooser_ == null) {
            readableChooser_ = new PanOpenFileChooser();
            readableChooser_.addChoosableFileFilter(PanFileConstants.READABLE_FILTER);
            readableChooser_.addChoosableFileFilter(PanFileConstants.DATASETS_FILTER);
            readableChooser_.addChoosableFileFilter(PanFileConstants.NC_FILTER);
            readableChooser_.addChoosableFileFilter(PanFileConstants.HDF_FILTER);
            readableChooser_.addChoosableFileFilter(PanFileConstants.GRIB_FILTER);
            readableChooser_.addChoosableFileFilter(PanFileConstants.CTABLE_FILTER);
            readableChooser_.addChoosableFileFilter(PanFileConstants.CNO_FILTER);
            readableChooser_.addChoosableFileFilter(PanFileConstants.IMAGE_FILTER);
            readableChooser_.addChoosableFileFilter(PanFileConstants.GRIB1TAB_FILTER);
            readableChooser_.addChoosableFileFilter(PanFileConstants.ALL_FILES_FILTER);
            readableChooser_.setFileFilter(PanFileConstants.READABLE_FILTER);
        }
        return readableChooser_;
    }

    public static PanOpenFileChooser getSettingsChooser() {
        if (settingsChooser_ == null) {
            settingsChooser_ = new PanOpenFileChooser();
            settingsChooser_.addChoosableFileFilter(PanFileConstants.SETTINGS_FILTER);
            settingsChooser_.setFileFilter(PanFileConstants.SETTINGS_FILTER);
        }
        return settingsChooser_;
    }

    private PanOpenFileChooser() {
        this.setDialogTitle("Open");
        this.setMultiSelectionEnabled(true);
        String dpath = (String)PanPreferences.getPrefs().get("path:open");
        if (dpath.length() > 0) {
            try {
                this.setCurrentDirectory(new File(dpath));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public File getSelectedFile() {
        File f = super.getSelectedFile();
        if (f == null) {
            return null;
        }
        PanPreferences.getPrefs().set("path:open", f.getParent());
        return f;
    }

    @Override
    public File[] getSelectedFiles() {
        if (this.isMultiSelectionEnabled()) {
            File[] ff = super.getSelectedFiles();
            if (ff == null) {
                return new File[0];
            }
            if (ff.length == 0) {
                return ff;
            }
            PanPreferences.getPrefs().set("path:open", ff[0].getParent());
            return ff;
        }
        File f = this.getSelectedFile();
        if (f == null) {
            return new File[0];
        }
        return new File[]{f};
    }
}

