/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanPlotType;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanNetcdfUtilities {
    private static Logger logger_ = LoggerFactory.getLogger(PanNetcdfUtilities.class);

    private PanNetcdfUtilities() {
    }

    public static NcArray createArray(PanPlotType ptype, NcDataset dataset, String varname, JFrame parent) throws NcException {
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset is null");
        }
        NcVariable ncvar = new NcVariable(dataset, varname);
        return PanNetcdfUtilities.createArray(ptype, ncvar, parent);
    }

    public static NcArray createArray(PanPlotType ptype, NcNode node, JFrame parent) throws NcException {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        if (!(node instanceof NcVariable)) {
            throw new IllegalArgumentException("Node is not a variable");
        }
        return PanNetcdfUtilities.createArray(ptype, (NcVariable)node, parent);
    }

    public static NcArray createArray(PanPlotType ptype, NcVariable ncvar, JFrame parent) throws NcException {
        if (ncvar == null) {
            throw new IllegalArgumentException("Variable is null");
        }
        if (ptype == null) {
            throw new IllegalArgumentException("Plot type is null");
        }
        if (ptype == PanPlotType.LON_LAT) {
            return ncvar.getArray(NcVariable.Axes.LON_LAT);
        }
        if (ptype == PanPlotType.LAT_VERT) {
            return ncvar.getArray(NcVariable.Axes.LAT_VERT);
        }
        if (ptype == PanPlotType.LON_VERT) {
            return ncvar.getArray(NcVariable.Axes.LON_VERT);
        }
        if (ptype == PanPlotType.TIME_LAT) {
            return ncvar.getArray(NcVariable.Axes.TIME_LAT);
        }
        throw new RuntimeException("Unknown plot type: " + (Object)((Object)ptype));
    }
}

