/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.menu.GissMenu;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.map.overlay.AbstractOverlay;
import gov.nasa.giss.map.overlay.MaskOverlay;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.Equirectangular;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.map.proj.VerticalPerspective;
import gov.nasa.giss.map.proj.gui.ProjBooleanField;
import gov.nasa.giss.map.proj.gui.ProjDoubleField;
import gov.nasa.giss.map.proj.gui.ProjField;
import gov.nasa.giss.map.proj.gui.ProjListField;
import gov.nasa.giss.panoply.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanEnumMenu;
import gov.nasa.giss.panoply.PanGridSpacingMenu;
import gov.nasa.giss.panoply.PanGridStyle;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanMenuItemEnum;
import gov.nasa.giss.panoply.PanOverlayMenu;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanProjectionMenu;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.panoply.actions.PanMapZoomInAction;
import gov.nasa.giss.panoply.actions.PanMapZoomOutAction;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.text.DoubleDocument;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanMapControls
extends PanAbstractControlsPanel {
    private static Logger logger_ = LoggerFactory.getLogger(PanMapControls.class);
    private PanProjectionMenu projMenu_;
    private QuickBox projCenterBox_;
    private QuickBox copLonBox_;
    private QuickBox copLatBox_;
    private JTextField copLonTF_;
    private JTextField copLatTF_;
    private PanGridSpacingMenu gSpacingMenu_;
    private PanEnumMenu gStyleMenu_;
    private ColorMenu gColorMenu_;
    private PercentSpinner gOpacitySpinner_;
    private JCheckBox gLabelCB_;
    private PanOverlayMenu overlayMenu_;
    private ColorMenu oColorMenu_;
    private JCheckBox oInvertCB_;
    private PercentSpinner oOpacitySpinner_;
    private JButton fixRegionalButton_;
    private JButton fixConicButton_;
    private String lastproj_;
    private QuickBox[] paramBoxes_;
    private ProjField[] extraField_ = new ProjField[5];
    private PanMapZoomInAction zoominAction_ = new PanMapZoomInAction(this);
    private PanMapZoomOutAction zoomoutAction_ = new PanMapZoomOutAction(this);
    private boolean refreshing_;

    public PanMapControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("lonlat-map-controls", pmeta);
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        plotMenu.getItemByName("zoom-in").setAction(this.zoominAction_);
        plotMenu.getItemByName("zoom-out").setAction(this.zoomoutAction_);
        JLabel projLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Projection: ");
        this.projMenu_ = PanWidgetUtils.getProjectionMenu(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.projection", true, true);
        this.projMenu_.setSelectedItemByName(this.pmeta_.getString("plot:lonlat.map.projection"));
        QuickBox projMenu_Box = QuickBox.createLeftBox(projLabel, this.projMenu_);
        JLabel centerLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Center on: ");
        JLabel lonLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Lon. ");
        JLabel degELabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "\u00b0E");
        JLabel latLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Lat. ");
        JLabel degNLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "\u00b0N");
        this.copLonTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.center.lon", new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(this.pmeta_.getDouble("plot:lonlat.map.center.lon")), 5);
        this.copLatTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.center.lat", new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(this.pmeta_.getDouble("plot:lonlat.map.center.lat")), 5);
        this.copLonTF_.setHorizontalAlignment(4);
        this.copLatTF_.setHorizontalAlignment(4);
        this.copLonBox_ = QuickBox.createHorizontalBox(lonLabel, this.copLonTF_, degELabel);
        this.copLatBox_ = QuickBox.createLeftBox(latLabel, this.copLatTF_, degNLabel);
        this.projCenterBox_ = QuickBox.createLeftBox(centerLabel, this.copLonBox_, this.copLatBox_);
        this.paramBoxes_ = new QuickBox[]{QuickBox.createHorizontalBox(new Component[0]), QuickBox.createHorizontalBox(new Component[0])};
        JLabel gSpacingLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Grid Spacing: ");
        this.gSpacingMenu_ = PanWidgetUtils.getGridSpacingMenu(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.grid.spacing");
        this.gSpacingMenu_.setSelectedItem(this.pmeta_.get("plot:lonlat.map.grid.spacing"));
        JLabel gdegLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "\u00b0, ");
        this.gLabelCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.grid.label", "Show labels", this.pmeta_.getBoolean("plot:lonlat.map.grid.label"));
        QuickBox gSpacingBox = QuickBox.createLeftBox(gSpacingLabel, this.gSpacingMenu_, gdegLabel, this.gLabelCB_);
        JLabel gStyleLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Grid Style: ");
        this.gStyleMenu_ = PanWidgetUtils.getEnumMenu(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.grid.style", PanGridStyle.class);
        this.gStyleMenu_.setSelectedItem(this.pmeta_.getString("plot:lonlat.map.grid.style"));
        QuickBox gStyleBox = QuickBox.createLeftBox(gStyleLabel, this.gStyleMenu_);
        JLabel gColorLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Grid Color: ");
        this.gColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.grid.color", PaletteType.RAINBOW);
        this.gColorMenu_.setSelectedColor(this.pmeta_.getColor("plot:lonlat.map.grid.color"));
        JLabel gOpacityLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Opacity: ");
        this.gOpacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.grid.weight", this.pmeta_.getInt("plot:lonlat.map.grid.weight"));
        JLabel gPctLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "%");
        QuickBox gOpacityBox = QuickBox.createLeftBox(gColorLabel, this.gColorMenu_, gOpacityLabel, this.gOpacitySpinner_, gPctLabel);
        JLabel overlayLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Overlay Name: ");
        AbstractOverlay overlay = (AbstractOverlay)this.pmeta_.get("plot:lonlat.map.overlay");
        this.overlayMenu_ = PanWidgetUtils.getOverlayMenu(PanWidgetUtils.Size.SMALL, true);
        this.overlayMenu_.setSelectedItem(overlay);
        this.oInvertCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.overlay.invert", "Invert", this.pmeta_.getBoolean("plot:lonlat.map.overlay.invert"));
        this.oInvertCB_.setEnabled(overlay != null && overlay instanceof MaskOverlay);
        QuickBox overlayMenuBox = QuickBox.createLeftBox(overlayLabel, this.overlayMenu_, this.oInvertCB_);
        JLabel oColorLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Overlay Color: ");
        this.oColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.overlay.color", PaletteType.RAINBOW);
        this.oColorMenu_.setSelectedColor(this.pmeta_.getColor("plot:lonlat.map.overlay.color"));
        this.oColorMenu_.setEnabled(overlay != null);
        JLabel oOpacityLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Opacity: ");
        this.oOpacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.overlay.weight", this.pmeta_.getInt("plot:lonlat.map.overlay.weight"));
        this.oOpacitySpinner_.setEnabled(overlay != null);
        JLabel oPctLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "%");
        QuickBox oColorBox = QuickBox.createLeftBox(oColorLabel, this.oColorMenu_, oOpacityLabel, this.oOpacitySpinner_, oPctLabel);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRowWeight(4, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)projMenu_Box, new FGConstraint(0, 0, 0.0, 0.5));
        this.add((Component)this.projCenterBox_, new FGConstraint(0, 1, 0.0, 0.5));
        this.add((Component)this.paramBoxes_[0], new FGConstraint(0, 2, 0.0, 0.5));
        this.add((Component)this.paramBoxes_[1], new FGConstraint(0, 3, 0.0, 0.5));
        this.add((Component)gSpacingBox, new FGConstraint(1, 0, 0.0, 0.5));
        this.add((Component)gStyleBox, new FGConstraint(1, 1, 0.0, 0.5));
        this.add((Component)gOpacityBox, new FGConstraint(1, 2, 0.0, 0.5));
        this.add((Component)overlayMenuBox, new FGConstraint(1, 3, 0.0, 0.5));
        this.add((Component)oColorBox, new FGConstraint(1, 4, 0.0, 0.5));
        centerLabel.setPreferredSize(projLabel.getPreferredSize());
        centerLabel.setMaximumSize(centerLabel.getPreferredSize());
        int rlwidth = gSpacingLabel.getPreferredSize().width;
        rlwidth = Math.max(rlwidth, gColorLabel.getPreferredSize().width);
        rlwidth = Math.max(rlwidth, gStyleLabel.getPreferredSize().width);
        rlwidth = Math.max(rlwidth, overlayLabel.getPreferredSize().width);
        rlwidth = Math.max(rlwidth, oColorLabel.getPreferredSize().width);
        Dimension d = new Dimension(rlwidth, gSpacingLabel.getPreferredSize().height);
        gSpacingLabel.setPreferredSize(d);
        gSpacingLabel.setMinimumSize(d);
        gColorLabel.setPreferredSize(d);
        gColorLabel.setMinimumSize(d);
        gStyleLabel.setPreferredSize(d);
        gStyleLabel.setMinimumSize(d);
        overlayLabel.setPreferredSize(d);
        overlayLabel.setMinimumSize(d);
        oColorLabel.setPreferredSize(d);
        oColorLabel.setMinimumSize(d);
        this.refresh();
        this.addListeners();
    }

    public void setOverlay(AbstractOverlay o) {
        if (o != this.overlayMenu_.getOverlay()) {
            this.overlayMenu_.setSelectedItem(o);
        }
        this.pmeta_.put("plot:lonlat.map.overlay", (Object)o);
    }

    @Override
    public void refresh() {
        logger_.debug("");
        AbstractOverlay o = this.overlayMenu_.getOverlay();
        this.oInvertCB_.setEnabled(o != null && o instanceof MaskOverlay);
        this.oColorMenu_.setEnabled(o != null);
        this.oOpacitySpinner_.setEnabled(o != null);
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        String projname = proj.getName();
        this.gLabelCB_.setEnabled(proj.canLabelGrid());
        boolean sameProj = projname.equals(this.lastproj_);
        this.lastproj_ = projname;
        if (sameProj) {
            this.refreshParams(projmeta);
        } else {
            this.changeProjection(projmeta);
        }
        this.zoominAction_.setEnabled(this.canZoomIn());
        this.zoomoutAction_.setEnabled(this.canZoomOut());
        this.repaint();
    }

    private synchronized void refreshParams(PanProjectionMeta projmeta) {
        logger_.debug("");
        this.refreshing_ = true;
        AbstractProjection proj = projmeta.getProjection();
        String projname = proj.getName();
        int pcount = proj.getParameterCount();
        for (int i = 0; i < pcount; ++i) {
            String value = projmeta.getExtraParameter(i);
            if (value == null || value.length() == 0) continue;
            ProjField efield = this.extraField_[i];
            try {
                if (efield instanceof ProjDoubleField) {
                    ((ProjDoubleField)efield).setValue(TextUtilities.parseDouble(value));
                    continue;
                }
                if (efield instanceof ProjBooleanField) {
                    ((ProjBooleanField)efield).setSelected(Boolean.valueOf(value));
                    continue;
                }
                if (!(efield instanceof ProjListField)) continue;
                ((ProjListField)efield).setValue(value);
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        this.refreshing_ = false;
    }

    private void changeProjection(PanProjectionMeta projmeta) {
        logger_.debug("");
        AbstractProjection proj = projmeta.getProjection();
        String projname = proj.getName();
        if (proj.isOblique()) {
            this.copLonTF_.setEnabled(true);
            this.copLatTF_.setEnabled(true);
            this.copLatBox_.setVisible(true);
        } else if (proj.isInterrupted()) {
            this.copLonTF_.setEnabled(proj.isRecenterableLon());
            this.copLatTF_.setEnabled(false);
            this.copLatBox_.setVisible(false);
        } else {
            this.copLonTF_.setEnabled(true);
            this.copLatTF_.setEnabled(false);
            this.copLatBox_.setVisible(false);
        }
        this.paramBoxes_[0].removeAll();
        this.paramBoxes_[1].removeAll();
        int pcount = proj.getParameterCount();
        int pRow = 0;
        int pRowItem = 0;
        for (int i = 0; i < pcount; ++i) {
            ProjField efield;
            if (pRowItem > 0) {
                JLabel l = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", ");
                this.paramBoxes_[pRow].add(l);
            }
            final int pid = i;
            this.extraField_[i] = efield = proj.getParameterField(i);
            PanWidgetUtils.applySmallUI(efield);
            efield.setMaximumSize(efield.getPreferredSize());
            this.paramBoxes_[pRow].add(efield);
            if (efield instanceof ProjListField) {
                ++pRow;
                pRowItem = 0;
            } else if (++pRowItem > 2) {
                ++pRow;
                pRowItem = 0;
            }
            String value = projmeta.getExtraParameter(i);
            if (value == null || value.length() == 0) continue;
            try {
                if (efield instanceof ProjDoubleField) {
                    ((ProjDoubleField)efield).setValue(TextUtilities.parseDouble(value));
                } else if (efield instanceof ProjBooleanField) {
                    ((ProjBooleanField)efield).setSelected(Boolean.valueOf(value));
                } else if (efield instanceof ProjListField) {
                    ((ProjListField)efield).setValue(value);
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            efield.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanMapControls.this.handleExtraParam(efield, pid);
                }
            });
        }
        if (proj instanceof EquirectangularRegional) {
            if (this.fixRegionalButton_ == null) {
                this.fixRegionalButton_ = PanWidgetUtils.getButton(PanWidgetUtils.Size.SMALL, null, "Fix Proportions");
                this.fixRegionalButton_.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PanMapControls.this.fixRegional();
                    }
                });
            }
            this.paramBoxes_[1].add(this.fixRegionalButton_);
        } else if (proj.isConic()) {
            if (this.fixConicButton_ == null) {
                this.fixConicButton_ = PanWidgetUtils.getButton(PanWidgetUtils.Size.SMALL, null, "Autoset Parallels");
                this.fixConicButton_.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PanMapControls.this.fixConic();
                    }
                });
            }
            this.paramBoxes_[1].add(this.fixConicButton_);
        }
        this.paramBoxes_[0].add(Box.createHorizontalGlue());
        this.paramBoxes_[1].add(Box.createHorizontalGlue());
        PanPlotFrame pf = this.getParentFrame();
        if (pf != null) {
            this.paramBoxes_[0].invalidate();
            this.paramBoxes_[1].invalidate();
            this.invalidate();
            pf.validate();
        }
    }

    private void addListeners() {
        this.projMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                String name = ((PanProjectionMenu)e.getSource()).getSelectedItem().toString();
                PanMapControls.this.pmeta_.setString("plot:lonlat.map.projection", name);
            }
        });
        FocusListener lonlatFL = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PanMapControls.this.handleCenterTF();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        ActionListener lonlatAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanMapControls.this.handleCenterTF();
            }
        };
        this.copLonTF_.addFocusListener(lonlatFL);
        this.copLatTF_.addFocusListener(lonlatFL);
        this.copLonTF_.addActionListener(lonlatAL);
        this.copLatTF_.addActionListener(lonlatAL);
        this.gSpacingMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanMapControls.this.pmeta_.setDouble("plot:lonlat.map.grid.spacing", PanMapControls.this.gSpacingMenu_.getSpacing());
            }
        });
        this.gColorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Color cold;
                if (e.getStateChange() != 1) {
                    return;
                }
                Color cnew = PanMapControls.this.gColorMenu_.getSelectedColor();
                if (!cnew.equals(cold = PanMapControls.this.pmeta_.getColor("plot:lonlat.map.grid.color"))) {
                    PanMapControls.this.pmeta_.setColor("plot:lonlat.map.grid.color", cnew);
                }
            }
        });
        this.gOpacitySpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanMapControls.this.pmeta_.setInt("plot:lonlat.map.grid.weight", ((PercentSpinner)e.getSource()).getIntValue());
            }
        });
        this.gStyleMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanMapControls.this.pmeta_.put("plot:lonlat.map.grid.style", (Object)((PanMenuItemEnum)PanMapControls.this.gStyleMenu_.getSelectedItem()).getValue());
            }
        });
        this.gLabelCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanMapControls.this.pmeta_.setBoolean("plot:lonlat.map.grid.label", e.getStateChange() == 1);
            }
        });
        this.overlayMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanMapControls.this.pmeta_.put("plot:lonlat.map.overlay", (Object)PanMapControls.this.overlayMenu_.getOverlay());
            }
        });
        this.oInvertCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanMapControls.this.pmeta_.setBoolean("plot:lonlat.map.overlay.invert", e.getStateChange() == 1);
            }
        });
        this.oColorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Color cold;
                if (e.getStateChange() != 1) {
                    return;
                }
                Color cnew = PanMapControls.this.oColorMenu_.getSelectedColor();
                if (!cnew.equals(cold = PanMapControls.this.pmeta_.getColor("plot:lonlat.map.overlay.color"))) {
                    PanMapControls.this.pmeta_.setColor("plot:lonlat.map.overlay.color", cnew);
                }
            }
        });
        this.oOpacitySpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanMapControls.this.pmeta_.setInt("plot:lonlat.map.overlay.weight", ((PercentSpinner)e.getSource()).getIntValue());
            }
        });
    }

    private boolean isZoomable() {
        return this.pmeta_.getProjectionMeta().isZoomable();
    }

    public void setCenter(double lon, double lat) {
        double newlon;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Invalid latitude.");
        }
        double newlat = lat;
        for (newlon = lon; newlon > 180.0; newlon -= 360.0) {
        }
        while (newlon < -180.0) {
            newlon += 360.0;
        }
        if (this.copLonTF_.isEnabled()) {
            double oldLon = this.getCopLon();
            if (Double.isNaN(oldLon)) {
                oldLon = -9999.0;
            }
            if (newlon != oldLon) {
                this.copLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(newlon));
            }
        }
        if (this.copLatTF_.isEnabled()) {
            double oldLat = this.getCopLat();
            if (Double.isNaN(oldLat)) {
                oldLat = -9999.0;
            }
            if (newlat != oldLat) {
                this.copLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(newlat));
            }
        }
        if (this.pmeta_ != null) {
            this.pmeta_.setGroup(new String[]{"plot:lonlat.map.center.lon", "plot:lonlat.map.center.lat"}, new Object[]{newlon, newlat});
        }
    }

    private void handleCenterTF() {
        double lat;
        double lon = this.getCopLon();
        if (Double.isNaN(lon)) {
            lon = this.pmeta_.getDouble("plot:lonlat.map.center.lon");
            this.copLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(lon));
        }
        boolean shifted = false;
        while (lon > 180.0) {
            lon -= 360.0;
            shifted = true;
        }
        while (lon < -180.0) {
            lon += 360.0;
            shifted = true;
        }
        if (shifted) {
            this.copLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(lon));
        }
        if ((lat = this.getCopLat()) > 90.0) {
            lat = 90.0;
            this.copLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(90.0));
        } else if (lat < -90.0) {
            lat = -90.0;
            this.copLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(-90.0));
        }
        if (this.pmeta_ != null) {
            this.pmeta_.setGroup(new String[]{"plot:lonlat.map.center.lon", "plot:lonlat.map.center.lat"}, new Object[]{lon, lat});
        }
    }

    public void zoom(double factor) {
        String pname;
        logger_.debug("{}", (Object)factor);
        if (!this.isZoomable()) {
            return;
        }
        double lon = 0.0;
        double lat = 0.0;
        if (this.copLonTF_.isEnabled() && Double.isNaN(lon = this.getCopLon())) {
            logger_.warn("Using default longitude 0.");
            lon = 0.0;
        }
        if ((pname = this.pmeta_.getString("plot:lonlat.map.projection")).equals("Equirectangular")) {
            this.copLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(0.0));
            lat = 0.0;
        } else if (this.copLatTF_.isEnabled() && Double.isNaN(lat = this.getCopLat())) {
            logger_.warn("Using default latitude 0.");
            lat = 0.0;
        }
        this.zoom(factor, lon, lat);
    }

    public void zoom(double factor, double lon, double lat) {
        double oldLat;
        logger_.debug("{} X", (Object)factor);
        if (!this.isZoomable()) {
            return;
        }
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        if (!projmeta.isZoomable()) {
            return;
        }
        boolean onEDT = EventQueue.isDispatchThread();
        double oldLon = this.getCopLon();
        if (Double.isNaN(oldLon)) {
            oldLon = -9999.0;
        }
        if (lon != oldLon) {
            this.copLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(lon));
        }
        if (Double.isNaN(oldLat = this.getCopLat())) {
            oldLat = -9999.0;
        }
        if (lat != oldLat) {
            this.copLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(lat));
        }
        if (proj instanceof Equirectangular || proj instanceof EquirectangularRegional) {
            double w = 360.0;
            double h = 180.0;
            if (proj instanceof EquirectangularRegional) {
                try {
                    String wstr = projmeta.getExtraParameter(0);
                    String hstr = projmeta.getExtraParameter(1);
                    w = TextUtilities.parseDouble(wstr);
                    h = TextUtilities.parseDouble(hstr);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    return;
                }
            }
            w = Math.min(w / factor, 360.0);
            h = Math.min(h / factor, 180.0);
            if (w == 360.0 && h == 180.0) {
                this.projMenu_.setSelectedItemByName("Equirectangular");
                this.pmeta_.setGroup(new String[]{"plot:lonlat.map.projection", "plot:lonlat.map.center.lon", "plot:lonlat.map.center.lat", "plot:lonlat.map.param.0", "plot:lonlat.map.param.1"}, new Object[]{"Equirectangular", lon, lat, w, h});
            } else {
                this.projMenu_.setSelectedItemByName("Equirectangular (Regional)");
                this.pmeta_.setGroup(new String[]{"plot:lonlat.map.projection", "plot:lonlat.map.center.lon", "plot:lonlat.map.center.lat", "plot:lonlat.map.param.0", "plot:lonlat.map.param.1"}, new Object[]{"Equirectangular (Regional)", lon, lat, w, h});
            }
        } else if (proj.isAzimuthal() && !(proj instanceof VerticalPerspective)) {
            try {
                DoubleParameter rp = (DoubleParameter)proj.getParameter(0);
                double r = rp.getValue();
                r /= factor;
                r = Math.min(r, rp.getMaximum());
                r = Math.max(r, rp.getMinimum());
                if (this.pmeta_ != null) {
                    this.pmeta_.setGroup(new String[]{"plot:lonlat.map.center.lon", "plot:lonlat.map.center.lat", "plot:lonlat.map.param.0"}, new Object[]{lon, lat, r});
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return;
            }
        }
    }

    public void dragZoom(double clon, double clat, double llon, double tlat, double rlon, double blat) {
        double oldLat;
        logger_.debug("");
        if (!this.isZoomable()) {
            return;
        }
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        double oldLon = this.getCopLon();
        if (Double.isNaN(oldLon)) {
            oldLon = -9999.0;
        }
        if (clon != oldLon) {
            this.copLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(clon));
        }
        if (Double.isNaN(oldLat = this.getCopLat())) {
            oldLat = -9999.0;
        }
        if (clat != oldLat) {
            this.copLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(clat));
        }
        if (proj instanceof Equirectangular || proj instanceof EquirectangularRegional) {
            double w = Math.min(rlon - llon, 360.0);
            double h = Math.min(tlat - blat, 180.0);
            String pname = this.pmeta_.getString("plot:lonlat.map.projection");
            if (pname.equals("Equirectangular")) {
                this.projMenu_.setSelectedItemByName("Equirectangular (Regional)");
                this.pmeta_.setGroup(new String[]{"plot:lonlat.map.projection", "plot:lonlat.map.center.lon", "plot:lonlat.map.center.lat", "plot:lonlat.map.param.0", "plot:lonlat.map.param.1"}, new Object[]{"Equirectangular (Regional)", clon, clat, w, h});
            } else {
                this.pmeta_.setGroup(new String[]{"plot:lonlat.map.center.lon", "plot:lonlat.map.center.lat", "plot:lonlat.map.param.0", "plot:lonlat.map.param.1"}, new Object[]{clon, clat, w, h});
            }
        } else if (proj.isAzimuthal() && !(proj instanceof VerticalPerspective)) {
            DoubleParameter rp = (DoubleParameter)proj.getParameter(0);
            double r = Math.max(Math.abs(tlat - clat), Math.abs(blat - clat));
            r = Math.min(r, rp.getMaximum());
            r = Math.max(r, rp.getMinimum());
            this.pmeta_.setGroup(new String[]{"plot:lonlat.map.center.lon", "plot:lonlat.map.center.lat", "plot:lonlat.map.param.0"}, new Object[]{"Equirectangular (Regional)", clon, clat, r});
        } else {
            logger_.warn("Tried to set edges on non-zoomable projection.");
        }
    }

    private void setRegionalFields(double w, double h) {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        if (proj instanceof EquirectangularRegional) {
            ProjDoubleField wfield = (ProjDoubleField)this.extraField_[0];
            ProjDoubleField hfield = (ProjDoubleField)this.extraField_[1];
            wfield.setValue(w);
            hfield.setValue(h);
            if (this.pmeta_ != null) {
                this.pmeta_.setGroup(new String[]{"plot:lonlat.map.param.0", "plot:lonlat.map.param.1"}, new Object[]{w, h});
            }
        } else {
            logger_.warn("Tried to set regional width and height on non-ER projection.");
        }
    }

    public boolean canZoomIn() {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        return projmeta.canZoomIn();
    }

    public boolean canZoomOut() {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        return projmeta.canZoomOut();
    }

    private void handleExtraParam(ProjField pf, int pid) {
        if (this.refreshing_) {
            return;
        }
        try {
            PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
            AbstractProjection proj = projmeta.getProjection();
            this.pmeta_.setString("plot:lonlat.map.param." + pid, pf.getStringValue());
            if (proj.isInterrupted()) {
                this.copLonTF_.setEnabled(proj.isRecenterableLon());
                this.copLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(proj.getCenter().getLon()));
            }
        }
        catch (Exception exc) {
            logger_.warn("Could not parse parameter field value: []", (Object)pf.toString());
        }
    }

    private void fixRegional() {
        double lat;
        try {
            lat = TextUtilities.parseDouble(this.copLatTF_.getText());
        }
        catch (Exception exc) {
            return;
        }
        if (lat > 85.0) {
            lat = 85.0;
        } else if (lat < -85.0) {
            lat = -85.0;
        }
        double coslat = Math.cos(Math.toRadians(lat));
        ProjDoubleField wfield = (ProjDoubleField)this.extraField_[0];
        ProjDoubleField hfield = (ProjDoubleField)this.extraField_[1];
        double w1 = wfield.getValue();
        double h1 = hfield.getValue();
        double w2 = h1 * 2.0 / coslat;
        double h2 = h1;
        if (w2 > 360.0) {
            w2 = 360.0;
            h2 = w2 * 0.5 * coslat;
        }
        this.setRegionalFields(w2, h2);
    }

    private void fixConic() {
        double lat;
        try {
            lat = TextUtilities.parseDouble(this.copLatTF_.getText());
        }
        catch (Exception exc) {
            return;
        }
        ProjDoubleField p1field = (ProjDoubleField)this.extraField_[0];
        ProjDoubleField p2field = (ProjDoubleField)this.extraField_[1];
        ProjDoubleField hfield = (ProjDoubleField)this.extraField_[2];
        double h = hfield.getValue();
        if (h < 0.0) {
            h = 1.0;
        }
        double p1 = lat + 0.3 * h;
        double p2 = lat - 0.3 * h;
        if (p1 > 90.0) {
            p1 = 90.0;
        }
        if (p2 < -90.0) {
            p2 = -90.0;
        }
        p1field.setValue(p1);
        p2field.setValue(p2);
        if (this.pmeta_ != null) {
            this.pmeta_.setGroup(new String[]{"plot:lonlat.map.param.0", "plot:lonlat.map.param.1"}, new Object[]{p1, p2});
        }
    }

    private double getCopLon() {
        String s = this.copLonTF_.getText();
        try {
            return TextUtilities.parseDouble(s);
        }
        catch (Exception exc) {
            logger_.warn("Could not parse lon TF '{}'", (Object)s);
            return Double.NaN;
        }
    }

    private double getCopLat() {
        String s = this.copLatTF_.getText();
        try {
            return TextUtilities.parseDouble(s);
        }
        catch (Exception exc) {
            logger_.warn("Could not parse lat TF '{}')", (Object)s);
            return Double.NaN;
        }
    }

    @Override
    public synchronized void flush() {
        this.paramBoxes_[0].removeAll();
        this.paramBoxes_[1].removeAll();
        this.overlayMenu_.flush();
        this.overlayMenu_ = null;
        super.flush();
    }
}

