/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import ch.randelshofer.quaqua.QuaquaManager;
import gov.nasa.giss.panoply.PanHiddenMacFrame;
import gov.nasa.giss.panoply.PanSourcesFrame;
import java.util.HashSet;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanMacApplication {
    private static Logger logger_ = LoggerFactory.getLogger(PanMacApplication.class);

    public PanMacApplication() {
        this.initQuaqua();
        this.initProps();
        PanSourcesFrame.findFrame(true);
        this.initAdapter();
        PanHiddenMacFrame.findFrame(true).setVisible(true);
    }

    private void initQuaqua() {
        try {
            HashSet<String> includes = new HashSet<String>();
            includes.add("FileChooser");
            QuaquaManager.setIncludedUIs(includes);
            UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
        }
        catch (Exception exc) {
            logger_.warn("Quaqua problem!");
            exc.printStackTrace();
        }
    }

    private void initProps() {
        System.setProperty("apple.awt.showGrowBox", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Panoply");
        System.setProperty("apple.awt.antialiasing", "true");
        System.setProperty("apple.awt.textantialiasing", "true");
        System.setProperty("apple.awt.rendering", "VALUE_RENDER_QUALITY");
        System.setProperty("apple.awt.fractionalmetrics", "VALUE_FRACTIONALMETRICS_ON");
        try {
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void initAdapter() {
        try {
            Class<?> appClass = Class.forName("com.apple.eawt.Application");
            Object application = appClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> pmaClass = Class.forName("gov.nasa.giss.panoply.PanMacAdapter");
            Object adapter = pmaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            appClass.getMethod("setAboutHandler", Class.forName("com.apple.eawt.AboutHandler")).invoke(application, adapter);
            appClass.getMethod("setOpenFileHandler", Class.forName("com.apple.eawt.OpenFilesHandler")).invoke(application, adapter);
            appClass.getMethod("setPreferencesHandler", Class.forName("com.apple.eawt.PreferencesHandler")).invoke(application, adapter);
            appClass.getMethod("setQuitHandler", Class.forName("com.apple.eawt.QuitHandler")).invoke(application, adapter);
            return;
        }
        catch (NoClassDefFoundError err) {
            logger_.warn("Could not load latest Apple adapters (A). Trying old adapter.");
        }
        catch (ClassNotFoundException cnfe) {
            logger_.warn("Could not load latest Apple adapters (B). Trying old adapter.");
        }
        catch (Exception exc) {
            logger_.warn("Could not load latest Apple adapters (C). Trying old adapter.");
        }
        try {
            Class<?> appClass = Class.forName("com.apple.eawt.Application");
            Object application = appClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> pmaClass = Class.forName("gov.nasa.giss.panoply.PanMacAdapterOld");
            Object adapter = pmaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            appClass.getMethod("addApplicationListener", Class.forName("com.apple.eawt.ApplicationListener")).invoke(application, adapter);
            appClass.getMethod("setEnabledAboutMenu", Boolean.TYPE).invoke(application, Boolean.TRUE);
            appClass.getMethod("setEnabledPreferencesMenu", Boolean.TYPE).invoke(application, Boolean.TRUE);
        }
        catch (Exception exc) {
            logger_.warn("Apple extensions complained about using old adapter");
            exc.printStackTrace();
        }
    }
}

