/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.panoply.PanXVertGridControls;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.text.DoubleDocument;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;

public class PanLonVertGridControls
extends PanXVertGridControls {
    private JTextField minLonTF_;
    private JTextField maxLonTF_;
    private ColorMenu gColorMenu_;
    private PercentSpinner gOpacitySpinner_;

    public PanLonVertGridControls(PanPlotMeta pmeta) {
        super("lonvert-grid-controls", pmeta);
        this.createLayout();
        this.addVertControls();
        JLabel lonLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Lon Axis: ");
        JLabel lonLabel1 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Min ");
        JLabel lonLabel2 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "\u00b0E, Max ");
        JLabel lonLabel3 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "\u00b0E");
        this.minLonTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:xaxis.min", new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(this.pmeta_.getDouble("plot:xaxis.min")), 5);
        this.maxLonTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:xaxis.max", new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(this.pmeta_.getDouble("plot:xaxis.max")), 5);
        this.maxLonTF_.setHorizontalAlignment(4);
        this.minLonTF_.setHorizontalAlignment(4);
        QuickBox lonRangeBox = QuickBox.createLeftBox(lonLabel1, this.minLonTF_, lonLabel2, this.maxLonTF_, lonLabel3);
        JLabel gColorLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Grid Color: ");
        this.gColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.SMALL, "plot:grid.color", PaletteType.RAINBOW);
        this.gColorMenu_.setSelectedColor(this.pmeta_.getColor("plot:grid.color"));
        JLabel gOpacityLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Opacity: ");
        this.gOpacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.SMALL, "plot:grid.weight", this.pmeta_.getInt("plot:grid.weight"));
        JLabel gPctLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "%");
        QuickBox gColorBox = QuickBox.createLeftBox(this.gColorMenu_, gOpacityLabel, this.gOpacitySpinner_, gPctLabel);
        this.add((Component)lonLabel, new FGConstraint(3, 0, 0.0, 0.5));
        this.add((Component)lonRangeBox, new FGConstraint(4, 0, 0.0, 0.5));
        this.add((Component)gColorLabel, new FGConstraint(3, 1, 0.0, 0.5));
        this.add((Component)gColorBox, new FGConstraint(4, 1, 0.0, 0.5));
        this.attachVertListeners();
        this.attachOtherListeners();
    }

    private void attachOtherListeners() {
        this.gColorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Color cold;
                if (e.getStateChange() != 1) {
                    return;
                }
                Color cnew = PanLonVertGridControls.this.gColorMenu_.getSelectedColor();
                if (!cnew.equals(cold = PanLonVertGridControls.this.pmeta_.getColor("plot:grid.color"))) {
                    PanLonVertGridControls.this.pmeta_.setColor("plot:grid.color", cnew);
                }
            }
        });
        this.gOpacitySpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PercentSpinner spinner = (PercentSpinner)e.getSource();
                PanLonVertGridControls.this.pmeta_.setInt("plot:grid.weight", ((PercentSpinner)e.getSource()).getIntValue());
                spinner.repaint();
            }
        });
        FocusListener lonFL = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonVertGridControls.this.handleLonExtrema(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        ActionListener lonAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanLonVertGridControls.this.handleLonExtrema(e);
            }
        };
        this.maxLonTF_.addFocusListener(lonFL);
        this.minLonTF_.addFocusListener(lonFL);
        this.maxLonTF_.addActionListener(lonAL);
        this.minLonTF_.addActionListener(lonAL);
    }

    private void handleLonExtrema(EventObject e) {
        double max;
        double min;
        double oldmin = this.pmeta_.getDouble("plot:xaxis.min");
        double oldmax = this.pmeta_.getDouble("plot:xaxis.max");
        try {
            min = TextUtilities.parseDouble(this.minLonTF_.getText());
        }
        catch (Exception exc) {
            this.minLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmin));
            return;
        }
        if (min < -360.0) {
            min = -360.0;
            this.minLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(min));
        } else if (min >= 360.0) {
            min = 360.0;
            this.minLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(min));
        }
        try {
            max = TextUtilities.parseDouble(this.maxLonTF_.getText());
        }
        catch (Exception exc) {
            this.maxLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmax));
            return;
        }
        if (max <= min || max > min + 360.0) {
            max = min + 360.0;
            this.maxLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(max));
        }
        if (max > 360.0) {
            this.minLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(min -= 360.0));
            this.maxLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(max -= 360.0));
        }
        if (e.getSource() == this.maxLonTF_) {
            if (max <= min) {
                this.maxLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmax));
            } else {
                this.pmeta_.setDouble("plot:xaxis.max", max);
            }
        } else if (e.getSource() == this.minLonTF_) {
            if (min >= max) {
                this.minLonTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmin));
            } else {
                this.pmeta_.setDouble("plot:xaxis.min", min);
            }
        }
    }
}

