/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.gridder.NcGridderUtils;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanVertUnit;
import gov.nasa.giss.panoply.PanXVertData;
import java.awt.Dimension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonVertData
extends PanXVertData {
    private static Logger logger_ = LoggerFactory.getLogger(PanLonVertData.class);

    public PanLonVertData(NcArray2D nca2D, Dimension size) {
        this(nca2D, size.width, size.height);
    }

    public PanLonVertData(NcArray2D nca2D, int width, int height) {
        super(nca2D, width, height);
        this.setLonRange(-180.0, 180.0);
        this.setVertAxisScheme(PanPreferences.getPrefs().getString("plot:lonvert.vaxis.units"));
    }

    @Override
    public String getXAxisName() {
        return "Longitude";
    }

    @Override
    public String getXAxisUnits() {
        return "degree_east";
    }

    public boolean setLonRange(double west, double east) {
        if (east <= west) {
            east += 360.0;
        } else if (east - west > 360.0) {
            east = west + 360.0;
        }
        this.lBound_ = Math.max(-180.0, west);
        this.rBound_ = Math.min(360.0, east);
        this.setBoundsChanged();
        return true;
    }

    @Override
    protected void regridNoInterpolate(NcArray nca, double[] target) {
        int i;
        NcArray2D nca2D = (NcArray2D)nca;
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        int numXs = xAxis.getValues().length;
        int numYs = yAxis.getValues().length;
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block0: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            double top = 0.0;
            double bottom = 0.0;
            for (int jj = 0; jj < numYs; ++jj) {
                if (this.yAxisScheme_ == PanVertUnit.INDEX) {
                    top = jj;
                    bottom = jj + 1;
                } else {
                    top = yBounds[jj][0];
                    bottom = yBounds[jj][1];
                    if (nca2D == this.ncArrays_[1] && this.vertConverter2_ != null) {
                        top = this.vertConverter2_.convert(top);
                        bottom = this.vertConverter2_.convert(bottom);
                    }
                    if (this.yAxisScheme_ == PanVertUnit.LOG10) {
                        top = top > 0.0 ? Math.log10(top) : -50.0;
                        bottom = bottom > 0.0 ? Math.log10(bottom) : -50.0;
                    }
                }
                if (!(top > bottom && this.rowY_[j] <= top && this.rowY_[j] > bottom) && (!(this.rowY_[j] > top) || !(this.rowY_[j] <= bottom))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            for (int ii = 0; ii < numXs; ++ii) {
                double lon = this.colX_[i];
                if (lon < xBounds[ii][0]) {
                    lon += 360.0;
                } else if (lon > xBounds[ii][1]) {
                    lon -= 360.0;
                }
                if (!(lon >= xBounds[ii][0]) || !(lon < xBounds[ii][1])) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (i = 0; i < this.gridWidth_; ++i) {
            int j;
            if (srcCol[i] < 0) {
                for (j = 0; j < this.gridHeight_; ++j) {
                    this.setValue(target, i, j, Double.NaN);
                }
                continue;
            }
            for (j = 0; j < this.gridHeight_; ++j) {
                if (srcRow[j] < 0) continue;
                double value = nca2D.valueAt(srcCol[i], srcRow[j]);
                if (hasBad && nca2D.isMissingOrInvalid(value)) {
                    value = Double.NaN;
                }
                this.setValue(target, i, j, value);
            }
        }
    }

    @Override
    protected void regridInterpolate(NcArray nca, double[] target) {
        NcArray2D nca2D = (NcArray2D)nca;
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        double[] xValues = xAxis.getValues();
        double[] yValues = yAxis.getValues();
        double[][] xBounds = xAxis.getBounds();
        int numXs = xValues.length;
        int numYs = yValues.length;
        int lastX = xAxis.isWraparound() ? numXs : numXs - 1;
        for (int j = 0; j < numYs - 1; ++j) {
            double bottomY;
            double topY;
            double bottomV;
            double topV;
            int jP1 = j + 1;
            if (this.yAxisScheme_ == PanVertUnit.INDEX) {
                topV = (double)j + 0.5;
                bottomV = (double)jP1 + 0.5;
            } else {
                topV = yValues[j];
                bottomV = yValues[jP1];
                if (nca2D == this.ncArrays_[1] && this.vertConverter2_ != null) {
                    topV = this.vertConverter2_.convert(topV);
                    bottomV = this.vertConverter2_.convert(bottomV);
                }
                if (this.yAxisScheme_ == PanVertUnit.LOG10) {
                    topV = topV > 0.0 ? Math.log10(topV) : -50.0;
                    bottomV = bottomV > 0.0 ? Math.log10(bottomV) : -50.0;
                }
            }
            if (this.yAxisScheme_ == PanVertUnit.LOG10) {
                topY = (topV - this.logTBound_) * this.yPxlPer_;
                bottomY = (bottomV - this.logTBound_) * this.yPxlPer_;
            } else {
                topY = (topV - this.tBound_) * this.yPxlPer_;
                bottomY = (bottomV - this.tBound_) * this.yPxlPer_;
            }
            if (bottomY < 0.0 || topY >= (double)this.gridHeight_) continue;
            for (int i = 0; i < lastX; ++i) {
                double leftLon = xValues[i];
                int iP1 = i == numXs - 1 ? 0 : i + 1;
                double rightLon = xValues[iP1];
                if (leftLon >= rightLon) {
                    rightLon += 360.0;
                }
                if (rightLon < this.lBound_) {
                    leftLon += 360.0;
                    rightLon += 360.0;
                } else if (leftLon > this.rBound_) {
                    leftLon -= 360.0;
                    rightLon -= 360.0;
                }
                double valTL = nca2D.valueAt(i, j);
                double valTR = nca2D.valueAt(iP1, j);
                double valBL = nca2D.valueAt(i, jP1);
                double valBR = nca2D.valueAt(iP1, jP1);
                double leftX = (leftLon - this.lBound_) * this.xPxlPerDeg_;
                double rightX = (rightLon - this.lBound_) * this.xPxlPerDeg_;
                if (hasBad) {
                    if (nca2D.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                NcGridderUtils.bilinearInterpolateFill(leftX, topY, rightX, bottomY, valTL, valTR, valBL, valBR, target, this.gridWidth_, this.gridHeight_);
                if (leftLon < this.lBound_ && rightLon >= this.lBound_) {
                    leftLon += 360.0;
                    rightLon += 360.0;
                } else {
                    if (!(leftLon <= this.rBound_) || !(rightLon >= this.rBound_)) continue;
                    leftLon -= 360.0;
                    rightLon -= 360.0;
                }
                leftX = (leftLon - this.lBound_) * this.xPxlPerDeg_;
                rightX = (rightLon - this.lBound_) * this.xPxlPerDeg_;
                NcGridderUtils.bilinearInterpolateFill(leftX, topY, rightX, bottomY, valTL, valTR, valBL, valBR, target, this.gridWidth_, this.gridHeight_);
            }
        }
    }

    public void describeData(StringBuilder sb, int x, int y, boolean yAxisFlipped) {
        int yy = yAxisFlipped ? this.gridHeight_ - y : y;
        double lon = this.rBound_ - (double)x / this.xPxlPerDeg_;
        double vert = this.tBound_ + (double)yy / this.yPxlPer_;
        String vertUnits = this.getYAxis().getUnits();
        if (this.yAxisScheme_ == PanVertUnit.INDEX) {
            vert = (int)vert;
        } else if (this.yAxisScheme_ == PanVertUnit.LOG10) {
            vert = Math.pow(10.0, vert);
        }
        sb.append("Point: ");
        this.appendLon(sb, lon);
        sb.append(", ").append(this.scaleFormatter_.sprintf(vert));
        if (vertUnits != null && vertUnits.length() > 0) {
            sb.append(" ").append(vertUnits);
        }
        sb.append("\n");
        for (int i = 0; i < 2; ++i) {
            if (this.ncArrays_[i] == null || i == 0 && this.combination_ == PanCombinationType.A2_ONLY || i == 1 && this.combination_ == PanCombinationType.A1_ONLY) continue;
            NcArray2D nca2D = (NcArray2D)this.ncArrays_[i];
            int row = 0;
            if (this.yAxisScheme_ == PanVertUnit.INDEX) {
                row = (int)vert;
            } else {
                double val = vert;
                if (i == 1 && this.vertConverter1_ != null) {
                    val = this.vertConverter1_.convert(val);
                }
                row = nca2D.getYAxis().findNearestIndex(val);
            }
            int col = nca2D.getXAxis().findNearestIndex(lon);
            sb.append("Array ").append(i + 1).append(": ");
            nca2D.describeCell(col, row, sb, this.scaleFormatter_);
            sb.append("\n");
        }
    }

    private void appendLon(StringBuilder sb, double lon) {
        if (lon < 0.0) {
            sb.append(PanConstants.PFORMAT_D2.sprintf(-lon)).append("W");
        } else {
            sb.append(PanConstants.PFORMAT_D2.sprintf(lon)).append("E");
        }
    }
}

