/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.panoply.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.PanWidgetUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanLonLatZonalPrefsPanel
extends PanAbstractPrefsPanel {
    private JCheckBox southAtLeftCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "South at left?");
    private ColorMenu strokeColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.NORMAL, null, PaletteType.RAINBOW);
    private PercentSpinner gOpacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.NORMAL, null);

    public PanLonLatZonalPrefsPanel() {
        FlexingGridLayout fgl = new FlexingGridLayout(4, 3, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtilities.createPaddedTitleBorder("Zonal Averages Defaults"));
        this.add((Component)new JLabel("Lat Axis: "), new FGConstraint(0, 0, 1.0, 0.5));
        this.add((Component)this.southAtLeftCB_, new FGConstraint(1, 0, 0.0, 0.5));
        this.add((Component)new JLabel("Stroke Color: "), new FGConstraint(0, 1, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.strokeColorMenu_), new FGConstraint(1, 1, 0.0, 0.5));
        this.add((Component)new JLabel("Grid Opacity: "), new FGConstraint(0, 2, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.gOpacitySpinner_, new JLabel("%")), new FGConstraint(1, 2, 0.0, 0.5));
        this.refresh();
        this.gOpacitySpinner_.setMaximumSize(this.gOpacitySpinner_.getPreferredSize());
        this.southAtLeftCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanLonLatZonalPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setBoolean("plot:lonlat.zonal.lataxis.flipped", PanLonLatZonalPrefsPanel.this.southAtLeftCB_.isSelected());
            }
        });
        this.strokeColorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanLonLatZonalPrefsPanel.this.refreshing_) {
                    return;
                }
                int index = PanLonLatZonalPrefsPanel.this.strokeColorMenu_.getSelectedIndex();
                if (index < 0 || index >= PanLonLatZonalPrefsPanel.this.strokeColorMenu_.getItemCount()) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:lonlat.zonal.stroke.color", PanLonLatZonalPrefsPanel.this.strokeColorMenu_.getSelectedColor());
            }
        });
        this.gOpacitySpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PanLonLatZonalPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setInt("plot:lonlat.zonal.grid.weight", PanLonLatZonalPrefsPanel.this.gOpacitySpinner_.getIntValue());
            }
        });
    }

    @Override
    public void refresh() {
        this.refreshing_ = true;
        this.southAtLeftCB_.setSelected(PREFS.getBoolean("plot:lonlat.zonal.lataxis.flipped"));
        this.strokeColorMenu_.setSelectedColor(PREFS.getColor("plot:lonlat.zonal.stroke.color"));
        this.gOpacitySpinner_.setValue(PREFS.getInt("plot:lonlat.zonal.grid.weight"));
        this.refreshing_ = false;
    }
}

