/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.panoply.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanLonLatZonalControls
extends PanAbstractControlsPanel {
    public PanLonLatZonalControls(PanPlotMeta pmeta) {
        super("lonlat-zonal-controls", pmeta);
        JLabel directionLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Lat Axis Direction: ");
        final JCheckBox southAtLeftCB = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, "plot:lonlat.zonal.lataxis.flipped", "South at left?", this.pmeta_.getBoolean("plot:lonlat.zonal.lataxis.flipped"));
        QuickBox latAxisBox = QuickBox.createLeftBox(directionLabel, southAtLeftCB);
        JLabel opacityLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Grid Opacity: ");
        PercentSpinner gOpacitySpinner = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.SMALL, "plot:lonlat.zonal.grid.weight", this.pmeta_.getInt("plot:lonlat.zonal.grid.weight"));
        JLabel pctLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "%");
        QuickBox opacityBox = QuickBox.createLeftBox(opacityLabel, gOpacitySpinner, pctLabel);
        JLabel strokeLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Stroke Color: ");
        final ColorMenu strokeColorMenu = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.SMALL, "plot:lonlat.zonal.stroke.color", PaletteType.RAINBOW);
        strokeColorMenu.setSelectedColor(this.pmeta_.getColor("plot:lonlat.zonal.stroke.color"));
        QuickBox strokeBox = QuickBox.createLeftBox(strokeLabel, strokeColorMenu);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRowWeight(4, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.setOpaque(false);
        this.add((Component)latAxisBox, new FGConstraint(0, 0, 0.0, 0.5));
        this.add((Component)opacityBox, new FGConstraint(0, 1, 0.0, 0.5));
        this.add((Component)strokeBox, new FGConstraint(1, 0, 0.0, 0.5));
        southAtLeftCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanLonLatZonalControls.this.pmeta_.setBoolean("plot:lonlat.zonal.lataxis.flipped", southAtLeftCB.isSelected());
            }
        });
        gOpacitySpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanLonLatZonalControls.this.pmeta_.setInt("plot:lonlat.zonal.grid.weight", ((PercentSpinner)e.getSource()).getIntValue());
            }
        });
        strokeColorMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Color cold;
                if (e.getStateChange() != 1) {
                    return;
                }
                int index = ((ColorMenu)e.getSource()).getSelectedIndex();
                if (index < 0 || index >= strokeColorMenu.getItemCount()) {
                    return;
                }
                Color cnew = strokeColorMenu.getSelectedColor();
                if (!cnew.equals(cold = PanLonLatZonalControls.this.pmeta_.getColor("plot:lonlat.zonal.stroke.color"))) {
                    PanLonLatZonalControls.this.pmeta_.setColor("plot:lonlat.zonal.stroke.color", cnew);
                }
            }
        });
    }
}

