/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.panoply.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanLonLatMapPrefsPanel;
import gov.nasa.giss.panoply.PanLonLatZonalPrefsPanel;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanWidgetUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanLonLatPrefsPanel
extends PanAbstractPrefsPanel {
    private JComboBox lonlatTypeMenu_;
    private PanLonLatMapPrefsPanel mapPanel_;
    private PanLonLatZonalPrefsPanel zonalPanel_;

    public PanLonLatPrefsPanel() {
        JLabel topText = new JLabel("When creating a new lon-lat plot, set\u2026", 0);
        topText.setAlignmentX(0.5f);
        this.lonlatTypeMenu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.NORMAL, null);
        this.lonlatTypeMenu_.addItem(PanProperties.MENUS.getString("plot-type-m1"));
        this.lonlatTypeMenu_.addItem(PanProperties.MENUS.getString("plot-type-z1"));
        QuickBox typeBox = QuickBox.createCenterBox(new JLabel("Plot Type: "), this.lonlatTypeMenu_);
        this.mapPanel_ = new PanLonLatMapPrefsPanel();
        this.zonalPanel_ = new PanLonLatZonalPrefsPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(1, 8, 0, 2);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        int row = 0;
        this.add((Component)topText, new Point(0, row));
        this.add(Box.createVerticalStrut(2), new Point(0, ++row));
        this.add((Component)typeBox, new Point(0, ++row));
        this.add(Box.createVerticalStrut(2), new Point(0, ++row));
        this.add((Component)this.mapPanel_, new FGConstraint(new Rectangle(0, ++row, 1, 1), true));
        this.add(Box.createVerticalStrut(2), new Point(0, ++row));
        this.add((Component)this.zonalPanel_, new FGConstraint(new Rectangle(0, ++row, 1, 1), true));
        this.refresh();
        this.lonlatTypeMenu_.setMaximumSize(this.lonlatTypeMenu_.getPreferredSize());
        this.lonlatTypeMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanLonLatPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:lonlat.type", PanLonLatPrefsPanel.this.lonlatTypeMenu_.getSelectedItem());
            }
        });
    }

    @Override
    public void refresh() {
        this.refreshing_ = true;
        this.lonlatTypeMenu_.setSelectedItem(PREFS.getString("plot:lonlat.type"));
        this.mapPanel_.refresh();
        this.zonalPanel_.refresh();
        this.refreshing_ = false;
    }
}

