/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.gui.cursor.CursorUtilities;
import gov.nasa.giss.panoply.PanArrayDataPanel;
import gov.nasa.giss.panoply.PanMapControls;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPlotGlass;
import gov.nasa.giss.panoply.PanPlotMouseListener;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plot.PanPlotHolder;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatMouseListener
extends PanPlotMouseListener {
    private static Logger logger_ = LoggerFactory.getLogger(PanLonLatMouseListener.class);
    private PanLonLatPlot plot_;
    private PanMapControls mapControls_;
    private Rectangle currentRect_ = null;
    private Rectangle rectToDraw_ = null;
    private Rectangle previousRectDrawn_ = new Rectangle();
    private boolean dragInProgress_;
    private Point pressPt_;

    public PanLonLatMouseListener(PanPlotFrame frame) {
        super(frame);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Component c = e.getComponent();
        if (c == null || !(c instanceof PanPlotHolder)) {
            return;
        }
        PanPlotHolder ph = (PanPlotHolder)c;
        ph.requestFocus();
        PanPlotGlass glass = (PanPlotGlass)this.frame_.getGlassPane();
        glass.setContentType(PanPlotGlass.ContentType.NONE);
        glass.repaint();
        if (!this.getPlot().isMap()) {
            CursorUtilities.setDefaultCursor(this.frame_);
            return;
        }
        if (e.isPopupTrigger()) {
            return;
        }
        Point eventPt = e.getPoint();
        PointLL ll = this.transformXY2LL(eventPt);
        if (ll == null) {
            this.updateCursor(e);
            return;
        }
        int keyModifiers = this.getModifiers(e);
        if (keyModifiers == SHIFT_LIT) {
            this.getMapControls().setCenter(ll.getLon(), ll.getLat());
        } else if (keyModifiers == SHORTCUT_LIT) {
            if (this.getMapControls().canZoomIn()) {
                this.getMapControls().zoom(1.5, ll.getLon(), ll.getLat());
            }
        } else if (keyModifiers == (SHORTCUT_LIT | ALT_LIT)) {
            if (this.getMapControls().canZoomOut()) {
                this.getMapControls().zoom(0.6666666666666666, ll.getLon(), ll.getLat());
            }
        } else if (keyModifiers == ALT_LIT) {
            Point glassPt = SwingUtilities.convertPoint(ph, eventPt, glass);
            glass.setPoint(glassPt);
            glass.setText(ph.describePoint(eventPt.x, eventPt.y));
            glass.setContentType(PanPlotGlass.ContentType.TEXT_BOX);
            glass.repaint();
            PanArrayDataPanel[] dpanels = this.frame_.getArrayDataPanels();
            for (int i = 0; i < 2; ++i) {
                if (dpanels[i] == null) continue;
                dpanels[i].setSelectedCellNear(ll.getLon(), ll.getLat());
            }
        }
        this.updateCursor(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.updateCursor(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        CursorUtilities.setDefaultCursor(this.frame_);
        if (!this.dragInProgress_) {
            PanPlotGlass glass = (PanPlotGlass)this.frame_.getGlassPane();
            glass.setContentType(PanPlotGlass.ContentType.NONE);
            glass.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        PanPlotHolder plotHolder = this.frame_.getPlotHolder();
        plotHolder.requestFocus();
        if (!this.getPlot().isZoomableMap()) {
            CursorUtilities.setDefaultCursor(this.frame_);
            return;
        }
        this.pressPt_ = e.getPoint();
        PointLL ll = this.transformXY2LL(this.pressPt_);
        if (ll == null) {
            return;
        }
        PanPlotGlass glass = (PanPlotGlass)this.frame_.getGlassPane();
        Point glassPt = SwingUtilities.convertPoint(plotHolder, this.pressPt_, glass);
        this.currentRect_ = new Rectangle(glassPt.x, glassPt.y, 0, 0);
        this.updateDrawableRect(glass);
        glass.setRectangle(this.rectToDraw_);
        glass.setContentType(PanPlotGlass.ContentType.DRAG_FRAME);
        glass.repaint();
        this.dragInProgress_ = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragInProgress_ = false;
        int keyModifiers = this.getModifiers(e);
        if (this.getPlot().isZoomableMap() && keyModifiers == SHORTCUT_LIT) {
            this.updateDragRect(e);
            if (this.rectToDraw_ != null && (this.rectToDraw_.width > 1 || this.rectToDraw_.height > 1)) {
                Point releasePt = e.getPoint();
                Point centerPt = new Point((int)(0.5 * (double)(this.pressPt_.x + releasePt.x)), (int)(0.5 * (double)(this.pressPt_.y + releasePt.y)));
                PointLL ll0 = this.transformXY2LL(centerPt);
                PointLL ll1 = this.transformXY2LL(this.pressPt_);
                PointLL ll2 = this.transformXY2LL(releasePt);
                if (ll0 != null && ll1 != null && ll2 != null) {
                    double b;
                    double l = this.pressPt_.x < releasePt.x ? ll1.getLon() : ll2.getLon();
                    double t = this.pressPt_.y < releasePt.y ? ll1.getLat() : ll2.getLat();
                    double r = this.pressPt_.x < releasePt.x ? ll2.getLon() : ll1.getLon();
                    double d = b = this.pressPt_.y < releasePt.y ? ll2.getLat() : ll1.getLat();
                    if (r < l) {
                        r += 360.0;
                    }
                    this.getMapControls().dragZoom(ll0.getLon(), ll0.getLat(), l, t, r, b);
                }
            }
        }
        CursorUtilities.setDefaultCursor(this.frame_);
        PanPlotGlass glass = (PanPlotGlass)this.frame_.getGlassPane();
        glass.setContentType(PanPlotGlass.ContentType.NONE);
        glass.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.getPlot().isZoomableMap()) {
            this.updateDragRect(e);
        } else {
            CursorUtilities.setDefaultCursor(this.frame_);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.updateCursor(e);
        }
    }

    @Override
    protected void handleKeyEvent(KeyEvent e) {
        PanPlotHolder plotHolder = this.frame_.getPlotHolder();
        if (!plotHolder.isVisible()) {
            return;
        }
        if (!this.getPlot().isMap()) {
            return;
        }
        if (this.dragInProgress_) {
            int keyModifiers = this.getModifiers(e);
            int crw = this.currentRect_.width;
            int crh = this.currentRect_.height;
            if (keyModifiers == SHORTCUT_LIT || keyModifiers == (SHORTCUT_LIT | ALT_LIT)) {
                CursorUtilities.setZoomInCursor(this.frame_);
            } else if (crw < 0 && crh < 0) {
                this.frame_.setCursor(Cursor.getPredefinedCursor(6));
            } else if (crw >= 0 && crh < 0) {
                this.frame_.setCursor(Cursor.getPredefinedCursor(7));
            } else if (crw < 0 && crh >= 0) {
                this.frame_.setCursor(Cursor.getPredefinedCursor(4));
            } else {
                this.frame_.setCursor(Cursor.getPredefinedCursor(5));
            }
            this.frame_.repaint();
        } else {
            this.updateCursor(e);
        }
    }

    @Override
    protected void updateCursor(InputEvent e) {
        if (!this.getPlot().isMap()) {
            CursorUtilities.setDefaultCursor(this.frame_);
            return;
        }
        Point framePt = this.frame_.getMousePosition(true);
        if (framePt == null) {
            CursorUtilities.setDefaultCursor(this.frame_);
            return;
        }
        Point phPt = SwingUtilities.convertPoint(this.frame_, framePt, this.frame_.getPlotHolder());
        PointLL ll = this.transformXY2LL(phPt);
        if (ll == null) {
            CursorUtilities.setDefaultCursor(this.frame_);
            return;
        }
        int keyModifiers = this.getModifiers(e);
        if (keyModifiers == ALT_LIT) {
            CursorUtilities.setHelpCursor(this.frame_);
        } else if (keyModifiers == SHIFT_LIT) {
            CursorUtilities.setCrosshairCursor(this.frame_);
        } else if (keyModifiers == SHORTCUT_LIT) {
            if (this.getPlot().isZoomableMap()) {
                if (this.getMapControls().canZoomIn()) {
                    CursorUtilities.setZoomInCursor(this.frame_);
                } else {
                    CursorUtilities.setNoZoomCursor(this.frame_);
                }
            } else {
                CursorUtilities.setDefaultCursor(this.frame_);
            }
        } else if (keyModifiers == (SHORTCUT_LIT | ALT_LIT)) {
            if (this.getPlot().isZoomableMap()) {
                if (this.getMapControls().canZoomOut()) {
                    CursorUtilities.setZoomOutCursor(this.frame_);
                } else {
                    CursorUtilities.setNoZoomCursor(this.frame_);
                }
            } else {
                CursorUtilities.setDefaultCursor(this.frame_);
            }
        } else {
            CursorUtilities.setDefaultCursor(this.frame_);
        }
    }

    private void updateDragRect(MouseEvent e) {
        PanPlotGlass glass;
        if (e.getID() == 500) {
            this.rectToDraw_ = null;
            return;
        }
        Point eventPt = new Point(e.getPoint());
        PointLL ll = this.transformXY2LL(eventPt);
        if (ll == null) {
            return;
        }
        PanPlotHolder plotHolder = this.frame_.getPlotHolder();
        Point glassPt = SwingUtilities.convertPoint(plotHolder, eventPt, glass = (PanPlotGlass)this.frame_.getGlassPane());
        if (glassPt == null) {
            return;
        }
        this.currentRect_.setSize(glassPt.x - this.currentRect_.x, glassPt.y - this.currentRect_.y);
        this.updateDrawableRect(glass);
        Rectangle repaintRect = this.rectToDraw_.union(this.previousRectDrawn_);
        --repaintRect.x;
        --repaintRect.y;
        repaintRect.width += 2;
        repaintRect.height += 2;
        glass.setRectangle(this.rectToDraw_);
        glass.setContentType(PanPlotGlass.ContentType.DRAG_FRAME);
        glass.repaint(repaintRect.x, repaintRect.y, repaintRect.width, repaintRect.height);
        int keyModifiers = this.getModifiers(e);
        if (keyModifiers == SHORTCUT_LIT || keyModifiers == (SHORTCUT_LIT | ALT_LIT)) {
            CursorUtilities.setZoomInCursor(this.frame_);
        } else {
            int crw = this.currentRect_.width;
            int crh = this.currentRect_.height;
            if (crw < 0 && crh < 0) {
                this.frame_.setCursor(Cursor.getPredefinedCursor(6));
            } else if (crw >= 0 && crh < 0) {
                this.frame_.setCursor(Cursor.getPredefinedCursor(7));
            } else if (crw < 0 && crh >= 0) {
                this.frame_.setCursor(Cursor.getPredefinedCursor(4));
            } else {
                this.frame_.setCursor(Cursor.getPredefinedCursor(5));
            }
        }
    }

    private void updateDrawableRect(Component c) {
        this.updateDrawableRect(c.getWidth(), c.getHeight());
    }

    private void updateDrawableRect(int compWidth, int compHeight) {
        int x = this.currentRect_.x;
        int y = this.currentRect_.y;
        int width = this.currentRect_.width;
        int height = this.currentRect_.height;
        if (width < 0 && (x = x - (width = 0 - width) + 1) < 0) {
            width += x;
            x = 0;
        }
        if (height < 0 && (y = y - (height = 0 - height) + 1) < 0) {
            height += y;
            y = 0;
        }
        if (x + width > compWidth) {
            width = compWidth - x;
        }
        if (y + height > compHeight) {
            height = compHeight - y;
        }
        if (this.rectToDraw_ != null) {
            this.previousRectDrawn_.setBounds(this.rectToDraw_.x, this.rectToDraw_.y, this.rectToDraw_.width, this.rectToDraw_.height);
            this.rectToDraw_.setBounds(x, y, width, height);
        } else {
            this.rectToDraw_ = new Rectangle(x, y, width, height);
        }
    }

    private PointLL transformXY2LL(Point pt) {
        PanLonLatPlot plot = this.getPlot();
        return plot.transformXY2LL(pt.x - plot.getLocation().x, pt.y - plot.getLocation().y);
    }

    private PanLonLatPlot getPlot() {
        if (this.plot_ == null) {
            this.plot_ = (PanLonLatPlot)this.frame_.getPlot();
        }
        return this.plot_;
    }

    private PanMapControls getMapControls() {
        if (this.mapControls_ == null) {
            this.mapControls_ = (PanMapControls)this.frame_.findComponentNamed("lonlat-map-controls");
        }
        return this.mapControls_;
    }
}

