/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.map.overlay.AbstractOverlay;
import gov.nasa.giss.map.overlay.MaskOverlay;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.map.proj.gui.ProjBooleanField;
import gov.nasa.giss.map.proj.gui.ProjDoubleField;
import gov.nasa.giss.map.proj.gui.ProjField;
import gov.nasa.giss.map.proj.gui.ProjListField;
import gov.nasa.giss.panoply.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanEnumMenu;
import gov.nasa.giss.panoply.PanGridSpacingMenu;
import gov.nasa.giss.panoply.PanGridStyle;
import gov.nasa.giss.panoply.PanMenuItemEnum;
import gov.nasa.giss.panoply.PanOverlayMenu;
import gov.nasa.giss.panoply.PanProjectionMenu;
import gov.nasa.giss.panoply.PanProjectionPrefs;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanLonLatMapPrefsPanel
extends PanAbstractPrefsPanel {
    private PanProjectionMenu projectionMenu_;
    private JLabel centerLabel_;
    private JTextField copLonTF_;
    private JTextField copLatTF_;
    private QuickBox copLonBox_;
    private QuickBox copLatBox_;
    private PanGridSpacingMenu gSpacingMenu_;
    private PanEnumMenu gStyleMenu_;
    private ColorMenu gColorMenu_;
    private JCheckBox footnoteCB_;
    private PanOverlayMenu overlayMenu_;
    private ColorMenu oColorMenu_;
    private JCheckBox oInvertCB_;
    private PercentSpinner oOpacitySpinner_;
    private PercentSpinner gOpacitySpinner_;
    private QuickBox[] paramBoxes_;
    private final JLabel regLabel1_ = new JLabel("Width: ");
    private final JLabel regLabel2_ = new JLabel("\u00b0, Height: ");
    private final JLabel regLabel3_ = new JLabel("\u00b0");

    public PanLonLatMapPrefsPanel() {
        this.projectionMenu_ = PanWidgetUtils.getProjectionMenu(PanWidgetUtils.Size.NORMAL, null, true, true);
        this.centerLabel_ = new JLabel("Centered on: ");
        JLabel lonLabel = new JLabel("Lon. ");
        JLabel degELabel = new JLabel("\u00b0E");
        JLabel latLabel = new JLabel(", Lat. ");
        JLabel degNLabel = new JLabel("\u00b0N");
        this.copLonTF_ = new JTextField(PanConstants.PFORMAT_4G.sprintf(0.0), 5);
        this.copLatTF_ = new JTextField(PanConstants.PFORMAT_4G.sprintf(0.0), 5);
        this.copLonTF_.setMaximumSize(this.copLonTF_.getPreferredSize());
        this.copLatTF_.setMaximumSize(this.copLatTF_.getPreferredSize());
        this.copLonTF_.setHorizontalAlignment(4);
        this.copLatTF_.setHorizontalAlignment(4);
        this.copLonBox_ = QuickBox.createHorizontalBox(lonLabel, this.copLonTF_, degELabel);
        this.copLatBox_ = QuickBox.createLeftBox(latLabel, this.copLatTF_, degNLabel);
        this.footnoteCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Show projection footnote");
        this.paramBoxes_ = new QuickBox[]{QuickBox.createHorizontalBox(new Component[0]), QuickBox.createHorizontalBox(new Component[0])};
        this.gSpacingMenu_ = PanWidgetUtils.getGridSpacingMenu(PanWidgetUtils.Size.NORMAL, null);
        this.gStyleMenu_ = PanWidgetUtils.getEnumMenu(PanWidgetUtils.Size.NORMAL, null, PanGridStyle.class);
        this.gColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.NORMAL, null, PaletteType.RAINBOW);
        this.gOpacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.NORMAL, null, PREFS.getInt("plot:lonlat.map.grid.weight"));
        this.overlayMenu_ = new PanOverlayMenu(true);
        this.overlayMenu_.setToolTipText("Select continents overlay to apply to new plots");
        this.oInvertCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Invert");
        this.oColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.NORMAL, null, PaletteType.RAINBOW);
        this.oColorMenu_.setSelectedColor(PREFS.getColor("plot:lonlat.map.overlay.color"));
        this.oOpacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.NORMAL, null, PREFS.getInt("plot:lonlat.map.overlay.weight"));
        FlexingGridLayout fgl = new FlexingGridLayout(3, 12, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtilities.createPaddedTitleBorder("Map Defaults"));
        int row = 0;
        this.add((Component)new JLabel("Projection: "), new FGConstraint(0, row, 1.0, 0.5));
        this.add((Component)this.projectionMenu_, new FGConstraint(1, row, 0.0, 0.5));
        this.add((Component)this.centerLabel_, new FGConstraint(0, ++row, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.copLonBox_, this.copLatBox_), new FGConstraint(1, row, 0.0, 0.5));
        this.add((Component)this.paramBoxes_[0], new FGConstraint(1, ++row, 0.0, 0.5));
        this.add((Component)this.paramBoxes_[1], new FGConstraint(1, ++row, 0.0, 0.5));
        this.add(Box.createVerticalStrut(2), new FGConstraint(1, ++row, 0.0, 0.5));
        this.add((Component)new JLabel("Footnote: "), new FGConstraint(0, ++row, 1.0, 0.5));
        this.add((Component)this.footnoteCB_, new FGConstraint(1, row, 0.0, 0.5));
        this.add((Component)new JLabel("LL Grid: "), new FGConstraint(0, ++row, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Spacing: "), this.gSpacingMenu_, new JLabel("\u00b0")), new FGConstraint(1, row, 0.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Style: "), this.gStyleMenu_), new FGConstraint(1, ++row, 0.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Color: "), this.gColorMenu_, new JLabel(" Opacity: "), this.gOpacitySpinner_, new JLabel("%")), new FGConstraint(1, ++row, 0.0, 0.5));
        this.add(Box.createVerticalStrut(2), new FGConstraint(1, ++row, 0.0, 0.5));
        this.add((Component)new JLabel("Overlay: "), new FGConstraint(0, ++row, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.overlayMenu_, this.oInvertCB_), new FGConstraint(1, row, 0.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Color: "), this.oColorMenu_, new JLabel(" Opacity: "), this.oOpacitySpinner_, new JLabel("%")), new FGConstraint(1, ++row, 0.0, 0.5));
        this.refresh();
        this.projectionMenu_.setMaximumSize(this.projectionMenu_.getPreferredSize());
        this.gSpacingMenu_.setMaximumSize(this.gSpacingMenu_.getPreferredSize());
        this.gOpacitySpinner_.setMaximumSize(this.gOpacitySpinner_.getPreferredSize());
        this.oOpacitySpinner_.setMaximumSize(this.oOpacitySpinner_.getPreferredSize());
        TFActionListener tfAL = new TFActionListener();
        TFFocusListener tfFL = new TFFocusListener();
        this.copLonTF_.addFocusListener(tfFL);
        this.copLonTF_.addActionListener(tfAL);
        this.copLatTF_.addFocusListener(tfFL);
        this.copLatTF_.addActionListener(tfAL);
        this.projectionMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanLonLatMapPrefsPanel.this.projectionChanged();
            }
        });
        this.footnoteCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanLonLatMapPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setBoolean("plot:lonlat.map.projnote", e.getStateChange() == 1);
            }
        });
        this.gSpacingMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanLonLatMapPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setDouble("plot:lonlat.map.grid.spacing", PanLonLatMapPrefsPanel.this.gSpacingMenu_.getSpacing());
            }
        });
        this.gStyleMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanLonLatMapPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:lonlat.map.grid.style", ((PanMenuItemEnum)PanLonLatMapPrefsPanel.this.gStyleMenu_.getSelectedItem()).getValue());
            }
        });
        this.gColorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanLonLatMapPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:lonlat.map.grid.color", PanLonLatMapPrefsPanel.this.gColorMenu_.getSelectedColor());
            }
        });
        this.gOpacitySpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PanLonLatMapPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setInt("plot:lonlat.map.grid.weight", PanLonLatMapPrefsPanel.this.gOpacitySpinner_.getIntValue());
            }
        });
        this.overlayMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanLonLatMapPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:lonlat.map.overlay", PanLonLatMapPrefsPanel.this.overlayMenu_.getOverlay());
                PanLonLatMapPrefsPanel.this.oInvertCB_.setEnabled(PanLonLatMapPrefsPanel.this.overlayMenu_.getOverlay() != null && PanLonLatMapPrefsPanel.this.overlayMenu_.getOverlay() instanceof MaskOverlay);
            }
        });
        this.oOpacitySpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PanLonLatMapPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setInt("plot:lonlat.map.overlay.weight", PanLonLatMapPrefsPanel.this.oOpacitySpinner_.getIntValue());
            }
        });
        this.oInvertCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanLonLatMapPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setBoolean("plot:lonlat.map.overlay.invert", e.getStateChange() == 1);
            }
        });
        this.oColorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanLonLatMapPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:lonlat.map.overlay.color", PanLonLatMapPrefsPanel.this.oColorMenu_.getSelectedColor());
            }
        });
    }

    private void validateCOP() {
        try {
            double lon;
            if (lon < -180.0 || lon > 180.0) {
                for (lon = TextUtilities.parseDouble(this.copLonTF_.getText()); lon > 180.0; lon -= 360.0) {
                }
                while (lon < -180.0) {
                    lon += 360.0;
                }
                this.copLonTF_.setText(PanConstants.PFORMAT_2.sprintf(lon));
            }
        }
        catch (Exception exc) {
            this.copLonTF_.setText(PanConstants.PFORMAT_2.sprintf(0.0));
        }
        try {
            double lat = TextUtilities.parseDouble(this.copLatTF_.getText());
            if (lat < -90.0 || lat > 90.0) {
                lat = Math.min(lat, 90.0);
                lat = Math.max(lat, -90.0);
                this.copLatTF_.setText(PanConstants.PFORMAT_2.sprintf(lat));
            }
        }
        catch (Exception exc) {
            this.copLatTF_.setText(PanConstants.PFORMAT_2.sprintf(0.0));
        }
    }

    private void projectionChanged() {
        final String projname = this.projectionMenu_.getSelectedItem().toString();
        PREFS.set("plot:lonlat.map.projection", projname);
        final AbstractProjection proj = projname == "Equirectangular (Regional)" ? new EquirectangularRegional(1, 1) : ProjectionFactory.create(projname, 1, 1);
        try {
            proj.setCenter(PREFS.getDouble("plot:lonlat.map.center.lon"), PREFS.getDouble("plot:lonlat.map.center.lat"));
        }
        catch (Exception exc) {
            proj.setCenter(0.0, 0.0);
        }
        if (projname.equals("Equirectangular (Regional)") || proj.isOblique()) {
            this.copLonTF_.setEnabled(true);
            this.copLatTF_.setEnabled(true);
        } else if (proj.isInterrupted()) {
            this.copLonTF_.setEnabled(proj.isRecenterableLon());
            this.copLatTF_.setEnabled(false);
            double clon = proj.getCenter().getLon();
            PREFS.setDouble("plot:lonlat.map.center.lon", clon);
            this.copLonTF_.setText(PanConstants.PFORMAT_2.sprintf(clon));
        } else {
            this.copLonTF_.setEnabled(true);
            this.copLatTF_.setEnabled(false);
        }
        this.centerLabel_.setVisible(true);
        this.copLonBox_.setVisible(true);
        this.copLatBox_.setVisible(this.copLatTF_.isEnabled());
        this.paramBoxes_[0].removeAll();
        this.paramBoxes_[1].removeAll();
        int pcount = proj.getParameterCount();
        int pRow = 0;
        int pRowItem = 0;
        for (int i = 0; i < pcount; ++i) {
            if (pRowItem > 0) {
                this.paramBoxes_[pRow].add(new JLabel(", "));
            }
            final ProjField pf = proj.getParameterField(i);
            pf.setMaximumSize(pf.getPreferredSize());
            this.paramBoxes_[pRow].add(pf);
            final int pid = i;
            pf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanProjectionPrefs.setParam(projname, pid, pf.getStringValue());
                    if (proj.isInterrupted()) {
                        PanLonLatMapPrefsPanel.this.copLonTF_.setEnabled(proj.isRecenterableLon());
                        double clon = proj.getCenter().getLon();
                        PanAbstractPrefsPanel.PREFS.setDouble("plot:lonlat.map.center.lon", clon);
                        PanLonLatMapPrefsPanel.this.copLonTF_.setText(PanConstants.PFORMAT_2.sprintf(clon));
                    }
                }
            });
            if (pf instanceof ProjListField) {
                ++pRow;
                pRowItem = 0;
            } else if (++pRowItem > 1) {
                ++pRow;
                pRowItem = 0;
            }
            String value = PanProjectionPrefs.getParam(projname, i);
            if (value == null || value.length() == 0) continue;
            try {
                if (pf instanceof ProjDoubleField) {
                    ((ProjDoubleField)pf).setValue(TextUtilities.parseDouble(value));
                    continue;
                }
                if (pf instanceof ProjBooleanField) {
                    ((ProjBooleanField)pf).setSelected(Boolean.valueOf(value));
                    continue;
                }
                if (!(pf instanceof ProjListField)) continue;
                ((ProjListField)pf).setValue(value);
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        this.paramBoxes_[0].add(Box.createHorizontalGlue());
        this.paramBoxes_[1].add(Box.createHorizontalGlue());
        this.paramBoxes_[0].invalidate();
        this.paramBoxes_[1].invalidate();
        this.invalidate();
        JFrame f = (JFrame)this.getTopLevelAncestor();
        if (f != null) {
            this.invalidate();
            f.validate();
            f.pack();
        }
        this.repaint();
    }

    public void refreshProjList() {
        if (this.refreshing_) {
            return;
        }
        String oldName = this.projectionMenu_.getSelectedItem().toString();
        this.projectionMenu_.refresh();
        String newName = this.projectionMenu_.getSelectedItem().toString();
        if (!newName.equals(oldName)) {
            PREFS.set("plot:lonlat.map.projection", newName);
        }
    }

    @Override
    public void refresh() {
        this.refreshing_ = true;
        this.refreshProjList();
        this.projectionMenu_.setSelectedItemByName(PREFS.getString("plot:lonlat.map.projection"));
        this.projectionChanged();
        this.footnoteCB_.setSelected(PREFS.getBoolean("plot:lonlat.map.projnote"));
        this.copLonTF_.setText(PanConstants.PFORMAT_2.sprintf(PREFS.getDouble("plot:lonlat.map.center.lon")));
        this.copLatTF_.setText(PanConstants.PFORMAT_2.sprintf(PREFS.getDouble("plot:lonlat.map.center.lat")));
        this.gSpacingMenu_.setSelectedItem(PREFS.get("plot:lonlat.map.grid.spacing"));
        this.gStyleMenu_.setSelectedItem(PREFS.getString("plot:lonlat.map.grid.style"));
        this.gColorMenu_.setSelectedColor(PREFS.getColor("plot:lonlat.map.grid.color"));
        this.gOpacitySpinner_.setValue(PREFS.getInt("plot:lonlat.map.grid.weight"));
        this.overlayMenu_.setSelectedItem((AbstractOverlay)PREFS.get("plot:lonlat.map.overlay"));
        this.oInvertCB_.setSelected(PREFS.getBoolean("plot:lonlat.map.overlay.invert"));
        this.oColorMenu_.setSelectedColor(PREFS.getColor("plot:lonlat.map.overlay.color"));
        this.oOpacitySpinner_.setValue(PREFS.getInt("plot:lonlat.map.overlay.weight"));
        this.oInvertCB_.setEnabled(this.overlayMenu_.getOverlay() != null && this.overlayMenu_.getOverlay() instanceof MaskOverlay);
        this.refreshing_ = false;
    }

    private void handleTF() {
        this.validateCOP();
        PREFS.setDouble("plot:lonlat.map.center.lon", this.copLonTF_.getText());
        PREFS.setDouble("plot:lonlat.map.center.lat", this.copLatTF_.getText());
    }

    class TFFocusListener
    implements FocusListener {
        TFFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            PanLonLatMapPrefsPanel.this.handleTF();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    class TFActionListener
    implements ActionListener {
        TFActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PanLonLatMapPrefsPanel.this.handleTF();
        }
    }
}

