/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.array.NcArrayLonLat;
import gov.nasa.giss.netcdf.array.NcArrayLonLatAuxiliary;
import gov.nasa.giss.netcdf.array.NcArrayLonLatFvcomNodes;
import gov.nasa.giss.netcdf.array.NcArrayLonLatProjectedGrid;
import gov.nasa.giss.netcdf.array.NcArrayLonLatReducedType1;
import gov.nasa.giss.netcdf.array.NcArrayLonLatReducedType2;
import gov.nasa.giss.netcdf.array.NcArrayLonLatScatterNodes;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import gov.nasa.giss.panoply.PanAbstractData2D;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanConstants;
import java.awt.Dimension;
import java.awt.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatData
extends PanAbstractData2D {
    private static Logger logger_ = LoggerFactory.getLogger(PanLonLatData.class);
    private double tSecBound_;
    private double rSecBound_;
    private double bSecBound_;
    private double lSecBound_;

    public PanLonLatData(NcArray nca, Dimension size) {
        this(nca, size.width, size.height);
    }

    public PanLonLatData(NcArray nca, int w, int h) {
        super(nca, w, h);
        this.setGridEdges(-180.0, 90.0, 180.0, -90.0);
    }

    @Override
    public String getXAxisName() {
        return "Longitude";
    }

    @Override
    public String getXAxisUnits() {
        return "degree_east";
    }

    @Override
    public String getYAxisName() {
        return "Latitude";
    }

    @Override
    public String getYAxisUnits() {
        return "degree_north";
    }

    public double getRowAverage(int row) {
        double result = 0.0;
        int count = 0;
        for (int col = 0; col < this.gridWidth_; ++col) {
            double val = this.valueAt(col, row);
            if (Double.isNaN(val) || Double.isInfinite(val)) continue;
            result += val;
            ++count;
        }
        if (count == 0) {
            return Double.NaN;
        }
        if (count == 1) {
            return result;
        }
        return result /= (double)count;
    }

    public double getLogOfRowAverage(int row) {
        double result = this.getRowAverage(row);
        if (result <= 0.0) {
            return Double.NaN;
        }
        return Math.log10(result);
    }

    public boolean setGridEdges(double[] edges) {
        return this.setGridEdges(edges[0], edges[1], edges[2], edges[3]);
    }

    public boolean setGridEdges(double l, double t, double r, double b) {
        if (l == this.lBound_ && t == this.tBound_ && r == this.rBound_ && b == this.bBound_) {
            return false;
        }
        this.lBound_ = l;
        this.tBound_ = t;
        this.rBound_ = r;
        this.bBound_ = b;
        this.setBoundsChanged();
        return true;
    }

    @Override
    protected void updateGrid() {
        double dx = (this.rBound_ - this.lBound_) / (double)this.gridWidth_;
        double dy = (this.bBound_ - this.tBound_) / (double)this.gridHeight_;
        for (int i = 0; i < this.gridWidth_; ++i) {
            this.colX_[i] = this.lBound_ + ((double)i + 0.5) * dx;
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            this.rowY_[j] = this.tBound_ + ((double)j + 0.5) * dy;
        }
    }

    @Override
    protected void regridNoInterpolate(NcArray nca, double[] target) {
        this.useGridder(nca, target, false);
    }

    @Override
    protected void regridInterpolate(NcArray nca, double[] target) {
        this.useGridder(nca, target, true);
    }

    private void useGridder(NcArray nca, double[] target, boolean interpolated) {
        NcGridder gridder = nca.getGridder();
        gridder.setSize(this.gridWidth_, this.gridHeight_);
        gridder.setBounds(this.lBound_, this.tBound_, this.rBound_, this.bBound_);
        if (interpolated) {
            gridder.regridInterpolate(nca, target);
        } else {
            gridder.regridNoInterpolate(nca, target);
        }
    }

    public void describeData(StringBuilder sb, PointLL ll) {
        double lon;
        double lat = ll.getLat();
        for (lon = ll.getLon(); lon < this.lBound_; lon += 360.0) {
        }
        while (lon > this.rBound_) {
            lon -= 360.0;
        }
        int gridX = (int)((double)this.gridWidth_ * (lon - this.lBound_) / (this.rBound_ - this.lBound_));
        int gridY = (int)((double)this.gridHeight_ * (lat - this.tBound_) / (this.bBound_ - this.tBound_));
        double value = this.valueAt(gridX, gridY);
        double angle = Math.toDegrees(this.angleAt(gridX, gridY));
        sb.append("Point: ").append(PanLonLatData.formatLL(lon, lat)).append("\n");
        for (int i = 0; i < 2; ++i) {
            if (this.ncArrays_[i] == null || i == 0 && this.combination_ == PanCombinationType.A2_ONLY || i == 1 && this.combination_ == PanCombinationType.A1_ONLY) continue;
            sb.append("Array ").append(i + 1).append(": ");
            NcArray nca = this.ncArrays_[i];
            if (nca instanceof NcArrayLonLatProjectedGrid) {
                NcArrayLonLatProjectedGrid a = (NcArrayLonLatProjectedGrid)nca;
                Point p = a.findClosestPoint(lon, lat);
                if (p == null) {
                    a.describeCell(-1, -1, sb, null);
                } else {
                    a.describeCell(p.x, p.y, sb, this.scaleFormatter_);
                }
            } else if (nca instanceof NcArrayLonLatAuxiliary) {
                NcArrayLonLatAuxiliary a = (NcArrayLonLatAuxiliary)nca;
                Point p = a.findClosestPoint(lon, lat);
                if (p == null) {
                    a.describeCell(-1, -1, sb, null);
                } else {
                    a.describeCell(p.x, p.y, sb, this.scaleFormatter_);
                }
            } else if (!(nca instanceof NcArrayLonLatReducedType1) && !(nca instanceof NcArrayLonLatReducedType2)) {
                if (nca instanceof NcArrayLonLatFvcomNodes) {
                    NcArrayLonLatFvcomNodes a = (NcArrayLonLatFvcomNodes)nca;
                    int node = a.findClosestNode(lon, lat);
                    a.describeNode(node, sb, PanConstants.PFORMAT_D3, this.scaleFormatter_);
                } else if (nca instanceof NcArrayLonLatScatterNodes) {
                    NcArrayLonLatScatterNodes a = (NcArrayLonLatScatterNodes)nca;
                    int node = a.findClosestNode(lon, lat);
                    a.describeNode(node, sb, PanConstants.PFORMAT_D3, this.scaleFormatter_);
                } else {
                    int col = ((NcArray2D)nca).getXAxis().findNearestIndex(lon);
                    int row = ((NcArray2D)nca).getYAxis().findNearestIndex(lat);
                    ((NcArrayLonLat)nca).describeCell(col, row, sb, this.scaleFormatter_);
                }
            }
            sb.append("\n");
        }
    }

    private static String formatLL(double lon, double lat) {
        double xlon;
        for (xlon = lon; xlon <= -180.0; xlon += 360.0) {
        }
        while (xlon > 180.0) {
            xlon -= 360.0;
        }
        StringBuilder sb = new StringBuilder();
        if (xlon < 0.0) {
            sb.append(PanConstants.PFORMAT_D3.sprintf(-xlon)).append("W ");
        } else {
            sb.append(PanConstants.PFORMAT_D3.sprintf(xlon)).append("E ");
        }
        if (lat < 0.0) {
            sb.append(PanConstants.PFORMAT_D3.sprintf(-lat)).append("S");
        } else {
            sb.append(PanConstants.PFORMAT_D3.sprintf(lat)).append("N");
        }
        return sb.toString();
    }
}

