/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanLoadRemoteDialog
extends JDialog {
    private static final String[] LOAD_MESSAGE = new String[]{"Enter URL of a remote dataset to open:", "Enter URL of a remote catalog to open:"};
    private JTextArea urlField_;
    private boolean success_;

    public PanLoadRemoteDialog(JFrame jf, RemoteType rtype) {
        super(jf, "Enter URL", true);
        JLabel label = new JLabel();
        if (rtype == RemoteType.FILE) {
            label.setText(LOAD_MESSAGE[0]);
        } else {
            label.setText(LOAD_MESSAGE[1]);
        }
        this.urlField_ = new JTextArea(3, 40);
        JButton cancelButton = new JButton("Cancel");
        JButton openButton = new JButton("Load");
        QuickBox buttonBox = PlatformUtilities.isMacintosh() ? QuickBox.createRightBox(cancelButton, openButton) : QuickBox.createRightBox(openButton, cancelButton);
        int mw = Math.max(label.getMinimumSize().width, 300);
        Dimension d = new Dimension(mw, 144);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(3, 3, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(PanGuiConstants.STD_BORDER);
        contentPanel.add((Component)label, new FGConstraint(0, 0, 0.0, 0.5));
        contentPanel.add((Component)this.urlField_, new FGConstraint(0, 1, 2, 1, 0.0, 0.5));
        contentPanel.add((Component)buttonBox, new FGConstraint(0, 2, 3, 1, 1.0, 0.5));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(openButton);
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanLoadRemoteDialog.this.success_ = true;
                PanLoadRemoteDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanLoadRemoteDialog.this.setVisible(false);
            }
        });
        this.pack();
        Rectangle rr = jf.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.urlField_.grabFocus();
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public String getUrlString() {
        return this.urlField_.getText();
    }

    public static enum RemoteType {
        FILE,
        CATALOG;

    }
}

