/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.netcdf.NcGribUtilities;
import gov.nasa.giss.panoply.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanHistoryList;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.PanWidgetUtils;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class PanLaunchPrefsPanel
extends PanAbstractPrefsPanel {
    private JCheckBox splashAtLaunchCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Show splash window at launch");
    private JCheckBox fileDialogAtLaunchCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Show open-file dialog at launch");
    private JCheckBox expandNodesCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Expand newly opened file nodes in datasets tree");
    private JCheckBox strictGribCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Open GRIB-1 datasets in strict mode");
    private JComboBox historyMenu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.NORMAL, null, new Object[]{new Integer("1"), new Integer("2"), new Integer("3"), new Integer("7"), new Integer("14"), new Integer("30"), new Integer("45"), new Integer("60"), new Integer("90"), new Integer("365")});

    public PanLaunchPrefsPanel() {
        Dimension d = this.expandNodesCB_.getPreferredSize();
        d.width += 15;
        this.expandNodesCB_.setPreferredSize(d);
        this.strictGribCB_.setPreferredSize(d);
        this.expandNodesCB_.setMinimumSize(d);
        this.strictGribCB_.setMinimumSize(d);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtilities.createPaddedTitleBorder("Launch / Open"));
        this.add(QuickBox.createLeftBox(this.splashAtLaunchCB_));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(this.fileDialogAtLaunchCB_));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(this.expandNodesCB_));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(this.strictGribCB_));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(new JLabel("Remove history items after "), this.historyMenu_, new JLabel(" days")));
        this.refresh();
        this.historyMenu_.setMaximumSize(this.historyMenu_.getPreferredSize());
        this.splashAtLaunchCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanLaunchPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setBoolean("launch:splash", PanLaunchPrefsPanel.this.splashAtLaunchCB_.isSelected());
            }
        });
        this.fileDialogAtLaunchCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanLaunchPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setBoolean("launch:dialog", PanLaunchPrefsPanel.this.fileDialogAtLaunchCB_.isSelected());
            }
        });
        this.expandNodesCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanSourcesFrame sourcesFrame;
                if (!PanLaunchPrefsPanel.this.refreshing_) {
                    PanAbstractPrefsPanel.PREFS.setBoolean("sources:nodes.expanded", PanLaunchPrefsPanel.this.expandNodesCB_.isSelected());
                }
                if ((sourcesFrame = PanSourcesFrame.findFrame(false)) != null) {
                    sourcesFrame.refresh();
                }
            }
        });
        this.strictGribCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PanLaunchPrefsPanel.this.refreshing_) {
                    boolean strict = PanLaunchPrefsPanel.this.strictGribCB_.isSelected();
                    PanAbstractPrefsPanel.PREFS.setBoolean("grib:strict", strict);
                    NcGribUtilities.setGrib1Strict(strict);
                }
            }
        });
        this.historyMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanLaunchPrefsPanel.this.refreshing_) {
                    return;
                }
                String s = PanLaunchPrefsPanel.this.historyMenu_.getSelectedItem().toString();
                try {
                    int val = Integer.parseInt(s);
                    PanAbstractPrefsPanel.PREFS.setInt("history:days", val);
                    PanHistoryList.getList().enforceAgeLimit(val);
                    PanFrame pf = (PanFrame)GuiUtilities.getParentFrame(PanLaunchPrefsPanel.this.historyMenu_);
                    PanMenuBar mb = pf.getPanMenuBar();
                    mb.refresh();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void refresh() {
        this.refreshing_ = true;
        this.splashAtLaunchCB_.setSelected(PREFS.getBoolean("launch:splash"));
        this.fileDialogAtLaunchCB_.setSelected(PREFS.getBoolean("launch:dialog"));
        this.expandNodesCB_.setSelected(PREFS.getBoolean("sources:nodes.expanded"));
        this.strictGribCB_.setSelected(PREFS.getBoolean("grib:strict"));
        this.historyMenu_.setSelectedItem(PREFS.get("history:days"));
        this.refreshing_ = false;
    }
}

