/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.panoply.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.PanEnumMenu;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanMenuItemEnum;
import gov.nasa.giss.panoply.PanNumberFormatMenu;
import gov.nasa.giss.panoply.PanVertUnit;
import gov.nasa.giss.panoply.PanWidgetUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanLatVertPrefsPanel
extends PanAbstractPrefsPanel {
    final JCheckBox southAtLeftCB_;
    final PanEnumMenu yUnitsMenu_;
    final PanNumberFormatMenu yFormatMenu_;
    private ColorMenu gColorMenu_;
    private PercentSpinner gOpacitySpinner_;

    public PanLatVertPrefsPanel() {
        JLabel topText = new JLabel("When creating a new lat-vert plot, set\u2026", 2);
        topText.setAlignmentX(0.5f);
        this.southAtLeftCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "South at left?");
        this.yUnitsMenu_ = PanWidgetUtils.getEnumMenu(PanWidgetUtils.Size.NORMAL, null, PanVertUnit.class);
        this.yFormatMenu_ = PanWidgetUtils.getNumberFormatMenu(PanWidgetUtils.Size.NORMAL, null);
        this.gColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.NORMAL, null, PaletteType.RAINBOW);
        this.gOpacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.NORMAL, null, PREFS.getInt("plot:latvert.grid.weight"));
        FlexingGridLayout fgl = new FlexingGridLayout(3, 6, 0, 2);
        this.setBorder(PanGuiConstants.STD_BORDER);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 3, 1));
        this.add(Box.createVerticalStrut(2), new FGConstraint(1, 1, 0.0, 0.5));
        this.add((Component)new JLabel("Lat Axis: "), new FGConstraint(0, 2, 1.0, 0.5));
        this.add((Component)this.southAtLeftCB_, new FGConstraint(1, 2, 2, 1, 0.0, 0.5));
        this.add((Component)new JLabel("Vert Axis Units: "), new FGConstraint(0, 3, 1.0, 0.5));
        this.add((Component)this.yUnitsMenu_, new FGConstraint(1, 3, 0.0, 0.5));
        this.add((Component)new JLabel("Vert Axis Format: "), new FGConstraint(0, 4, 1.0, 0.5));
        this.add((Component)this.yFormatMenu_, new FGConstraint(1, 4, 2, 1, 0.0, 0.5));
        this.add((Component)new JLabel("Grid Color: "), new FGConstraint(0, 5, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.gColorMenu_, new JLabel(" Opacity: "), this.gOpacitySpinner_, new JLabel("%")), new FGConstraint(1, 5, 0.0, 0.5));
        this.refresh();
        this.yUnitsMenu_.setMaximumSize(this.yUnitsMenu_.getPreferredSize());
        this.yFormatMenu_.setMaximumSize(this.yFormatMenu_.getPreferredSize());
        this.gOpacitySpinner_.setMaximumSize(this.gOpacitySpinner_.getPreferredSize());
        this.southAtLeftCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanLatVertPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setBoolean("plot:latvert.lataxis.flipped", PanLatVertPrefsPanel.this.southAtLeftCB_.isSelected());
            }
        });
        this.yUnitsMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanLatVertPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:latvert.vaxis.units", ((PanMenuItemEnum)PanLatVertPrefsPanel.this.yUnitsMenu_.getSelectedItem()).getValue());
            }
        });
        this.yFormatMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanLatVertPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:latvert.vaxis.format", PanLatVertPrefsPanel.this.yFormatMenu_.getSelectedItem().toString());
            }
        });
        this.gColorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanLatVertPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:latvert.grid.color", PanLatVertPrefsPanel.this.gColorMenu_.getSelectedColor());
            }
        });
        this.gOpacitySpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PanLatVertPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setInt("plot:latvert.grid.weight", PanLatVertPrefsPanel.this.gOpacitySpinner_.getIntValue());
            }
        });
    }

    @Override
    public void refresh() {
        this.refreshing_ = true;
        this.southAtLeftCB_.setSelected(PREFS.getBoolean("plot:latvert.lataxis.flipped"));
        this.yUnitsMenu_.setSelectedItem(PREFS.getString("plot:latvert.vaxis.units"));
        this.yFormatMenu_.setSelectedItem(PREFS.getString("plot:latvert.vaxis.format"));
        this.gColorMenu_.setSelectedColor(PREFS.getColor("plot:latvert.grid.color"));
        this.gOpacitySpinner_.setValue(PREFS.getInt("plot:latvert.grid.weight"));
        this.refreshing_ = false;
    }
}

