/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.panoply.PanXVertGridControls;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.text.DoubleDocument;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;

public class PanLatVertGridControls
extends PanXVertGridControls {
    private JTextField minLatTF_;
    private JTextField maxLatTF_;
    private JCheckBox southAtLeftCB_;
    private ColorMenu gColorMenu_;
    private PercentSpinner gOpacitySpinner_;

    public PanLatVertGridControls(PanPlotMeta pmeta) {
        super("latvert-grid-controls", pmeta);
        this.createLayout();
        this.addVertControls();
        JLabel latLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Lat Axis: ");
        JLabel latLabel1 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Min ");
        JLabel latLabel2 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "\u00b0N, Max ");
        JLabel latLabel3 = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "\u00b0N");
        this.maxLatTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:xaxis.max", new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(this.pmeta_.getDouble("plot:xaxis.max")), 5);
        this.minLatTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:xaxis.min", new DoubleDocument(), PanConstants.PFORMAT_4G.sprintf(this.pmeta_.getDouble("plot:xaxis.min")), 5);
        this.maxLatTF_.setHorizontalAlignment(4);
        this.minLatTF_.setHorizontalAlignment(4);
        QuickBox latRangeBox = QuickBox.createLeftBox(latLabel1, this.minLatTF_, latLabel2, this.maxLatTF_, latLabel3);
        this.southAtLeftCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, "plot:latvert.lataxis.flipped", "South at left?", this.pmeta_.getBoolean("plot:latvert.lataxis.flipped"));
        QuickBox xDirectionBox = QuickBox.createLeftBox(this.southAtLeftCB_);
        JLabel gColorLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Grid Color: ");
        this.gColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.SMALL, "plot:grid.color", PaletteType.RAINBOW);
        this.gColorMenu_.setSelectedColor(this.pmeta_.getColor("plot:grid.color"));
        JLabel gOpacityLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Opacity: ");
        this.gOpacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.SMALL, "plot:grid.weight", this.pmeta_.getInt("plot:grid.weight"));
        JLabel gPctLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "%");
        QuickBox gColorBox = QuickBox.createLeftBox(this.gColorMenu_, gOpacityLabel, this.gOpacitySpinner_, gPctLabel);
        this.add((Component)latLabel, new FGConstraint(3, 0, 0.0, 0.5));
        this.add((Component)latRangeBox, new FGConstraint(4, 0, 0.0, 0.5));
        this.add((Component)xDirectionBox, new FGConstraint(4, 1, 0.0, 0.5));
        this.add((Component)gColorLabel, new FGConstraint(3, 2, 0.0, 0.5));
        this.add((Component)gColorBox, new FGConstraint(4, 2, 0.0, 0.5));
        this.attachVertListeners();
        this.attachOtherListeners();
    }

    private void attachOtherListeners() {
        this.gColorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Color cold;
                if (e.getStateChange() != 1) {
                    return;
                }
                Color cnew = PanLatVertGridControls.this.gColorMenu_.getSelectedColor();
                if (!cnew.equals(cold = PanLatVertGridControls.this.pmeta_.getColor("plot:grid.color"))) {
                    PanLatVertGridControls.this.pmeta_.setColor("plot:grid.color", cnew);
                }
            }
        });
        this.gOpacitySpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PercentSpinner spinner = (PercentSpinner)e.getSource();
                PanLatVertGridControls.this.pmeta_.setInt("plot:grid.weight", ((PercentSpinner)e.getSource()).getIntValue());
                spinner.repaint();
            }
        });
        FocusListener latFL = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLatVertGridControls.this.handleLatExtrema(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        ActionListener latAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanLatVertGridControls.this.handleLatExtrema(e);
            }
        };
        this.maxLatTF_.addFocusListener(latFL);
        this.minLatTF_.addFocusListener(latFL);
        this.maxLatTF_.addActionListener(latAL);
        this.minLatTF_.addActionListener(latAL);
        this.southAtLeftCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanLatVertGridControls.this.pmeta_.setBoolean("plot:latvert.lataxis.flipped", PanLatVertGridControls.this.southAtLeftCB_.isSelected());
            }
        });
    }

    private void handleLatExtrema(EventObject e) {
        double max = 90.0;
        double min = 90.0;
        double oldmax = this.pmeta_.getDouble("plot:xaxis.max");
        double oldmin = this.pmeta_.getDouble("plot:xaxis.min");
        if (e == null || e.getSource() == this.maxLatTF_) {
            try {
                max = TextUtilities.parseDouble(this.maxLatTF_.getText());
            }
            catch (Exception exc) {
                this.maxLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmax));
                return;
            }
            if (max > 90.0) {
                max = 90.0;
                this.maxLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(90));
            }
        } else {
            max = oldmax;
        }
        if (e == null || e.getSource() == this.minLatTF_) {
            try {
                min = TextUtilities.parseDouble(this.minLatTF_.getText());
            }
            catch (Exception exc) {
                this.minLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmin));
                return;
            }
            if (min < -90.0) {
                min = -90.0;
                this.minLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(-90));
            }
        } else {
            min = oldmin;
        }
        if (e == null) {
            this.pmeta_.setDouble("plot:xaxis.min", min);
            this.pmeta_.setDouble("plot:xaxis.max", max);
        } else if (e.getSource() == this.maxLatTF_) {
            if (max <= min) {
                this.maxLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmax));
            } else {
                this.pmeta_.setDouble("plot:xaxis.max", max);
            }
        } else if (e.getSource() == this.minLatTF_) {
            if (min >= max) {
                this.minLatTF_.setText(PanConstants.PFORMAT_4G.sprintf(oldmin));
            } else {
                this.pmeta_.setDouble("plot:xaxis.min", min);
            }
        }
    }
}

