/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.menu.GissMenu;
import gov.nasa.giss.panoply.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.PanFileUtilities;
import gov.nasa.giss.panoply.PanFontMenu;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPlotType;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanLabelControls
extends PanAbstractControlsPanel {
    private JTextField nameTF_;
    private JTextField titleTF_;
    private JTextField subtitleTF_;
    private ColorMenu bColorMenu_;
    private Action backgroundAction_;

    public PanLabelControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("label-controls", pmeta);
        int w;
        JLabel nameLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Plot Name: ");
        String vname = this.getData().getArray(0).getName();
        String dname = this.getData().getArray(0).getDataset().getName();
        dname = PanFileUtilities.extractDatasetFilenameRoot(dname);
        this.nameTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, null, vname + " in " + dname);
        QuickBox nameBox = QuickBox.createHorizontalBox(nameLabel, this.nameTF_);
        JLabel titleLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Plot Title: ");
        this.titleTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:caption.title", this.pmeta_.getString("plot:caption.title"));
        QuickBox titleBox = QuickBox.createHorizontalBox(titleLabel, this.titleTF_);
        JLabel subtitleLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Plot Subtitle: ");
        this.subtitleTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:caption.subtitle", "");
        QuickBox subtitleBox = QuickBox.createHorizontalBox(subtitleLabel, this.subtitleTF_);
        JLabel fontLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Labels Typeface: ");
        final PanFontMenu fontMenu = PanWidgetUtils.getFontMenu(PanWidgetUtils.Size.SMALL, "plot:font.master");
        fontMenu.setSelectedItem(this.pmeta_.getString("plot:font.master"));
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        JLabel backgroundLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Background: ");
        this.backgroundAction_ = new BackgroundAction();
        plotMenu.getItemByName("background").setAction(this.backgroundAction_);
        this.bColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.SMALL, "plot:colors.background", PaletteType.BLACK_WHITE);
        this.bColorMenu_.setSelectedColor(this.pmeta_.getColor("plot:colors.background"));
        this.bColorMenu_.setAction(this.backgroundAction_);
        mbar.getItemByName("plot-menu", "background").setText(this.getOppositeColorName() + " Background");
        final JCheckBox mmNoteCB = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, "plot:scale.minmaxnote", "Show min-max footnote ", this.pmeta_.getBoolean("plot:scale.minmaxnote"));
        JCheckBox projNoteCB = null;
        if (this.pmeta_.get("plot:type") == PanPlotType.LON_LAT) {
            projNoteCB = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.projnote", "Show projection footnote ", this.pmeta_.getBoolean("plot:lonlat.map.projnote"));
        }
        if (this.pmeta_.getDimension((String)"plot:size.pixels").width > 800) {
            QuickBox bBox1 = QuickBox.createLeftBox(fontLabel, fontMenu);
            QuickBox bBox2 = QuickBox.createLeftBox(backgroundLabel, this.bColorMenu_);
            FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 2);
            fgl.setRowWeight(4, 9999.0f);
            this.setLayout(fgl);
            this.add((Component)nameBox, new FGConstraint(0, 0, 0.0, 0.5));
            this.add((Component)titleBox, new FGConstraint(0, 1, 0.0, 0.5));
            this.add((Component)subtitleBox, new FGConstraint(0, 2, 0.0, 0.5));
            this.add((Component)mmNoteCB, new FGConstraint(0, 3, 0.0, 0.5));
            if (projNoteCB != null) {
                this.add((Component)projNoteCB, new FGConstraint(0, 4, 0.0, 0.5));
            }
            this.add((Component)bBox1, new FGConstraint(1, 0, 0.0, 0.5));
            this.add((Component)bBox2, new FGConstraint(1, 1, 0.0, 0.5));
        } else {
            QuickBox bBox = QuickBox.createHorizontalBox(fontLabel, fontMenu, Box.createHorizontalGlue(), backgroundLabel, this.bColorMenu_);
            this.setLayout(new BoxLayout(this, 1));
            this.add(nameBox);
            this.add(titleBox);
            this.add(subtitleBox);
            this.add(bBox);
            this.add(QuickBox.createLeftBox(mmNoteCB));
            if (projNoteCB != null) {
                this.add(QuickBox.createLeftBox(projNoteCB));
            }
            this.add(Box.createVerticalGlue());
        }
        this.setBorder(PanGuiConstants.STD_BORDER);
        Dimension d1 = nameLabel.getPreferredSize();
        Dimension d2 = titleLabel.getPreferredSize();
        Dimension d3 = subtitleLabel.getPreferredSize();
        d1.width = w = Math.max(Math.max(d2.width, d2.width), d3.width);
        nameLabel.setPreferredSize(d1);
        nameLabel.setMinimumSize(d1);
        titleLabel.setPreferredSize(d1);
        titleLabel.setMinimumSize(d1);
        subtitleLabel.setPreferredSize(d1);
        subtitleLabel.setMinimumSize(d1);
        Dimension nameD = this.nameTF_.getPreferredSize();
        int tfh = nameD.height;
        Dimension tfpref = new Dimension(400, tfh);
        Dimension tfmax = new Dimension(1000, tfh);
        this.nameTF_.setPreferredSize(tfpref);
        this.nameTF_.setMaximumSize(tfmax);
        this.nameTF_.setMinimumSize(nameD);
        this.titleTF_.setPreferredSize(tfpref);
        this.titleTF_.setMaximumSize(tfmax);
        this.titleTF_.setMinimumSize(nameD);
        this.subtitleTF_.setPreferredSize(tfpref);
        this.subtitleTF_.setMaximumSize(tfmax);
        this.subtitleTF_.setMinimumSize(nameD);
        if (this.pmeta_.getDimension((String)"plot:size.pixels").width > 800) {
            backgroundLabel.setPreferredSize(fontLabel.getPreferredSize());
            backgroundLabel.setMaximumSize(backgroundLabel.getPreferredSize());
        }
        this.nameTF_.getDocument().addDocumentListener(new TfDocumentListener(this.nameTF_));
        this.titleTF_.getDocument().addDocumentListener(new TfDocumentListener(this.titleTF_));
        this.subtitleTF_.getDocument().addDocumentListener(new TfDocumentListener(this.subtitleTF_));
        fontMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanLabelControls.this.pmeta_.setString("plot:font.master", fontMenu.getSelectedItem().toString());
            }
        });
        mmNoteCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanLabelControls.this.pmeta_.setBoolean("plot:scale.minmaxnote", mmNoteCB.isSelected());
            }
        });
        if (projNoteCB != null) {
            projNoteCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JCheckBox cb = (JCheckBox)e.getSource();
                    PanLabelControls.this.pmeta_.setBoolean("plot:lonlat.map.projnote", cb.isSelected());
                }
            });
        }
    }

    @Override
    public void refresh() {
        PanPlotFrame pf = this.getParentFrame();
        if (this.nameTF_ != null && pf != null) {
            this.nameTF_.setText(pf.getTitle());
        }
    }

    private String getOppositeColorName() {
        Color c = this.bColorMenu_.getSelectedColor();
        if (c.equals(Color.BLACK)) {
            return "White";
        }
        return "Black";
    }

    class TfDocumentListener
    implements DocumentListener {
        private JTextField tf_;

        public TfDocumentListener(JTextField tf) {
            this.tf_ = tf;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleTextField();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleTextField();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleTextField();
        }

        private void handleTextField() {
            if (this.tf_ == PanLabelControls.this.nameTF_) {
                PanPlotFrame pf = PanLabelControls.this.getParentFrame();
                if (pf != null) {
                    pf.setTitle(PanLabelControls.this.nameTF_.getText());
                }
            } else if (this.tf_ == PanLabelControls.this.titleTF_) {
                PanLabelControls.this.pmeta_.setString("plot:caption.title", PanLabelControls.this.titleTF_.getText());
            } else if (this.tf_ == PanLabelControls.this.subtitleTF_) {
                PanLabelControls.this.pmeta_.setString("plot:caption.subtitle", PanLabelControls.this.subtitleTF_.getText());
            }
        }
    }

    class BackgroundAction
    extends AbstractAction {
        private boolean busy_;

        BackgroundAction() {
            super("Background");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PanPlotFrame pf;
            Object source;
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            Object object = source = e == null ? null : e.getSource();
            if (source != null && source instanceof JMenuItem) {
                String ctext = ((JMenuItem)source).getText();
                Color cnew = ctext.startsWith("Black") ? Color.BLACK : Color.WHITE;
                PanLabelControls.this.bColorMenu_.setSelectedColor(cnew);
            }
            if ((pf = PanLabelControls.this.getParentFrame()) == null) {
                this.busy_ = false;
                return;
            }
            PanMenuBar mbar = pf.getPanMenuBar();
            mbar.getItemByName("plot-menu", "background").setText(PanLabelControls.this.getOppositeColorName() + " Background");
            Color cnew = PanLabelControls.this.bColorMenu_.getSelectedColor();
            Color cold = PanLabelControls.this.pmeta_.getColor("plot:colors.background");
            if (!cnew.equals(cold)) {
                PanLabelControls.this.pmeta_.setColor("plot:colors.background", cnew);
            }
            this.busy_ = false;
        }
    }
}

