/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanKmzOptionsDialog
extends JDialog {
    private static boolean fillTransparent_ = true;
    private static boolean borderVisible_ = false;
    private PanPlotFrame pframe_;
    private JCheckBox transparentCB_;
    private JCheckBox borderCB_;
    private boolean success_;

    public PanKmzOptionsDialog(PanPlotFrame pframe) {
        super(pframe, "KMZ Export Options", true);
        this.setResizable(false);
        this.pframe_ = pframe;
        this.transparentCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Fill color should be transparent", fillTransparent_);
        QuickBox transparencyBox = QuickBox.createLeftBox(this.transparentCB_, Box.createHorizontalStrut(48));
        this.borderCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Map border should be visible", borderVisible_);
        QuickBox borderBox = QuickBox.createLeftBox(this.borderCB_, Box.createHorizontalStrut(48));
        JButton cancelButton = new JButton("Cancel");
        JButton makeButton = new JButton("Okay");
        QuickBox buttonBox = PlatformUtilities.isMacintosh() ? QuickBox.createRightBox(cancelButton, makeButton) : QuickBox.createRightBox(makeButton, cancelButton);
        transparencyBox.setMinimumSize(transparencyBox.getPreferredSize());
        borderBox.setMinimumSize(borderBox.getPreferredSize());
        buttonBox.setMinimumSize(buttonBox.getPreferredSize());
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(3, 4, 0, 1);
        fgl.setColumnWeight(2, 9999.0f);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(PanGuiConstants.STD_BORDER);
        contentPanel.add((Component)transparencyBox, new FGConstraint(0, 0, 2, 1, 0.0, 0.5));
        contentPanel.add((Component)borderBox, new FGConstraint(0, 1, 2, 1, 0.0, 0.5));
        contentPanel.add((Component)new JLabel(" "), new FGConstraint(0, 2, 2, 1, 0.0, 0.5));
        contentPanel.add((Component)buttonBox, new FGConstraint(1, 3, 1.0, 0.5));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(makeButton);
        makeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fillTransparent_ = PanKmzOptionsDialog.this.transparentCB_.isSelected();
                borderVisible_ = PanKmzOptionsDialog.this.borderCB_.isSelected();
                PanKmzOptionsDialog.this.success_ = true;
                PanKmzOptionsDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanKmzOptionsDialog.this.setVisible(false);
            }
        });
        this.pack();
        Rectangle rr = this.pframe_.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public boolean isFillTransparent() {
        return fillTransparent_;
    }

    public boolean isBorderVisible() {
        return borderVisible_;
    }
}

