/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import gov.nasa.giss.graphics.ps.PsDocument;
import gov.nasa.giss.graphics.ps.PsGraphics2D;
import gov.nasa.giss.graphics.ps.PsWriter;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.img.GifWriter;
import gov.nasa.giss.img.TiffWriter;
import gov.nasa.giss.panoply.PanDisplayFrame;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.plot.PanAbstractPlot;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanImageUtilities {
    private static Logger logger_ = LoggerFactory.getLogger(PanImageUtilities.class);
    private static GifWriter gifWriter_;
    private static TiffWriter tiffWriter_;
    private static String software_;

    public static synchronized boolean saveAsGif(File f, PanDisplayFrame df) throws IOException {
        BufferedImage img = df.getImage();
        return PanImageUtilities.saveAsGif(f, img);
    }

    public static synchronized boolean saveAsGif(File f, PanAbstractPlot plot) throws IOException {
        BufferedImage img = plot.getImage();
        return PanImageUtilities.saveAsGif(f, img);
    }

    public static synchronized boolean saveAsGif(File f, BufferedImage img) throws IOException {
        if (gifWriter_ == null) {
            gifWriter_ = new GifWriter();
        } else {
            gifWriter_.flush();
        }
        gifWriter_.setImage(img);
        gifWriter_.write(f);
        return true;
    }

    public static synchronized boolean saveAsJpeg(File f, PanDisplayFrame df) throws IOException {
        BufferedImage img = df.getImage();
        return PanImageUtilities.saveAsJpeg(f, img, 1.0f);
    }

    public static synchronized boolean saveAsJpeg(File f, PanAbstractPlot plot) throws IOException {
        BufferedImage img = plot.getImage();
        return PanImageUtilities.saveAsJpeg(f, img, 1.0f);
    }

    public static synchronized boolean saveAsJpeg(File f, BufferedImage img, float quality) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter writer = iter.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(quality);
        ImageOutputStream ios = ImageIO.createImageOutputStream(f);
        writer.setOutput(ios);
        writer.write(null, new IIOImage(img, null, null), iwp);
        ios.flush();
        writer.dispose();
        ios.close();
        return true;
    }

    public static synchronized boolean saveAsPdf(File f, PanDisplayFrame df) throws IOException {
        Document document = new Document(PageSize.LETTER.rotate());
        FileOutputStream ostream = new FileOutputStream(f);
        try {
            PdfWriter writer = PdfWriter.getInstance(document, ostream);
            document.open();
            df.paintContentPDF(writer, document);
            document.newPage();
        }
        catch (Exception exc) {
            logger_.error("Unable to save image as PDF.");
            exc.printStackTrace();
            GuiUtilities.showSlowMessage(df, "Save Error", "Unable to save image as PDF.\n" + exc.toString());
            document.close();
            ostream.close();
            return false;
        }
        document.close();
        ostream.close();
        return true;
    }

    public static synchronized boolean saveAsPdf(File f, PanAbstractPlot plot) throws IOException {
        try {
            Document document = new Document(PageSize.LETTER.rotate());
            FileOutputStream ostream = new FileOutputStream(f);
            PdfWriter writer = PdfWriter.getInstance(document, ostream);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            Rectangle pageSize = document.getPageSize();
            Dimension useSize = new Dimension((int)(pageSize.width() - 144.0f), (int)(pageSize.height() - 144.0f));
            Dimension plotLayout = plot.getSize();
            float scaleX = (float)useSize.width / (float)plotLayout.width;
            float scaleY = (float)useSize.height / (float)plotLayout.height;
            float scale = Math.min(scaleY, scaleX);
            cb.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, (pageSize.width() - (float)plotLayout.width * scale) / 2.0f, (pageSize.height() - (float)plotLayout.height * scale) / 2.0f);
            cb.concatCTM(scale, 0.0f, 0.0f, scale, 0.0f, 0.0f);
            Graphics2D g2d = cb.createGraphicsShapes(plot.getWidth(), plot.getHeight());
            plot.print(g2d);
            g2d.dispose();
            document.newPage();
            document.close();
            ostream.close();
        }
        catch (Exception exc) {
            logger_.error("Unable to save image as PDF.");
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public static synchronized boolean saveAsPng(File f, PanDisplayFrame df) throws IOException {
        BufferedImage img = df.getImage();
        return PanImageUtilities.saveAsPng(f, img);
    }

    public static synchronized boolean saveAsPng(File f, PanAbstractPlot plot) throws IOException {
        BufferedImage img = plot.getImage();
        return PanImageUtilities.saveAsPng(f, img);
    }

    public static synchronized boolean saveAsPng(File f, BufferedImage img) throws IOException {
        ImageIO.write((RenderedImage)img, "png", f);
        return true;
    }

    public static synchronized boolean saveAsPs(File f, PanDisplayFrame df) throws IOException {
        PsDocument document = new PsDocument(PsDocument.LETTER_LANDSCAPE);
        document.setTitle(df.getTitle());
        try {
            PsWriter writer = new PsWriter(document, f);
            document.open();
            df.paintContentPs(document);
        }
        catch (Exception exc) {
            logger_.error("Unable to save image as PS.");
            exc.printStackTrace();
            GuiUtilities.showSlowMessage(df, "Save Error", "Unable to save image as PostScript.\n" + exc.toString());
            document.close();
            return false;
        }
        document.close();
        return true;
    }

    public static synchronized boolean saveAsPs(File f, PanAbstractPlot plot) {
        PsDocument document = new PsDocument(PsDocument.LETTER_LANDSCAPE);
        try {
            PsWriter writer = new PsWriter(document, f);
            document.open();
            PsGraphics2D g2d = document.createGraphics(true);
            Dimension pageSize = document.getSize();
            Dimension useSize = new Dimension((int)((float)pageSize.width - 144.0f), (int)((float)pageSize.height - 144.0f));
            Dimension plotLayout = plot.getSize();
            float scaleX = (float)useSize.width / (float)plotLayout.width;
            float scaleY = (float)useSize.height / (float)plotLayout.height;
            float scale = Math.min(scaleY, scaleX);
            ((Graphics2D)g2d).translate(((float)pageSize.width - (float)plotLayout.width * scale) / 2.0f, ((float)pageSize.height - (float)plotLayout.height * scale) / 2.0f);
            ((Graphics2D)g2d).scale(scale, scale);
            plot.print(g2d);
            ((Graphics)g2d).dispose();
            document.close();
        }
        catch (Exception exc) {
            logger_.error("Unable to save image as PS.");
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public static synchronized boolean saveAsTiff(File f, PanDisplayFrame df) throws IOException {
        BufferedImage img = df.getImage();
        return PanImageUtilities.saveAsTiff(f, img);
    }

    public static synchronized boolean saveAsTiff(File f, PanAbstractPlot plot) throws IOException {
        BufferedImage img = plot.getImage();
        return PanImageUtilities.saveAsTiff(f, img);
    }

    public static synchronized boolean saveAsTiff(File f, BufferedImage img) throws IOException {
        if (software_ == null) {
            software_ = "NASA/GISS " + PanProperties.VERSION.getString("application-name") + " " + PanProperties.VERSION.getString("version") + " (" + PanProperties.VERSION.getString("build") + ")";
        }
        if (tiffWriter_ == null) {
            tiffWriter_ = new TiffWriter();
        } else {
            tiffWriter_.flush();
        }
        tiffWriter_.setImage(img);
        tiffWriter_.setSoftware(software_);
        tiffWriter_.write(f);
        return true;
    }
}

