/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

public enum PanImageFormat {
    GIF(new String[]{"GIF"}),
    JPEG(new String[]{"JPEG", "JPG"}),
    PDF(new String[]{"PDF"}),
    PNG(new String[]{"PNG"}),
    PS(new String[]{"PS"}),
    TIFF(new String[]{"TIFF", "TIF"});

    private String[] extensions_;

    private PanImageFormat(String[] extensions) {
        this.extensions_ = extensions;
    }

    public boolean extMatches(String text) {
        for (int i = 0; i < this.extensions_.length; ++i) {
            if (!this.extensions_[i].equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public static PanImageFormat match(String text) {
        for (PanImageFormat value : PanImageFormat.values()) {
            if (!value.extMatches(text)) continue;
            return value;
        }
        return null;
    }
}

