/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.menu.GissMenuItem;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.panoply.PanAbstractBookmarksMenu;
import gov.nasa.giss.panoply.PanBookmark;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanHistoryFolder;
import gov.nasa.giss.panoply.PanHistoryList;
import gov.nasa.giss.panoply.PanPreferences;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanHistoryMenu
extends PanAbstractBookmarksMenu {
    private static Logger logger_ = LoggerFactory.getLogger(PanHistoryMenu.class);
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private static String homeDir_ = System.getProperty("user.home");
    private JMenuItem clearRecentItem_;
    private int coreItemsCount_;

    public PanHistoryMenu(PanFrame parent) {
        super(parent, "history-menu");
        GissMenuItem jmi = this.makeItemFromProperties("reopen-last-dataset", null);
        this.add(jmi).setEnabled(false);
        this.addSeparator();
        this.coreItemsCount_ = this.getItemCount();
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanHistoryList.getList().clear();
                PanHistoryMenu.this.refresh();
            }
        };
        this.clearRecentItem_ = this.makeItemFromProperties("clear-history", a);
        this.refresh();
    }

    @Override
    public void refresh() {
        TreeTableNode[] bobs;
        int msize = this.getItemCount();
        for (int i = this.coreItemsCount_; i < msize; ++i) {
            this.remove(this.coreItemsCount_);
        }
        for (TreeTableNode bob : bobs = PanHistoryList.getList().getChildren()) {
            if (bob instanceof PanHistoryFolder && ((PanHistoryFolder)bob).isTodayFolder()) {
                PanHistoryFolder hf = ((PanHistoryFolder)bob).copy();
                int isize = Math.min(12, hf.getChildCount());
                for (int i = 0; i < isize; ++i) {
                    PanBookmark b = (PanBookmark)hf.remove(0);
                    this.addBookmarkNode(this, b);
                }
                if (bobs.length > 0 || hf.getChildCount() > 0) {
                    this.addSeparator();
                }
                if (hf.getChildCount() <= 0) continue;
                this.addBookmarkNode(this, hf);
                continue;
            }
            this.addBookmarkNode(this, bob);
        }
        if (bobs.length > 0) {
            this.addSeparator();
            this.add(this.clearRecentItem_).setEnabled(true);
        } else {
            this.add(this.clearRecentItem_).setEnabled(false);
        }
        super.refresh();
    }
}

