/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcCatalog;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.panoply.PanBookmark;
import gov.nasa.giss.panoply.PanBookmarkType;
import gov.nasa.giss.panoply.PanBookmarksList;
import gov.nasa.giss.panoply.PanHistoryFolder;
import java.net.URL;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanHistoryList
extends PanBookmarksList {
    private static Logger logger_ = LoggerFactory.getLogger(PanHistoryList.class);
    private static PanBookmarksList blist_;
    private int maxRecent_ = 20;

    public static PanHistoryList getList() {
        if (blist_ == null) {
            blist_ = new PanHistoryList();
        }
        return (PanHistoryList)blist_;
    }

    private PanHistoryList() {
    }

    @Override
    public String getName() {
        if (this.isNameSet()) {
            return super.getName();
        }
        return "history";
    }

    @Override
    public String getAddress() {
        return "history";
    }

    @Override
    public void add(TreeTableNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Can't insert a null.");
        }
        if (!(child instanceof PanHistoryFolder)) {
            throw new IllegalArgumentException("Can only add day folders to history list.");
        }
        super.add(child);
    }

    @Override
    public void add(int index, TreeTableNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Can't insert a null.");
        }
        if (!(child instanceof PanHistoryFolder)) {
            throw new IllegalArgumentException("Can only add day folders to history list.");
        }
        super.add(index, child);
    }

    public void enforceAgeLimit(int limit) {
        PanHistoryFolder hf;
        TreeTableNode[] children = this.getChildren();
        for (int i = children.length - 1; i >= 0 && (hf = (PanHistoryFolder)children[i]).getAge() > limit; --i) {
            this.remove(i);
        }
    }

    public synchronized void addBookmark(NcDataset ncd) {
        if (ncd == null) {
            throw new IllegalArgumentException("NcDataset is null.");
        }
        URL url = ncd.getURL();
        String prot = url.getProtocol();
        PanBookmark b = null;
        try {
            if (prot.equals("file")) {
                b = new PanBookmark(PanBookmarkType.LOCAL_DATASET, (Object)url, null);
            } else if (prot.equals("http") || prot.equals("https") || prot.equals("ftp")) {
                b = new PanBookmark(PanBookmarkType.REMOTE_DATASET, (Object)url, null);
            } else {
                throw new IllegalArgumentException("Dataset access protocol not understood");
            }
            if (b == null) {
                return;
            }
            this.addBookmark(b);
        }
        catch (Exception exc) {
            logger_.info("Couldn't add bookmark for {}", (Object)ncd);
        }
    }

    public synchronized void addBookmark(NcCatalog c) {
        if (c == null) {
            throw new IllegalArgumentException("Catalog is null.");
        }
        try {
            PanBookmark b = new PanBookmark(PanBookmarkType.CATALOG, (Object)c.getURI(), null);
            this.addBookmark(b);
        }
        catch (Exception exc) {
            logger_.warn("Couldn't add bookmark for {}", (Object)c);
        }
    }

    public synchronized void addBookmark(PanBookmark b) {
        if (b == null) {
            throw new IllegalArgumentException("PanBookmark is null.");
        }
        PanHistoryFolder folder = this.getTodayFolder();
        folder.add(0, b);
        b.setParent(folder);
    }

    public PanHistoryFolder getTodayFolder() {
        PanHistoryFolder hf;
        if (this.getChildCount() > 0 && (hf = (PanHistoryFolder)this.getChildAt(0)).isTodayFolder()) {
            return hf;
        }
        GregorianCalendar today = new GregorianCalendar();
        int year = today.get(1);
        int month = today.get(2) + 1;
        int day = today.get(5);
        PanHistoryFolder folder = new PanHistoryFolder(this, year, month, day);
        this.add(0, folder);
        return folder;
    }
}

