/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.panoply.PanBookmark;
import gov.nasa.giss.panoply.PanBookmarksFolder;
import gov.nasa.giss.panoply.PanBookmarksNode;
import gov.nasa.giss.text.PrintfFormat;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanHistoryFolder
extends PanBookmarksFolder {
    private static Logger logger_ = LoggerFactory.getLogger(PanHistoryFolder.class);
    private static final PrintfFormat PFORMAT_4D = new PrintfFormat("%04d");
    private static final PrintfFormat PFORMAT_2D = new PrintfFormat("%02d");
    private static final String FORMAT1 = "EEEE, MMMM dd, yyyy";
    private static final SimpleDateFormat FORMATTER1 = new SimpleDateFormat("EEEE, MMMM dd, yyyy");
    private GregorianCalendar cal_ = new GregorianCalendar();
    private int year_;
    private int month_;
    private int day_;

    private PanHistoryFolder(PanBookmarksNode parent) {
        super(parent, null);
        this.cal_.clear();
    }

    public PanHistoryFolder(PanBookmarksNode parent, String date) {
        this(parent);
        String ys = date.substring(0, 4);
        String ms = date.substring(4, 6);
        String ds = date.substring(6, 8);
        if (ms.startsWith("0")) {
            ms = ms.substring(1, 2);
        }
        if (ds.startsWith("0")) {
            ds = ds.substring(1, 2);
        }
        this.year_ = Integer.parseInt(ys);
        this.month_ = Integer.parseInt(ms);
        this.day_ = Integer.parseInt(ds);
        this.cal_.set(this.year_, this.month_ - 1, this.day_);
    }

    public PanHistoryFolder(PanBookmarksNode parent, int year, int month, int day) {
        this(parent);
        this.year_ = year;
        this.month_ = month;
        this.day_ = day;
        this.cal_.set(this.year_, this.month_ - 1, this.day_);
    }

    public boolean isTodayFolder() {
        GregorianCalendar today = new GregorianCalendar();
        int year = today.get(1);
        int month = today.get(2) + 1;
        int day = today.get(5);
        int[] date = this.getDate();
        return date[0] == year && date[1] == month && date[2] == day;
    }

    @Override
    public String getName() {
        if (this.isTodayFolder()) {
            return "Earlier Today";
        }
        FORMATTER1.setCalendar(this.cal_);
        return FORMATTER1.format(this.cal_.getTime());
    }

    @Override
    public boolean isNameSet() {
        return false;
    }

    public int getAge() {
        GregorianCalendar today = new GregorianCalendar();
        long diffMS = today.getTimeInMillis() - this.cal_.getTimeInMillis();
        int diffDay = (int)(diffMS / 86400000L);
        return diffDay;
    }

    public int[] getDate() {
        return new int[]{this.year_, this.month_, this.day_};
    }

    public String getDateString() {
        return PFORMAT_4D.sprintf(this.year_) + PFORMAT_2D.sprintf(this.month_) + PFORMAT_2D.sprintf(this.day_);
    }

    @Override
    public void add(TreeTableNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Can't insert a null.");
        }
        if (!(child instanceof PanBookmark)) {
            throw new IllegalArgumentException("Can only add a PanBookmark to a day folder.");
        }
        this.removeExistingDuplicate((PanBookmark)child);
        super.add(child);
    }

    @Override
    public void add(int index, TreeTableNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Can't insert a null.");
        }
        if (!(child instanceof PanBookmark)) {
            throw new IllegalArgumentException("Can only add a PanBookmark to a day folder.");
        }
        this.removeExistingDuplicate((PanBookmark)child);
        super.add(index, child);
    }

    private void removeExistingDuplicate(PanBookmark node) {
        int isize = this.getChildCount();
        if (isize == 0) {
            return;
        }
        URI u1 = PanHistoryFolder.getURI(node.getObject());
        if (u1 == null) {
            return;
        }
        for (int i = 0; i < isize; ++i) {
            URI u2 = PanHistoryFolder.getURI(((PanBookmarksNode)this.getChildAt(i)).getObject());
            if (!u1.equals(u2)) continue;
            super.remove(i);
            return;
        }
    }

    private static URI getURI(Object o) {
        try {
            if (o instanceof File) {
                return ((File)o).toURI();
            }
            if (o instanceof URL) {
                return ((URL)o).toURI();
            }
            if (o instanceof URI) {
                return (URI)o;
            }
        }
        catch (Exception exc) {
            logger_.warn("getURI error, returning null");
            exc.printStackTrace();
        }
        return null;
    }

    public PanHistoryFolder copy() {
        PanHistoryFolder result = new PanHistoryFolder(null, this.year_, this.month_, this.day_);
        int isize = this.getChildCount();
        if (isize == 0) {
            return result;
        }
        for (int i = 0; i < isize; ++i) {
            PanBookmark b;
            TreeTableNode child = this.getChildAt(i);
            if (!(child instanceof PanBookmark) || (b = ((PanBookmark)child).copy()) == null) continue;
            result.add(b);
        }
        return result;
    }
}

