/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import com.centerkey.utils.BareBonesBrowserLaunch;
import gov.nasa.giss.panoply.PanAboutFrame;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanHelpFrame;
import gov.nasa.giss.panoply.PanMenu;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.net.URI;
import javax.swing.AbstractAction;

public class PanHelpMenu
extends PanMenu {
    public PanHelpMenu(PanFrame parent) {
        super(parent, "help-menu");
        AbstractAction a;
        if (!PlatformUtilities.isMacintosh()) {
            a = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanAboutFrame.findFrame(true).reveal();
                }
            };
            this.add(this.makeItemFromProperties("show-about", a)).setEnabled(true);
        }
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = PanProperties.ABOUT.getString("app-url");
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().browse(new URI(s));
                    } else {
                        BareBonesBrowserLaunch.openURL(s);
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        this.add(this.makeItemFromProperties("show-website", a)).setEnabled(true);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BareBonesBrowserLaunch.openURL(PanProperties.ABOUT.getString("help-url"));
            }
        };
        this.add(this.makeItemFromProperties("show-help", a)).setEnabled(true);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanHelpFrame f = PanHelpFrame.findFrame(PanProperties.ABOUT.getString("credits-url"));
                f.setState(0);
                f.toFront();
                f.setVisible(true);
            }
        };
        this.add(this.makeItemFromProperties("show-credits", a)).setEnabled(true);
    }
}

