/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import com.centerkey.utils.BareBonesBrowserLaunch;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class PanHelpFrame
extends PanFrame
implements DocumentListener,
HyperlinkListener {
    private static final String HELP_PATH = "resources/help/";
    private static final String ERROR_PAGE = "error404.html";
    private static PanHelpFrame helpFrame_;
    private static JEditorPane editorPane_;
    private static final int MIN_WIDTH = 200;
    private static final int MIN_HEIGHT = 200;

    public static PanHelpFrame findFrame() {
        if (helpFrame_ == null) {
            helpFrame_ = PanHelpFrame.findFrame("index.html");
        }
        return helpFrame_;
    }

    public static PanHelpFrame findFrame(String fname) {
        if (helpFrame_ == null) {
            try {
                helpFrame_ = new PanHelpFrame(fname);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        } else {
            helpFrame_.setPage(fname);
        }
        return helpFrame_;
    }

    public void setPage(String fname) {
        try {
            this.setPage(PanHelpFrame.class.getResource(HELP_PATH + fname));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            editorPane_.setText("<html><head><title>Error</title><head><body><p>Could not load page.</p><pre>" + exc.toString() + "</pre></body></html>");
        }
    }

    public void setPage(URL url) {
        try {
            editorPane_.setPage(url);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            editorPane_.setText("<html><head><title>Error</title><head><body><p>Could not load page.</p><pre>" + exc.toString() + "</pre></body></html>");
        }
        HTMLDocument doc = (HTMLDocument)editorPane_.getDocument();
        doc.addDocumentListener(this);
    }

    private PanHelpFrame(String fname) throws IOException {
        super("Help");
        if (fname == null) {
            throw new IllegalArgumentException("Null passed for help file name.");
        }
        this.setTitle("Help");
        this.setName(this.getTitle());
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
        this.setPanMenuBar(new PanMenuBar(this));
        String rpath = HELP_PATH + fname;
        editorPane_ = new JEditorPane(PanHelpFrame.class.getResource(rpath));
        editorPane_.setEditable(false);
        editorPane_.addHyperlinkListener(this);
        HTMLDocument doc = (HTMLDocument)editorPane_.getDocument();
        doc.addDocumentListener(this);
        Rectangle rr = GuiUtilities.getMainScreenBounds();
        if (rr == null) {
            editorPane_.setPreferredSize(new Dimension(400, 460));
        } else {
            editorPane_.setPreferredSize(new Dimension(Math.min(2 * rr.width / 3, 540), 2 * rr.height / 3));
        }
        JScrollPane sp = new JScrollPane(editorPane_);
        sp.setBorder(PanGuiConstants.NO_BORDER);
        if (PlatformUtilities.isMacintosh()) {
            sp.setVerticalScrollBarPolicy(22);
            sp.setHorizontalScrollBarPolicy(30);
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(sp);
        contentPane.add(this.createStatusBar());
        this.pack();
        this.setMinimumSize(new Dimension(200, 200));
        if (rr == null) {
            this.setLocation(25, 25);
        } else {
            Dimension psize = this.getContentPane().getPreferredSize();
            int x = (rr.width - this.getWidth()) / 2;
            int y = (rr.height - this.getHeight()) / 2;
            this.setLocation(rr.x + x, rr.y + y);
        }
    }

    @Override
    public void doLayout() {
        if (PlatformUtilities.isJava5() && (this.getWidth() < 200 || this.getHeight() < 200)) {
            int w = Math.max(this.getWidth(), 200);
            int h = Math.max(this.getHeight(), 200);
            this.setSize(new Dimension(w, h));
        }
        super.doLayout();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        Document doc = editorPane_.getDocument();
        if (doc instanceof HTMLDocument) {
            this.setTitle((String)((HTMLDocument)doc).getProperty("title"));
        } else {
            this.setTitle("Help");
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        if (e instanceof HTMLFrameHyperlinkEvent) {
            return;
        }
        try {
            String s = e.getURL().toString();
            if (s.startsWith("http:") || s.startsWith("ftp:") || s.startsWith("file:")) {
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().browse(new URI(s));
                } else {
                    BareBonesBrowserLaunch.openURL(s);
                }
            } else if (s.startsWith("mailto:")) {
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().mail(new URI(s));
                } else {
                    BareBonesBrowserLaunch.openURL(s);
                }
            } else if (s.startsWith("jar:file:")) {
                this.setPage(e.getURL());
            }
            return;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            try {
                this.setPage(PanHelpFrame.class.getResource("resources/help/error404.html"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }
}

