/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.text.PrintfFormat;
import javax.swing.JComboBox;

public class PanGridSpacingMenu
extends JComboBox {
    private static final PrintfFormat FORMATTER = new PrintfFormat("%G");
    private static final GridSpacing NONE = new GridSpacing(0.0);
    private static final Object[] SPACING_CHOICES = new Object[]{NONE, new GridSpacing(90.0), new GridSpacing(45.0), new GridSpacing(30.0), new GridSpacing(15.0), new GridSpacing(10.0), new GridSpacing(8.0), new GridSpacing(6.0), new GridSpacing(5.0), new GridSpacing(4.0), new GridSpacing(3.0), new GridSpacing(2.5), new GridSpacing(2.0), new GridSpacing(1.0), new GridSpacing(0.5), new GridSpacing(0.25), new GridSpacing(0.2), new GridSpacing(0.1)};

    public PanGridSpacingMenu() {
        super(SPACING_CHOICES);
        this.setMaximumRowCount(24);
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            super.setSelectedItem(NONE);
            return;
        }
        if (item instanceof GridSpacing) {
            super.setSelectedItem(item);
            return;
        }
        int isize = this.getItemCount();
        if (item instanceof Double) {
            double d = (Double)item;
            for (int i = 0; i < isize; ++i) {
                GridSpacing gs = (GridSpacing)this.getItemAt(i);
                if (gs.getValue() != d) continue;
                super.setSelectedItem(gs);
                return;
            }
        }
        String s = item.toString();
        for (int i = 0; i < isize; ++i) {
            GridSpacing gs = (GridSpacing)this.getItemAt(i);
            if (!gs.toString().equals(s)) continue;
            super.setSelectedItem(gs);
            return;
        }
    }

    public void setSelectedItem(double spacing) {
        if (spacing <= 0.0) {
            super.setSelectedItem(NONE);
            return;
        }
        this.setSelectedItem(new Double(spacing));
    }

    public double getSpacing() {
        GridSpacing gs = (GridSpacing)this.getSelectedItem();
        return gs.getValue();
    }

    public static class GridSpacing {
        private double spacing_;

        public GridSpacing(double spacing) {
            this.spacing_ = spacing;
        }

        public double getValue() {
            return this.spacing_;
        }

        public String toString() {
            if (this.spacing_ == 0.0) {
                return "None";
            }
            return FORMATTER.sprintf(this.spacing_);
        }
    }
}

