/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.label.MultiLineLabel;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.text.IntegerDocument;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanGribTableOptionsDialog
extends JDialog {
    private PanFrame pframe_;
    private JTextField centerTF_;
    private JTextField subcenterTF_;
    private JTextField versionTF_;
    private boolean success_;

    public PanGribTableOptionsDialog(PanFrame pframe) {
        super(pframe, "GRIB-1 Table Options", true);
        this.setResizable(false);
        this.pframe_ = pframe;
        MultiLineLabel messageLabel = new MultiLineLabel("Enter the center, subcenter and version for GRIB-1 datasets to which\nthis table should be applied. Subcenter and version IDs may be set to\nthe wildcard. Otherwise, all IDs should be between 1 and 255.");
        this.centerTF_ = new JTextField(new IntegerDocument(), "1", 6);
        this.subcenterTF_ = new JTextField(new IntegerDocument(), "-1", 6);
        this.versionTF_ = new JTextField(new IntegerDocument(), "-1", 6);
        this.centerTF_.setHorizontalAlignment(4);
        this.subcenterTF_.setHorizontalAlignment(4);
        this.versionTF_.setHorizontalAlignment(4);
        this.subcenterTF_.setMinimumSize(this.subcenterTF_.getPreferredSize());
        JButton cancelButton = new JButton("Cancel");
        JButton okayButton = new JButton("Okay");
        QuickBox buttonBox = PlatformUtilities.isMacintosh() ? QuickBox.createRightBox(cancelButton, okayButton) : QuickBox.createRightBox(okayButton, cancelButton);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(4, 7, 0, 1);
        fgl.setColumnWeight(3, 9999.0f);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(PanGuiConstants.STD_BORDER);
        contentPanel.add((Component)messageLabel, new FGConstraint(0, 0, 4, 1, 1.0, 0.5));
        contentPanel.add((Component)new JLabel("Center: "), new FGConstraint(0, 2, 0.0, 0.5));
        contentPanel.add((Component)this.centerTF_, new FGConstraint(1, 2, 0.0, 0.5));
        contentPanel.add((Component)new JLabel("Subcenter: "), new FGConstraint(0, 3, 0.0, 0.5));
        contentPanel.add((Component)this.subcenterTF_, new FGConstraint(1, 3, 0.0, 0.5));
        contentPanel.add((Component)new JLabel(" (-1 = wildcard)"), new FGConstraint(2, 3, 0.0, 0.5));
        contentPanel.add((Component)new JLabel("Version: "), new FGConstraint(0, 4, 0.0, 0.5));
        contentPanel.add((Component)this.versionTF_, new FGConstraint(1, 4, 0.0, 0.5));
        contentPanel.add((Component)new JLabel(" (-1 = wildcard)"), new FGConstraint(2, 4, 0.0, 0.5));
        contentPanel.add((Component)buttonBox, new FGConstraint(0, 6, 4, 1, 1.0, 0.5));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(okayButton);
        okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanGribTableOptionsDialog.this.success_ = true;
                PanGribTableOptionsDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanGribTableOptionsDialog.this.setVisible(false);
            }
        });
        this.pack();
        Rectangle rr = this.pframe_.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public int[] getResponses() {
        int c = ((IntegerDocument)this.centerTF_.getDocument()).getValue();
        int s = ((IntegerDocument)this.subcenterTF_.getDocument()).getValue();
        int v = ((IntegerDocument)this.versionTF_.getDocument()).getValue();
        return new int[]{c, s, v};
    }
}

