/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.img.TiffWriter;
import gov.nasa.giss.panoply.PanProperties;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.TreeMap;

public class PanGeoTiffWriter
extends TiffWriter {
    private static final int MODEL_PIXEL_SCALE_TAG = 33550;
    private static final int MODEL_TIEPOINT_TAG = 33922;
    private static final int MODEL_TRANSFORMATION_TAG = 34264;
    private static final int GEO_KEY_WRITER_TAG = 34735;
    private static final int GEO_DOUBLE_PARAMS_TAG = 34736;
    private static final int GEO_ASCII_PARAMS_TAG = 34737;
    private static final int GTModelTypeGeoKey = 1024;
    private static final int GTRasterTypeGeoKey = 1025;
    private static final int ProjCoordTransGeoKey = 3075;
    private static final int GEOTIFF_DOUBLE_KEYTYPE = 1;
    private static final int GEOTIFF_ASCII_KEYTYPE = 2;
    private static String software_;
    private TreeMap<Integer, Object[]> keyEntries_;

    public PanGeoTiffWriter() {
        if (software_ == null) {
            software_ = "NASA/GISS " + PanProperties.VERSION.getString("application-name") + " " + PanProperties.VERSION.getString("version") + " (" + PanProperties.VERSION.getString("build") + ")";
        }
        this.setSoftware(software_);
    }

    @Override
    public synchronized void flush() {
        super.flush();
        this.keyEntries_ = null;
    }

    void addKeyEntry(int keyTag, Object ... values) {
        if (this.keyEntries_ == null) {
            this.keyEntries_ = new TreeMap();
        }
        this.keyEntries_.put(keyTag, values);
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        this.assembleGeoTiffTags();
        super.write(dos);
    }

    private void assembleGeoTiffTags() {
        int numKeyEntries = this.keyEntries_ == null ? 0 : this.keyEntries_.size();
        short[] header = new short[4 * (numKeyEntries + 1)];
        header[0] = 1;
        header[1] = 1;
        header[2] = 2;
        header[3] = (short)numKeyEntries;
        StringBuilder asciiStrings = new StringBuilder();
        if (numKeyEntries > 0) {
            int counter = 0;
            for (Integer key : this.keyEntries_.keySet().toArray(new Integer[0])) {
                Object value;
                Object[] values = this.keyEntries_.get(key);
                header[counter * 4 + 4 + 0] = (short)key.intValue();
                if (values[0] instanceof Integer) {
                    value = (Integer)values[0];
                    header[counter * 4 + 4 + 1] = 0;
                    header[counter * 4 + 4 + 2] = 1;
                    header[counter * 4 + 4 + 3] = (short)((Integer)value).intValue();
                } else if (values[0] instanceof Double) {
                    header[counter * 4 + 4 + 1] = -30800;
                    header[counter * 4 + 4 + 2] = (short)values.length;
                    header[counter * 4 + 4 + 3] = values.length == 1 ? (short)0 : 0;
                } else if (values[0] instanceof String) {
                    value = (String)values[0];
                    asciiStrings.append((String)value).append("|");
                    header[counter * 4 + 4 + 1] = -30799;
                    header[counter * 4 + 4 + 3] = (short)asciiStrings.length();
                    header[counter * 4 + 4 + 2] = (short)(((String)value).length() + 1);
                } else {
                    throw new RuntimeException("Unknown GeoTIFF key entry type " + values[0].getClass());
                }
                ++counter;
            }
        }
    }
}

