/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.task.StatusBar;
import gov.nasa.giss.gui.task.Task;
import gov.nasa.giss.gui.task.TaskQueue;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanWindowAdapter;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

public class PanFrame
extends JFrame {
    private PanWindowAdapter windowAdapter_ = new PanWindowAdapter(this);
    private static TaskQueue taskQueue_;
    private StatusBar statusBar_;
    private static PanFrame dummyFrame_;

    public PanFrame() {
        this((String)null);
    }

    public PanFrame(String title) {
        super(title);
        this.addWindowListener(this.windowAdapter_);
        this.addWindowFocusListener(this.windowAdapter_);
        if (taskQueue_ == null) {
            taskQueue_ = new TaskQueue();
        }
    }

    public PanMenuBar getPanMenuBar() {
        return (PanMenuBar)this.getJMenuBar();
    }

    public void setPanMenuBar(PanMenuBar mbar) {
        super.setJMenuBar(mbar);
    }

    @Override
    public void setJMenuBar(JMenuBar mbar) {
        throw new IllegalArgumentException("Use setPanMenuBar instead");
    }

    public void reveal() {
        this.setState(0);
        this.toFront();
        this.setVisible(true);
        this.refresh();
    }

    public void refresh() {
    }

    public void close() {
    }

    public boolean isBusy() {
        return taskQueue_.size() > 0;
    }

    public void addTask(Task task) {
        taskQueue_.add(task);
    }

    public StatusBar createStatusBar() {
        this.statusBar_ = new StatusBar(taskQueue_);
        return this.statusBar_;
    }

    public static PanFrame getActiveFrame() {
        JFrame f = GuiUtilities.getActiveFrame();
        if (f != null && f instanceof PanFrame) {
            return (PanFrame)f;
        }
        return PanFrame.getDummyFrame();
    }

    public static PanFrame getDummyFrame() {
        if (dummyFrame_ == null) {
            dummyFrame_ = new PanFrame();
        }
        return dummyFrame_;
    }
}

