/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.graphics.colortable.ColorTableFilenameFilter;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.map.overlay.OverlayFilenameFilter;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcFilenameFilter;
import gov.nasa.giss.netcdf.NcGribUtilities;
import gov.nasa.giss.panoply.PanColorTableList;
import gov.nasa.giss.panoply.PanFileConstants;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanGribTableOptionsDialog;
import gov.nasa.giss.panoply.PanOverlayList;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.tasks.PanOpenCatalogTask;
import gov.nasa.giss.panoply.tasks.PanOpenDatasetTask;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanFileUtilities {
    private static Logger logger_ = LoggerFactory.getLogger(PanFileUtilities.class);
    private static final String[] LOAD_TITLE = new String[]{"Open Remote Dataset", "Open Remote Catalog"};
    private static final String[] LOAD_MESSAGE = new String[]{"Enter the URL of a remote dataset to open:", "Enter the URL of a remote THREDDS or OpenDAP catalog to open:"};
    private static JOptionPane loadPane_;
    private static File libraryDir_;

    private PanFileUtilities() {
    }

    public static URL showLoadRemoteDialog(JFrame jf, int loadType) {
        String urlString = null;
        if (loadPane_ == null) {
            loadPane_ = new JOptionPane("", 3, 0, null, new String[]{"Load", "Cancel"});
            loadPane_.setWantsInput(true);
        }
        loadPane_.setMessage(LOAD_MESSAGE[loadType]);
        loadPane_.createDialog(jf, LOAD_TITLE[loadType]).setVisible(true);
        Object choice = loadPane_.getValue();
        if (choice == null) {
            return null;
        }
        if (!choice.toString().equals("Load")) {
            return null;
        }
        urlString = loadPane_.getInputValue().toString();
        if (urlString == null || urlString.toString().length() < 1) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(urlString.toString());
        }
        catch (Exception exc) {
            String msg = exc.toString().replaceFirst(".*HTTP", "HTTP");
            GuiUtilities.showSlowMessage(jf, "File Error", "There was an error in the URL\n" + urlString + " \u2014\n" + msg);
            return null;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object openLocalFile(JFrame parent, Object address) {
        block27: {
            if (address == null) {
                throw new IllegalArgumentException("Address object is null.");
            }
            if (!(address instanceof File || address instanceof URI || address instanceof URL)) {
                throw new IllegalArgumentException("Address object must be File, URI or URL.");
            }
            File f = null;
            if (address instanceof File) {
                f = (File)address;
            } else if (address instanceof URI) {
                f = new File((URI)address);
            } else {
                if (address instanceof URL) {
                    throw new RuntimeException("Not prepared to create a File object from a URL.");
                }
                throw new IllegalArgumentException("Address object must be File, URI or URL.");
            }
            if (!f.exists()) {
                PanFileUtilities.showFileError((Component)parent, f.getName(), "File doesn't seem to exist.");
                return null;
            }
            if (NcFilenameFilter.accept(f)) {
                PanSourcesFrame sourcesFrame;
                PanSourcesFrame panSourcesFrame = sourcesFrame = PanSourcesFrame.findFrame(true);
                synchronized (panSourcesFrame) {
                    PanFileUtilities.openDataset(sourcesFrame, f);
                    if (!Panoply.isStarting()) {
                        sourcesFrame.reveal();
                    }
                }
                return null;
            }
            if (ColorTableFilenameFilter.isColorTableName(f)) {
                try {
                    return PanColorTableList.getList().add(f);
                }
                catch (Exception exc) {
                    PanFileUtilities.showFileError((Component)parent, f.getName(), exc);
                    break block27;
                }
            }
            if (OverlayFilenameFilter.isOverlayName(f)) {
                try {
                    return PanOverlayList.getList().add(f);
                }
                catch (Exception exc) {
                    PanFileUtilities.showFileError((Component)parent, f.getName(), exc);
                    break block27;
                }
            }
            if (PanFileConstants.GRIB1TAB_FILTER.accept(f)) {
                PanGribTableOptionsDialog gtod = new PanGribTableOptionsDialog((PanFrame)parent);
                gtod.setVisible(true);
                if (!gtod.isSuccessful()) {
                    return null;
                }
                int[] results = gtod.getResponses();
                boolean success = NcGribUtilities.openGrib1Table(f, results[0], results[1], results[2]);
                if (!success) {
                    JOptionPane.showMessageDialog(parent, "Apparently not able to read GRIBTAB.");
                }
            } else {
                PanSourcesFrame sourcesFrame;
                PanSourcesFrame panSourcesFrame = sourcesFrame = PanSourcesFrame.findFrame(true);
                synchronized (panSourcesFrame) {
                    PanFileUtilities.openDataset(sourcesFrame, f);
                    if (!Panoply.isStarting()) {
                        sourcesFrame.reveal();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public static Object openLocalFileCL(Object address) {
        if (address == null) {
            throw new IllegalArgumentException("Address object is null.");
        }
        if (!(address instanceof File || address instanceof URI || address instanceof URL)) {
            throw new IllegalArgumentException("Address object must be File, URI or URL.");
        }
        File f = null;
        if (address instanceof File) {
            f = (File)address;
        } else if (address instanceof URI) {
            f = new File((URI)address);
        } else {
            if (address instanceof URL) {
                throw new RuntimeException("Not prepared to create a File object from a URL.");
            }
            throw new IllegalArgumentException("Address object must be File, URI or URL.");
        }
        if (!f.exists()) {
            throw new RuntimeException("File doesn't exist.");
        }
        if (NcFilenameFilter.accept(f)) {
            try {
                return new NcDataset(f);
            }
            catch (Exception exc) {
                System.err.printf("ERROR: Could not create NcDataset from %s.%n", f.getName());
                System.out.printf("MESSAGE: %s%n", exc.toString());
                return null;
            }
        }
        if (ColorTableFilenameFilter.isColorTableName(f)) {
            try {
                return PanColorTableList.getList().add(f);
            }
            catch (Exception exc) {
                System.err.printf("ERROR: Could not create color table from %s.%n", f.getName());
                System.out.printf("MESSAGE: %s%n", exc.toString());
            }
        } else if (OverlayFilenameFilter.isOverlayName(f)) {
            try {
                return PanOverlayList.getList().add(f);
            }
            catch (Exception exc) {
                System.err.printf("ERROR: Could not create overlay from %s.%n", f.getName());
                System.out.printf("MESSAGE: %s%n", exc.toString());
            }
        } else if (PanFileConstants.GRIB1TAB_FILTER.accept(f)) {
            System.err.println("ERROR: I am not able to open a GRIBTAB file.");
        } else {
            try {
                return new NcDataset(f);
            }
            catch (Exception exc) {
                System.err.printf("ERROR: Could not create NcDataset from %s.%n", f.getName());
                System.out.printf("MESSAGE: %s%n", exc.toString());
            }
        }
        return null;
    }

    public static NcDataset openLocalDatasetCL(Object address) {
        if (address == null) {
            throw new IllegalArgumentException("Address object is null.");
        }
        if (!(address instanceof File || address instanceof URI || address instanceof URL)) {
            throw new IllegalArgumentException("Address object must be File, URI or URL.");
        }
        File f = null;
        if (address instanceof File) {
            f = (File)address;
        } else if (address instanceof URI) {
            f = new File((URI)address);
        } else {
            if (address instanceof URL) {
                throw new RuntimeException("Not prepared to create a File object from a URL.");
            }
            throw new IllegalArgumentException("Address object must be File, URI or URL.");
        }
        if (!f.exists()) {
            throw new RuntimeException("File doesn't exist.");
        }
        try {
            return new NcDataset(f);
        }
        catch (Exception exc) {
            System.err.printf("ERROR: Could not create NcDataset from %s.%n", f.getName());
            System.out.printf("MESSAGE: %s%n", exc.toString());
            return null;
        }
    }

    public static void openDataset(JFrame jf, Object address) {
        PanFrame pf = jf == null ? PanFrame.getActiveFrame() : (PanFrame)jf;
        pf.addTask(new PanOpenDatasetTask(address));
    }

    public static void openRemoteCatalog(JFrame jf, Object address) {
        PanFrame pf = jf == null ? PanFrame.getActiveFrame() : (PanFrame)jf;
        pf.addTask(new PanOpenCatalogTask(address));
    }

    public static String extractDatasetFilenameRoot(File f) {
        return PanFileUtilities.extractDatasetFilenameRoot(f.getName());
    }

    public static String extractDatasetFilenameRoot(String s) {
        String lcs = s.toLowerCase();
        for (String ext : NcFilenameFilter.getExtensions()) {
            if (!lcs.endsWith("." + ext.toLowerCase())) continue;
            int elength = ext.length() + 1;
            int flength = s.length();
            return s.substring(0, flength - elength);
        }
        return s;
    }

    public static void showFileError(Component parent, String fname, Exception exc) {
        if (exc == null) {
            PanFileUtilities.showFileError(parent, fname, "");
        } else {
            PanFileUtilities.showFileError(parent, fname, exc.toString());
        }
    }

    public static void showFileError(Component parent, String fname, String message) {
        int colon;
        String message2 = null;
        message2 = message == null ? "" : ((colon = message.indexOf(": ")) > -1 ? message.substring(colon + 2) : message);
        GuiUtilities.showSlowMessage(parent, "File Error", "There was an error opening the file '" + fname + "':\n" + message2);
    }
}

