/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.actions.GissPrintAction;
import gov.nasa.giss.gui.menu.GissMenuItem;
import gov.nasa.giss.panoply.PanDisplayFrame;
import gov.nasa.giss.panoply.PanExportMenu;
import gov.nasa.giss.panoply.PanFileUtilities;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanHiddenMacFrame;
import gov.nasa.giss.panoply.PanMenu;
import gov.nasa.giss.panoply.PanOpenFileChooser;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.actions.PanSaveImageAction;
import gov.nasa.giss.panoply.actions.PanSaveImageAsAction;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanFileMenu
extends PanMenu {
    private static Logger logger_ = LoggerFactory.getLogger(PanFileMenu.class);

    public PanFileMenu(PanFrame parent) {
        super(parent, "file-menu");
        boolean isMacOS = PlatformUtilities.isMacintosh();
        this.add(this.makeItemFromProperties("new", null)).setEnabled(false);
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanFileMenu.handleOpenGeneric(PanFileMenu.this.pframe_);
            }
        };
        GissMenuItem jmi = this.makeItemFromProperties("open", a);
        this.add(jmi).setEnabled(true);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanFileMenu.handleLoadRemoteFile(PanFileMenu.this.pframe_);
            }
        };
        jmi = this.makeItemFromProperties("load-file", a);
        this.add(jmi).setEnabled(true);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanFileMenu.handleLoadRemoteCatalog(PanFileMenu.this.pframe_);
            }
        };
        jmi = this.makeItemFromProperties("load-catalog", a);
        this.add(jmi).setEnabled(true);
        if (isMacOS) {
            this.addSeparator();
        }
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanFileMenu.handleClose(PanFileMenu.this.pframe_);
            }
        };
        jmi = this.makeItemFromProperties("close", a);
        if (isMacOS) {
            this.add(jmi).setEnabled(!(parent instanceof PanHiddenMacFrame));
        } else {
            this.add(jmi).setEnabled(true);
        }
        if (!isMacOS) {
            this.addSeparator();
        }
        PanSaveImageAction a1 = null;
        PanSaveImageAsAction a2 = null;
        if (parent instanceof PanDisplayFrame) {
            a2 = new PanSaveImageAsAction((PanDisplayFrame)parent);
            a1 = new PanSaveImageAction((PanDisplayFrame)parent, a2);
        }
        GissMenuItem jmi1 = this.makeItemFromProperties("save-image", a1);
        GissMenuItem jmi2 = this.makeItemFromProperties("save-image-as", a2);
        this.add(jmi1).setEnabled(a1 != null);
        this.add(jmi2).setEnabled(a2 != null);
        this.addSeparator();
        this.add(new PanExportMenu(parent));
        GissMenuItem jmi3 = this.makeItemFromProperties("export-kmz", null);
        this.add(jmi3).setEnabled(false);
        jmi3 = this.makeItemFromProperties("export-animation", null);
        this.add(jmi3).setEnabled(false);
        this.addSeparator();
        a = parent instanceof Printable ? new GissPrintAction((Printable)((Object)parent)) : null;
        jmi = this.makeItemFromProperties("print", a);
        this.add(jmi).setEnabled(a != null);
        if (!isMacOS) {
            this.addSeparator();
        }
        if (!isMacOS) {
            a = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Panoply.quit();
                }
            };
            jmi = this.makeItemFromProperties("quit", a);
            this.add(jmi).setEnabled(true);
        }
    }

    private static void handleOpenGeneric(PanFrame pframe) {
        PanOpenFileChooser chooser = PanOpenFileChooser.getReadableChooser();
        int returnVal = chooser.showOpenDialog(pframe);
        if (returnVal != 0) {
            return;
        }
        File[] ff = chooser.getSelectedFiles();
        if (ff != null) {
            for (File f : ff) {
                PanFileUtilities.openLocalFile(pframe, f);
            }
        }
    }

    private static void handleLoadRemoteFile(PanFrame pframe) {
        URL url = PanFileUtilities.showLoadRemoteDialog(pframe, 0);
        if (url == null) {
            return;
        }
        PanFileUtilities.openDataset(pframe, url);
    }

    private static void handleLoadRemoteCatalog(PanFrame pframe) {
        URL url = PanFileUtilities.showLoadRemoteDialog(pframe, 1);
        if (url == null) {
            return;
        }
        PanFileUtilities.openRemoteCatalog(pframe, url);
    }

    private static void handleClose(PanFrame pframe) {
        if (pframe instanceof PanPlotFrame) {
            ((PanPlotFrame)pframe).close();
        } else {
            pframe.setVisible(false);
        }
    }
}

