/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanPlotSize;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.actions.PanCreatePlotAction;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PanDatasetsPopup
extends JPopupMenu {
    private AbstractAction xsmallAction_;
    private AbstractAction smallAction_;
    private AbstractAction standardAction_;
    private AbstractAction largeAction_;
    private AbstractAction xlargeAction_;
    private AbstractAction jumboAction_;
    private AbstractAction xjumboAction_;
    private AbstractAction exportCdlAction_;
    private AbstractAction exportCsvAction_;
    private AbstractAction exportTextAction_;
    private AbstractAction closeDatasetAction_;
    private PanSourcesFrame parent_;

    public PanDatasetsPopup(PanSourcesFrame parent) {
        this.parent_ = parent;
        this.xsmallAction_ = new AbstractAction(PanProperties.SOURCES.getString("popup-xsmall-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)PanDatasetsPopup.this.parent_.getAction("create-plot")).createPlot(PanPlotSize.XSMALL);
            }
        };
        this.add(new JMenuItem(this.xsmallAction_));
        this.smallAction_ = new AbstractAction(PanProperties.SOURCES.getString("popup-small-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)PanDatasetsPopup.this.parent_.getAction("create-plot")).createPlot(PanPlotSize.SMALL);
            }
        };
        this.add(new JMenuItem(this.smallAction_));
        this.standardAction_ = new AbstractAction(PanProperties.SOURCES.getString("popup-standard-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)PanDatasetsPopup.this.parent_.getAction("create-plot")).createPlot(PanPlotSize.STANDARD);
            }
        };
        this.add(new JMenuItem(this.standardAction_));
        this.largeAction_ = new AbstractAction(PanProperties.SOURCES.getString("popup-large-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)PanDatasetsPopup.this.parent_.getAction("create-plot")).createPlot(PanPlotSize.LARGE);
            }
        };
        this.add(new JMenuItem(this.largeAction_));
        this.xlargeAction_ = new AbstractAction(PanProperties.SOURCES.getString("popup-xlarge-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)PanDatasetsPopup.this.parent_.getAction("create-plot")).createPlot(PanPlotSize.XLARGE);
            }
        };
        this.add(new JMenuItem(this.xlargeAction_));
        this.jumboAction_ = new AbstractAction(PanProperties.SOURCES.getString("popup-jumbo-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)PanDatasetsPopup.this.parent_.getAction("create-plot")).createPlot(PanPlotSize.JUMBO);
            }
        };
        this.add(new JMenuItem(this.jumboAction_));
        this.xjumboAction_ = new AbstractAction(PanProperties.SOURCES.getString("popup-xjumbo-size")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)PanDatasetsPopup.this.parent_.getAction("create-plot")).createPlot(PanPlotSize.XJUMBO);
            }
        };
        this.add(new JMenuItem(this.xjumboAction_));
        this.addSeparator();
        this.exportCdlAction_ = new AbstractAction(PanProperties.SOURCES.getString("popup-export-cdl")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanDatasetsPopup.this.parent_.getAction("export-cdl").actionPerformed(null);
            }
        };
        this.add(new JMenuItem(this.exportCdlAction_));
        this.exportCsvAction_ = new AbstractAction(PanProperties.SOURCES.getString("popup-export-csv")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanDatasetsPopup.this.parent_.getAction("export-csv").actionPerformed(null);
            }
        };
        this.add(new JMenuItem(this.exportCsvAction_));
        this.exportTextAction_ = new AbstractAction(PanProperties.SOURCES.getString("popup-export-text")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanDatasetsPopup.this.parent_.getAction("export-text").actionPerformed(null);
            }
        };
        this.add(new JMenuItem(this.exportTextAction_));
        this.addSeparator();
        this.closeDatasetAction_ = new AbstractAction(PanProperties.SOURCES.getString("popup-remove-one")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanDatasetsPopup.this.parent_.getAction("remove-one").actionPerformed(null);
            }
        };
        this.add(new JMenuItem(this.closeDatasetAction_));
    }

    void refresh(NcNode node) {
        this.xsmallAction_.setEnabled(false);
        this.smallAction_.setEnabled(false);
        this.standardAction_.setEnabled(false);
        this.largeAction_.setEnabled(false);
        this.xlargeAction_.setEnabled(false);
        this.jumboAction_.setEnabled(false);
        this.xjumboAction_.setEnabled(false);
        this.exportCdlAction_.setEnabled(false);
        this.exportCsvAction_.setEnabled(false);
        this.exportTextAction_.setEnabled(false);
        this.closeDatasetAction_.setEnabled(false);
        if (node == null) {
            return;
        }
        if (node instanceof NcDataset) {
            this.exportCdlAction_.setEnabled(true);
            this.closeDatasetAction_.setEnabled(true);
            return;
        }
        if (!(node instanceof NcVariable)) {
            return;
        }
        this.exportCdlAction_.setEnabled(true);
        this.exportCsvAction_.setEnabled(true);
        this.exportTextAction_.setEnabled(true);
        if (((NcVariable)node).isPlottable()) {
            this.xsmallAction_.setEnabled(true);
            this.smallAction_.setEnabled(true);
            this.standardAction_.setEnabled(PanPlotSize.STANDARD.fitsDisplay());
            this.largeAction_.setEnabled(PanPlotSize.LARGE.fitsDisplay());
            this.xlargeAction_.setEnabled(PanPlotSize.XLARGE.fitsDisplay());
            this.jumboAction_.setEnabled(PanPlotSize.JUMBO.fitsDisplay());
            this.xjumboAction_.setEnabled(PanPlotSize.XJUMBO.fitsDisplay());
        }
    }
}

