/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.netcdf.NcFilenameFilter;
import gov.nasa.giss.panoply.PanFileUtilities;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.PanSourcesTreeTablePanel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDatasetsPanelDropTargetAdapter
extends DropTargetAdapter {
    private static Logger logger_ = LoggerFactory.getLogger(PanDatasetsPanelDropTargetAdapter.class);
    private PanSourcesTreeTablePanel target_;

    public PanDatasetsPanelDropTargetAdapter(PanSourcesTreeTablePanel target) {
        this.target_ = target;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.target_.toggleBorderActive(true);
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.target_.toggleBorderActive(true);
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.target_.toggleBorderActive(false);
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            List flist = null;
            try {
                flist = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            if (flist != null) {
                PanSourcesFrame sourcesFrame = PanSourcesFrame.findFrame(true);
                sourcesFrame.toFront();
                int isize = flist.size();
                for (int i = 0; i < isize; ++i) {
                    File f = (File)flist.get(i);
                    if (!NcFilenameFilter.accept(f)) continue;
                    PanFileUtilities.openDataset(sourcesFrame, f);
                }
            }
            e.dropComplete(true);
        } else {
            e.rejectDrop();
        }
        this.target_.toggleBorderActive(false);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.target_.toggleBorderActive(false);
    }
}

