/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.event.TreeTableEvent;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanDatasetsPopup;
import gov.nasa.giss.panoply.PanHistoryList;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.PanSourcesSplitSubpanel;
import gov.nasa.giss.panoply.PanSourcesTreeTablePanel;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.panoply.actions.PanCombinePlotAction;
import gov.nasa.giss.panoply.actions.PanCreatePlotAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDatasetsPanel
extends PanSourcesSplitSubpanel {
    private static Logger logger_ = LoggerFactory.getLogger(PanDatasetsPanel.class);
    private JCheckBox onlyPlottablesCB_;
    protected PanDatasetsPopup popup_;

    public PanDatasetsPanel(PanSourcesFrame parent) {
        super(parent);
    }

    @Override
    protected JComponent makeTreeBox() {
        final PanPreferences prefs = PanPreferences.getPrefs();
        this.ttPanel_ = new PanSourcesTreeTablePanel();
        this.ttPanel_.setOpaque(true);
        this.ttPanel_.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.GRAY));
        this.onlyPlottablesCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, null, PanProperties.SOURCES.getString("toggle-plottables"), prefs.getBoolean("sources:nodes.plottables"));
        QuickBox vlBox = QuickBox.createCenterBox(this.onlyPlottablesCB_);
        int w = this.onlyPlottablesCB_.getPreferredSize().width;
        int h = this.onlyPlottablesCB_.getPreferredSize().height;
        vlBox.setMaximumSize(new Dimension(32000, h));
        QuickBox ttBox = QuickBox.createVerticalBox(this.ttPanel_, Box.createVerticalStrut(2), vlBox);
        ttBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        ttBox.setOpaque(false);
        this.ttPanel_.addTreeTableListener(this);
        this.onlyPlottablesCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean onlyPlottables = PanDatasetsPanel.this.onlyPlottablesCB_.isSelected();
                prefs.setBoolean("sources:nodes.plottables", onlyPlottables);
                ((PanSourcesTreeTablePanel)PanDatasetsPanel.this.ttPanel_).setShowOnlyPlottables(onlyPlottables);
                PanDatasetsPanel.this.refreshActions();
                PanDatasetsPanel.this.parent_.getPanMenuBar().refresh();
            }
        });
        return ttBox;
    }

    public void setShowOnlyPlottables(boolean onlyPlottables) {
        this.onlyPlottablesCB_.setSelected(onlyPlottables);
    }

    public void clearPopup() {
        if (this.popup_ != null) {
            this.popup_.setVisible(false);
        }
    }

    @Override
    public synchronized void refreshActions() {
        PanPreferences prefs = PanPreferences.getPrefs();
        if (this.ttPanel_ != null) {
            ((PanSourcesTreeTablePanel)this.ttPanel_).setExpandNewNodes(prefs.getBoolean("sources:nodes.expanded"));
        }
        if (GuiUtilities.getParentFrame(this) == null) {
            return;
        }
        this.parent_.disableActions();
        this.parent_.enableAction("toggle-info", true);
        this.parent_.enableAction("toggle-plottables", true);
        this.parent_.enableAction("remove-all", !this.areAllDatasetsInUse());
        TreeTableNode node = this.getSelectedNode();
        if (node != null) {
            if (node instanceof NcDataset) {
                this.parent_.enableAction("remove-one", !this.isDatasetInUse((NcDataset)node));
                this.parent_.enableAction("export-cdl", true);
                this.parent_.enableAction("add-bookmark", true);
            } else if (node instanceof NcVariable) {
                this.parent_.enableAction("export-cdl", true);
                this.parent_.enableAction("export-csv", true);
                this.parent_.enableAction("export-text", true);
                if (((NcVariable)node).isPlottable()) {
                    PanCreatePlotAction a = (PanCreatePlotAction)this.parent_.getAction("create-plot");
                    boolean enabled = !a.isBusy() && PanPlotFrame.countVisibleFrames() < 10;
                    this.parent_.enableAction("create-plot", enabled);
                }
                if (((NcVariable)node).isPlottable()) {
                    PanPlotFrame[] plotFrames = PanPlotFrame.getListOfFrames();
                    PanCombinePlotAction a = (PanCombinePlotAction)this.parent_.getAction("combine-plot");
                    boolean enabled = plotFrames.length > 0 && !a.isBusy();
                    this.parent_.enableAction("combine-plot", enabled);
                }
            }
        }
        if (node == null) {
            this.infoPane_.setContentType("text/plain");
            this.infoPane_.setText("");
        } else {
            String oldText = this.infoPane_.getText();
            String newText = ((NcNode)node).getDetail();
            if (oldText == null || !newText.equals(oldText)) {
                String newType = ((NcNode)node).getDetailType();
                this.infoPane_.setContentType(newType);
                this.infoPane_.setText(newText);
                this.infoPane_.setCaretPosition(0);
                String string = newText;
            }
        }
    }

    @Override
    public void clear() {
        for (Object o : ((PanSourcesTreeTablePanel)this.ttPanel_).getDatasets()) {
            if (!(o instanceof NcDataset)) continue;
            this.removeNode((NcNode)o);
        }
    }

    public synchronized int getDatasetCount() {
        return ((PanSourcesTreeTablePanel)this.ttPanel_).getDatasetCount();
    }

    public NcDataset addDataset(NcDataset ncd) throws IOException {
        if (ncd == null) {
            return null;
        }
        PanPreferences prefs = PanPreferences.getPrefs();
        ncd.setShowOnlyPlottables(null, prefs.getBoolean("sources:nodes.plottables"));
        ((PanSourcesTreeTablePanel)this.ttPanel_).addDataset(ncd);
        return ncd;
    }

    @Override
    public void removeNode(TreeTableNode node) {
        if (node == null) {
            return;
        }
        if (!(node instanceof NcDataset)) {
            throw new IllegalArgumentException("Can only remove a NcDataset");
        }
        NcDataset ncd = (NcDataset)node;
        if (!this.isDatasetInUse(ncd)) {
            try {
                ncd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((PanSourcesTreeTablePanel)this.ttPanel_).removeDataset(ncd);
        }
        this.refreshActions();
    }

    private boolean isDatasetInUse(NcDataset ncd) {
        for (PanPlotFrame pframe : PanPlotFrame.getListOfFrames()) {
            for (NcArray array : pframe.getArrays()) {
                if (array == null || array.getDataset() != ncd) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areAllDatasetsInUse() {
        Object[] nodes = ((PanSourcesTreeTablePanel)this.ttPanel_).getDatasets();
        if (nodes.length == 0) {
            return true;
        }
        for (Object o : nodes) {
            if (!(o instanceof NcDataset) || this.isDatasetInUse((NcDataset)o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void itemAdded(TreeTableEvent e) {
        this.refreshActions();
        NcNode node = (NcNode)e.getNode();
        if (node == null || !(node instanceof NcDataset)) {
            return;
        }
        PanHistoryList.getList().addBookmark((NcDataset)node);
        GuiUtilities.refreshFrontFrameMenuBar();
    }

    @Override
    public void removalRequested(TreeTableEvent e) {
    }

    @Override
    public void selectionMade(TreeTableEvent e) {
        this.refreshActions();
        NcNode node = (NcNode)e.getNode();
        if (node == null) {
            return;
        }
        int id = e.getID();
        Point pt = e.getPoint();
        if (id == 102 && node instanceof NcVariable) {
            this.parent_.getAction("create-plot").actionPerformed(null);
        } else if (id == 103 && pt != null) {
            if (this.popup_ == null) {
                this.popup_ = new PanDatasetsPopup(this.parent_);
            }
            this.popup_.refresh(node);
            this.popup_.show(this.ttPanel_, pt.x, pt.y);
        }
    }
}

