/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.menu.GissMenu;
import gov.nasa.giss.gui.tabbedpane.FolderTabbedPane;
import gov.nasa.giss.panoply.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.PanArrayControls;
import gov.nasa.giss.panoply.PanContourAndVectorControls;
import gov.nasa.giss.panoply.PanLabelControls;
import gov.nasa.giss.panoply.PanLatVertGridControls;
import gov.nasa.giss.panoply.PanLonLatPlotType;
import gov.nasa.giss.panoply.PanLonLatZonalControls;
import gov.nasa.giss.panoply.PanLonVertGridControls;
import gov.nasa.giss.panoply.PanMapControls;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPlotType;
import gov.nasa.giss.panoply.PanProperties;
import gov.nasa.giss.panoply.PanScaleControls;
import gov.nasa.giss.panoply.PanTimeLatGridControls;
import gov.nasa.giss.panoply.plot.PanAbstractPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.plot.PlotPropertyEvent;
import gov.nasa.giss.plot.PlotPropertyListener;
import java.awt.Container;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanControlsTabbedPane
extends FolderTabbedPane
implements PlotPropertyListener {
    private static Logger logger_ = LoggerFactory.getLogger(PanControlsTabbedPane.class);
    private PanPlotMeta pmeta_;
    private PanPlotType plotType_;
    private PanAbstractControlsPanel arrayControls_;
    private PanAbstractControlsPanel scaleControls_;
    private PanAbstractControlsPanel contourControls_;
    private PanAbstractControlsPanel llMapControls_;
    private PanAbstractControlsPanel llZonalControls_;
    private PanAbstractControlsPanel gridControls_;
    private PanAbstractControlsPanel labelControls_;

    public PanControlsTabbedPane(PanPlotFrame parent, PanMenuBar mbar, PanPlotMeta pmeta) {
        this.setFixedButtonWidth(false);
        this.pmeta_ = pmeta;
        this.plotType_ = pmeta.getType();
        PanAbstractData data = pmeta.getData();
        PanAbstractPlot plot = pmeta.getPlot();
        this.arrayControls_ = new PanArrayControls(pmeta, mbar);
        this.addTab(PanProperties.PCONTROLS.getString("arrays-tab"), this.arrayControls_);
        this.scaleControls_ = new PanScaleControls(pmeta, mbar);
        this.addTab(PanProperties.PCONTROLS.getString("scale-tab"), this.scaleControls_);
        if (this.plotType_ == PanPlotType.LON_LAT || this.plotType_ == PanPlotType.LAT_VERT) {
            this.contourControls_ = new PanContourAndVectorControls(pmeta);
            this.addTab(PanProperties.PCONTROLS.getString("contours-and-vectors-tab"), this.contourControls_);
        } else {
            this.contourControls_ = new PanContourAndVectorControls(pmeta);
            this.addTab(PanProperties.PCONTROLS.getString("contours-tab"), this.contourControls_);
        }
        if (this.plotType_ == PanPlotType.LON_LAT) {
            if (PanLonLatPlotType.ZONAL.matches(this.pmeta_.getString("plot:lonlat.type"))) {
                this.llZonalControls_ = new PanLonLatZonalControls(pmeta);
                this.addTab(PanProperties.PCONTROLS.getString("zonal-tab"), this.llZonalControls_);
            } else {
                this.llMapControls_ = new PanMapControls(pmeta, mbar);
                this.addTab(PanProperties.PCONTROLS.getString("map-tab"), this.llMapControls_);
            }
        } else if (this.plotType_ == PanPlotType.LAT_VERT) {
            this.gridControls_ = new PanLatVertGridControls(pmeta);
            this.addTab(PanProperties.PCONTROLS.getString("grid-tab"), this.gridControls_);
        } else if (this.plotType_ == PanPlotType.LON_VERT) {
            this.gridControls_ = new PanLonVertGridControls(pmeta);
            this.addTab(PanProperties.PCONTROLS.getString("grid-tab"), this.gridControls_);
        } else if (this.plotType_ == PanPlotType.TIME_LAT) {
            this.gridControls_ = new PanTimeLatGridControls(pmeta);
            this.addTab(PanProperties.PCONTROLS.getString("grid-tab"), this.gridControls_);
        }
        this.labelControls_ = new PanLabelControls(pmeta, mbar);
        this.addTab(PanProperties.PCONTROLS.getString("labels-tab"), this.labelControls_);
        this.pmeta_.addPlotPropertyListener(this);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanControlsTabbedPane.this.refresh();
            }
        });
    }

    public void setSelectedComponent(String tabname) {
        PanAbstractControlsPanel acp = this.getComponent(tabname);
        if (acp != null) {
            this.setSelectedComponent(acp);
        }
        this.refresh();
    }

    public PanAbstractControlsPanel getComponent(String tabname) {
        if (tabname.equals("arrays-tab") || tabname.equals(PanProperties.PCONTROLS.getString("arrays-tab"))) {
            return this.arrayControls_;
        }
        if (tabname.equals("scale-tab") || tabname.equals(PanProperties.PCONTROLS.getString("arrays-tab"))) {
            return this.scaleControls_;
        }
        if (tabname.equals("contours-tab") || tabname.equals("contours-and-vectors-tab") || tabname.equals(PanProperties.PCONTROLS.getString("contours-tab")) || tabname.equals(PanProperties.PCONTROLS.getString("contours-and-vectors-tab"))) {
            return this.contourControls_;
        }
        if (tabname.equals("grid-tab") || tabname.equals("map-tab") || tabname.equals("zonal-tab") || tabname.equals(PanProperties.PCONTROLS.getString("grid-tab")) || tabname.equals(PanProperties.PCONTROLS.getString("map-tab")) || tabname.equals(PanProperties.PCONTROLS.getString("zonal-tab"))) {
            if (this.plotType_ == PanPlotType.LON_LAT) {
                int zonalIndex;
                int mapIndex = this.llMapControls_ == null ? -1 : this.indexOfComponent(this.llMapControls_);
                int n = zonalIndex = this.llZonalControls_ == null ? -1 : this.indexOfComponent(this.llZonalControls_);
                if (mapIndex > -1) {
                    return this.llMapControls_;
                }
                return this.llZonalControls_;
            }
            return this.gridControls_;
        }
        if (tabname.equals("labels-tab") || tabname.equals(PanProperties.PCONTROLS.getString("labels-tab"))) {
            return this.labelControls_;
        }
        return null;
    }

    public void refresh() {
        Container c = this.getTopLevelAncestor();
        if (c == null) {
            return;
        }
        PanMenuBar mbar = ((PanPlotFrame)c).getPanMenuBar();
        GissMenu viewMenu = mbar.getMenuByName("view-menu");
        if (viewMenu == null) {
            return;
        }
        PanAbstractControlsPanel tab = (PanAbstractControlsPanel)this.getSelectedComponent();
        if (tab == null) {
            return;
        }
        tab.refresh();
        JMenuItem item = tab == this.arrayControls_ ? viewMenu.getItemByName("show-array-controls") : (tab == this.scaleControls_ ? viewMenu.getItemByName("show-scale-controls") : (tab == this.contourControls_ ? viewMenu.getItemByName("show-contour-controls") : (tab == this.labelControls_ ? viewMenu.getItemByName("show-label-controls") : viewMenu.getItemByName("show-grid-controls"))));
        ((JRadioButtonMenuItem)item).setSelected(true);
    }

    public synchronized void flush() {
        if (this.pmeta_ != null) {
            this.pmeta_.flush();
            this.pmeta_ = null;
        }
        if (this.arrayControls_ != null) {
            this.arrayControls_.flush();
            this.arrayControls_ = null;
        }
        if (this.contourControls_ != null) {
            this.contourControls_.flush();
            this.contourControls_ = null;
        }
        if (this.scaleControls_ != null) {
            this.scaleControls_.flush();
            this.scaleControls_ = null;
        }
        if (this.llMapControls_ != null) {
            this.llMapControls_.flush();
            this.llMapControls_ = null;
        }
        if (this.labelControls_ != null) {
            this.labelControls_.flush();
            this.labelControls_ = null;
        }
        if (this.llZonalControls_ != null) {
            this.llZonalControls_.flush();
            this.llZonalControls_ = null;
        }
        if (this.gridControls_ != null) {
            this.gridControls_.flush();
            this.gridControls_ = null;
        }
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        if (pname == null) {
            return;
        }
        if (!pname.equals("plot:lonlat.type")) {
            return;
        }
        String switchTo = this.pmeta_.getString("plot:lonlat.type");
        int currentIndex = this.getSelectedIndex();
        int mTabNum = this.indexOfTab(PanProperties.PCONTROLS.getString("map-tab"));
        int zTabNum = this.indexOfTab(PanProperties.PCONTROLS.getString("zonal-tab"));
        if (PanLonLatPlotType.ZONAL.matches(switchTo)) {
            if (this.llZonalControls_ == null) {
                this.llZonalControls_ = new PanLonLatZonalControls(this.pmeta_);
            }
            if (mTabNum > -1 && zTabNum == -1) {
                this.removeTabAt(mTabNum);
                this.insertTab(PanProperties.PCONTROLS.getString("zonal-tab"), null, this.llZonalControls_, null, mTabNum);
            }
        } else {
            if (this.llMapControls_ == null) {
                Container c = this.getTopLevelAncestor();
                if (c == null) {
                    return;
                }
                PanMenuBar mbar = ((PanPlotFrame)c).getPanMenuBar();
                this.llMapControls_ = new PanMapControls(this.pmeta_, mbar);
            }
            if (mTabNum == -1 && zTabNum > 1) {
                this.removeTabAt(zTabNum);
                this.insertTab(PanProperties.PCONTROLS.getString("map-tab"), null, this.llMapControls_, null, zTabNum);
            }
            this.llMapControls_.refresh();
        }
        this.setSelectedIndex(currentIndex);
    }
}

