/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.panoply.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.PanContourLocation;
import gov.nasa.giss.panoply.PanContourStyle;
import gov.nasa.giss.panoply.PanEnumMenu;
import gov.nasa.giss.panoply.PanMenuItemEnum;
import gov.nasa.giss.panoply.PanWidgetUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanContourPrefsPanel
extends PanAbstractPrefsPanel {
    private PanEnumMenu styleMenu_ = PanWidgetUtils.getEnumMenu(PanWidgetUtils.Size.NORMAL, null, PanContourStyle.class);
    private JComboBox locationMenu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.NORMAL, null, PanContourLocation.values());
    private JCheckBox labelsCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "Show labels");
    private ColorMenu colorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.NORMAL, null, PaletteType.RAINBOW);
    private PercentSpinner opacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.NORMAL, null);

    public PanContourPrefsPanel() {
        FlexingGridLayout fgl = new FlexingGridLayout(4, 3, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtilities.createPaddedTitleBorder("Contour Defaults"));
        this.add((Component)new JLabel("Style: "), new FGConstraint(0, 0, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.styleMenu_, new JLabel(", "), this.labelsCB_), new FGConstraint(1, 0, 0.0, 0.5));
        this.add((Component)new JLabel("Location: "), new FGConstraint(0, 1, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.locationMenu_), new FGConstraint(1, 1, 0.0, 0.5));
        this.add((Component)new JLabel("Color: "), new FGConstraint(0, 2, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.colorMenu_, new JLabel(", Opacity: "), this.opacitySpinner_), new FGConstraint(1, 2, 0.0, 0.5));
        this.refresh();
        this.styleMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanContourPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:contour.style", ((PanMenuItemEnum)PanContourPrefsPanel.this.styleMenu_.getSelectedItem()).getValue());
            }
        });
        this.labelsCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanContourPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setBoolean("plot:contour.labels", PanContourPrefsPanel.this.labelsCB_.isSelected());
            }
        });
        this.locationMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanContourPrefsPanel.this.locationMenu_.getSelectedItem() == PanContourLocation.MINOR) {
                    PanAbstractPrefsPanel.PREFS.set("plot:contour.location", "minor");
                } else {
                    PanAbstractPrefsPanel.PREFS.set("plot:contour.location", "major");
                }
            }
        });
        this.colorMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanContourPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:contour.color", PanContourPrefsPanel.this.colorMenu_.getSelectedColor());
            }
        });
        this.opacitySpinner_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PanContourPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setInt("plot:contour.weight", PanContourPrefsPanel.this.opacitySpinner_.getIntValue());
            }
        });
    }

    @Override
    public void refresh() {
        this.refreshing_ = true;
        this.styleMenu_.setSelectedItem(PREFS.getString("plot:contour.style"));
        this.labelsCB_.setSelected(PREFS.getBoolean("plot:contour.labels"));
        if (PREFS.getString("plot:contour.location").equalsIgnoreCase("minor")) {
            this.locationMenu_.setSelectedItem(PanContourLocation.MINOR);
        } else {
            this.locationMenu_.setSelectedItem(PanContourLocation.MAJOR);
        }
        this.colorMenu_.setSelectedColor(PREFS.getColor("plot:contour.color"));
        this.opacitySpinner_.setValue(PREFS.getInt("plot:contour.weight"));
        this.refreshing_ = false;
    }
}

