/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.gui.spinner.IntSpinner;
import gov.nasa.giss.gui.spinner.PercentSpinner;
import gov.nasa.giss.panoply.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanContourLocation;
import gov.nasa.giss.panoply.PanContourStyle;
import gov.nasa.giss.panoply.PanEnumMenu;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanPlotType;
import gov.nasa.giss.panoply.PanVectorStyle;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanContourAndVectorControls
extends PanAbstractControlsPanel {
    private boolean vectorsAllowed_;
    private boolean vectorsEnabled_;
    private PanEnumMenu cStyleMenu_;
    private JComboBox vArray1Menu_;
    private JComboBox vArray2Menu_;
    private PanEnumMenu vStyleMenu_;
    private ColorMenu vColorMenu_;
    private PercentSpinner vOpacitySpinner_;
    private JTextField vLengthTF_;
    private IntSpinner vSpacingSpinner_;

    public PanContourAndVectorControls(PanPlotMeta pmeta) {
        super("contour-controls", pmeta);
        final PanPlotType ptype = (PanPlotType)((Object)this.pmeta_.get("plot:type"));
        this.vectorsAllowed_ = ptype == PanPlotType.LON_LAT || ptype == PanPlotType.LAT_VERT;
        JLabel cStyleLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Contour Style: ");
        this.cStyleMenu_ = PanWidgetUtils.getEnumMenu(PanWidgetUtils.Size.SMALL, "plot:contour.style", PanContourStyle.class);
        this.cStyleMenu_.setSelectedItem(this.pmeta_.getString("plot:contour.style"));
        JLabel cCommaLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", ");
        final JCheckBox cLabelsCB = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.SMALL, "plot:contour.labels", "Show labels", this.pmeta_.getBoolean("plot:contour.labels"));
        QuickBox cbox1 = QuickBox.createLeftBox(cStyleLabel, this.cStyleMenu_, cCommaLabel, cLabelsCB);
        JLabel cLocationLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Contour Locations: ");
        final JComboBox cLocationMenu = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.SMALL, "plot:contour.location", PanContourLocation.values());
        if (this.pmeta_.getString("plot:contour.location").equalsIgnoreCase("minor")) {
            cLocationMenu.setSelectedItem(PanContourLocation.MINOR);
        } else {
            cLocationMenu.setSelectedItem(PanContourLocation.MAJOR);
        }
        QuickBox cbox2 = QuickBox.createLeftBox(cLocationLabel, cLocationMenu);
        JLabel cColorLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Contour Color: ");
        final ColorMenu cColorMenu = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.SMALL, "plot:contour.color", PaletteType.RAINBOW);
        JLabel cOpacityLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Opacity: ");
        final PercentSpinner cOpacitySpinner = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.SMALL, "plot:contour.weight", this.pmeta_.getInt("plot:contour.weight"));
        JLabel cPctLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "%");
        cColorMenu.setSelectedColor(this.pmeta_.getColor("plot:contour.color"));
        QuickBox cbox3 = QuickBox.createLeftBox(cColorLabel, cColorMenu, cOpacityLabel, cOpacitySpinner, cPctLabel);
        QuickBox vbox1 = null;
        QuickBox vbox2 = null;
        QuickBox vbox3 = null;
        QuickBox vboxA1 = null;
        QuickBox vboxA2 = null;
        JLabel vStyleLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Vector Style: ");
        JLabel vColorLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Vector Color: ");
        JLabel vLengthLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Scale Length: ");
        JLabel vSpacingLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Spacing: ");
        JLabel vSpPctLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "%");
        if (this.vectorsAllowed_) {
            JLabel vArray1Label = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Array 1 values are positive ");
            JLabel vArray2Label = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "Array 2 values are positive ");
            if (ptype == PanPlotType.LON_LAT) {
                this.vArray1Menu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.vector.direction1", new String[]{"East", "North", "West", "South"});
                this.vArray1Menu_.setSelectedItem(this.pmeta_.getString("plot:lonlat.map.vector.direction1"));
                this.vArray2Menu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.SMALL, "plot:lonlat.map.vector.direction2", new String[]{"North", "South"});
                this.vArray2Menu_.setSelectedItem(this.pmeta_.getString("plot:lonlat.map.vector.direction2"));
            } else if (ptype == PanPlotType.LAT_VERT) {
                this.vArray1Menu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.SMALL, "plot:latvert.vector.direction1", new String[]{"North", "Up", "South", "Down"});
                this.vArray1Menu_.setSelectedItem(this.pmeta_.getString("plot:latvert.vector.direction1"));
                this.vArray2Menu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.SMALL, "plot:latvert.vector.direction2", new String[]{"Up", "Down"});
                this.vArray2Menu_.setSelectedItem(this.pmeta_.getString("plot:latvert.vector.direction2"));
            }
            vboxA1 = QuickBox.createLeftBox(vArray1Label, this.vArray1Menu_);
            vboxA2 = QuickBox.createLeftBox(vArray2Label, this.vArray2Menu_);
            this.vStyleMenu_ = PanWidgetUtils.getEnumMenu(PanWidgetUtils.Size.SMALL, "plot:vector.style", PanVectorStyle.class);
            this.vStyleMenu_.setSelectedItem(this.pmeta_.getString("plot:vector.style"));
            vbox1 = QuickBox.createLeftBox(vStyleLabel, this.vStyleMenu_);
            this.vColorMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.SMALL, "plot:vector.color", PaletteType.RAINBOW);
            JLabel vOpacityLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, ", Opacity: ");
            this.vOpacitySpinner_ = PanWidgetUtils.getPercentSpinner(PanWidgetUtils.Size.SMALL, "plot:vector.weight", this.pmeta_.getInt("plot:vector.weight"));
            JLabel vPctLabel = PanWidgetUtils.getLabel(PanWidgetUtils.Size.SMALL, "%");
            this.vColorMenu_.setSelectedColor(this.pmeta_.getColor("plot:vector.color"));
            vbox2 = QuickBox.createLeftBox(vColorLabel, this.vColorMenu_, vOpacityLabel, this.vOpacitySpinner_, vPctLabel);
            this.vLengthTF_ = PanWidgetUtils.getTextField(PanWidgetUtils.Size.SMALL, "plot:vector.value", null, "1000.00", 6);
            this.vLengthTF_.setHorizontalAlignment(4);
            this.vLengthTF_.setText(PanConstants.PFORMAT_2.sprintf(this.pmeta_.getDouble("plot:vector.value")));
            this.vSpacingSpinner_ = PanWidgetUtils.getIntSpinner(PanWidgetUtils.Size.SMALL, "plot:vector.spacing", this.pmeta_.getInt("plot:vector.spacing"), 25, 250, 1);
            vbox3 = QuickBox.createLeftBox(vLengthLabel, this.vLengthTF_, vSpacingLabel, this.vSpacingSpinner_, vSpPctLabel);
        }
        FlexingGridLayout fgl = new FlexingGridLayout(2, 6, 0, 2);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        fgl.setRowWeight(5, 9999.0f);
        this.add((Component)cbox1, new FGConstraint(0, 0, 0.0, 0.5));
        this.add((Component)cbox2, new FGConstraint(0, 1, 0.0, 0.5));
        this.add((Component)cbox3, new FGConstraint(0, 2, 0.0, 0.5));
        if (vbox1 != null) {
            this.add(vbox1, new FGConstraint(1, 0, 0.0, 0.5));
            this.add(vbox2, new FGConstraint(1, 1, 0.0, 0.5));
            this.add((Component)vboxA1, new FGConstraint(1, 2, 0.0, 0.5));
            this.add((Component)vboxA2, new FGConstraint(1, 3, 0.0, 0.5));
            this.add(vbox3, new FGConstraint(1, 4, 0.0, 0.5));
        }
        int cwidth = cStyleLabel.getPreferredSize().width;
        cwidth = Math.max(cwidth, cLocationLabel.getPreferredSize().width);
        cwidth = Math.max(cwidth, cColorLabel.getPreferredSize().width);
        Dimension csize = new Dimension(cwidth, cStyleLabel.getPreferredSize().height);
        cStyleLabel.setPreferredSize(csize);
        cStyleLabel.setMaximumSize(csize);
        cLocationLabel.setPreferredSize(csize);
        cLocationLabel.setMaximumSize(csize);
        cColorLabel.setPreferredSize(csize);
        cColorLabel.setMaximumSize(csize);
        if (vbox1 != null) {
            int lwidth = Math.max(vStyleLabel.getPreferredSize().width, vColorLabel.getPreferredSize().width);
            lwidth = Math.max(lwidth, vLengthLabel.getPreferredSize().width);
            Dimension lsize = new Dimension(lwidth, vStyleLabel.getPreferredSize().height);
            vStyleLabel.setPreferredSize(lsize);
            vStyleLabel.setMinimumSize(lsize);
            vColorLabel.setPreferredSize(lsize);
            vColorLabel.setMinimumSize(lsize);
            vLengthLabel.setPreferredSize(lsize);
            vLengthLabel.setMinimumSize(lsize);
        }
        this.cStyleMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PanContourAndVectorControls.this.pmeta_.put("plot:contour.style", (Object)PanContourAndVectorControls.this.cStyleMenu_.getStringValue());
            }
        });
        cLabelsCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanContourAndVectorControls.this.pmeta_.setBoolean("plot:contour.labels", cLabelsCB.isSelected());
            }
        });
        cLocationMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (cLocationMenu.getSelectedItem() == PanContourLocation.MINOR) {
                    PanContourAndVectorControls.this.pmeta_.put("plot:contour.location", (Object)"minor");
                } else {
                    PanContourAndVectorControls.this.pmeta_.put("plot:contour.location", (Object)"major");
                }
            }
        });
        cColorMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Color cold;
                if (e.getStateChange() != 1) {
                    return;
                }
                Color cnew = cColorMenu.getSelectedColor();
                if (!cnew.equals(cold = PanContourAndVectorControls.this.pmeta_.getColor("plot:contour.color"))) {
                    PanContourAndVectorControls.this.pmeta_.setColor("plot:contour.color", cnew);
                }
            }
        });
        cOpacitySpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PanContourAndVectorControls.this.pmeta_.setInt("plot:contour.weight", cOpacitySpinner.getIntValue());
            }
        });
        if (this.vectorsAllowed_) {
            if (ptype == PanPlotType.LON_LAT) {
                this.vArray1Menu_.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() != 1) {
                            return;
                        }
                        String newval1 = PanContourAndVectorControls.this.vArray1Menu_.getSelectedItem().toString();
                        String newval2 = PanContourAndVectorControls.this.vArray2Menu_.getSelectedItem().toString();
                        if ((newval1.equals("East") || newval1.equals("West")) && (newval2.equals("East") || newval2.equals("West"))) {
                            PanContourAndVectorControls.this.vArray2Menu_.removeAllItems();
                            PanContourAndVectorControls.this.vArray2Menu_.addItem("North");
                            PanContourAndVectorControls.this.vArray2Menu_.addItem("South");
                            PanContourAndVectorControls.this.vArray2Menu_.setSelectedItem("North");
                        } else if ((newval1.equals("North") || newval1.equals("South")) && (newval2.equals("North") || newval2.equals("South"))) {
                            PanContourAndVectorControls.this.vArray2Menu_.removeAllItems();
                            PanContourAndVectorControls.this.vArray2Menu_.addItem("East");
                            PanContourAndVectorControls.this.vArray2Menu_.addItem("West");
                            PanContourAndVectorControls.this.vArray2Menu_.setSelectedItem("East");
                        }
                        PanContourAndVectorControls.this.pmeta_.put("plot:lonlat.map.vector.direction1", (Object)newval1);
                        GuiUtilities.restrictSize(PanContourAndVectorControls.this.vArray2Menu_);
                    }
                });
            } else if (ptype == PanPlotType.LAT_VERT) {
                this.vArray1Menu_.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() != 1) {
                            return;
                        }
                        String newval1 = PanContourAndVectorControls.this.vArray1Menu_.getSelectedItem().toString();
                        String newval2 = PanContourAndVectorControls.this.vArray2Menu_.getSelectedItem().toString();
                        if ((newval1.equals("Up") || newval1.equals("Down")) && (newval2.equals("Up") || newval2.equals("Down"))) {
                            PanContourAndVectorControls.this.vArray2Menu_.removeAllItems();
                            PanContourAndVectorControls.this.vArray2Menu_.addItem("North");
                            PanContourAndVectorControls.this.vArray2Menu_.addItem("South");
                            PanContourAndVectorControls.this.vArray2Menu_.setSelectedItem("North");
                        } else if ((newval1.equals("North") || newval1.equals("South")) && (newval2.equals("North") || newval2.equals("South"))) {
                            PanContourAndVectorControls.this.vArray2Menu_.removeAllItems();
                            PanContourAndVectorControls.this.vArray2Menu_.addItem("Up");
                            PanContourAndVectorControls.this.vArray2Menu_.addItem("Down");
                            PanContourAndVectorControls.this.vArray2Menu_.setSelectedItem("Up");
                        }
                        PanContourAndVectorControls.this.pmeta_.put("plot:latvert.vector.direction1", (Object)newval1);
                    }
                });
            }
            this.vArray2Menu_.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    String newval = PanContourAndVectorControls.this.vArray2Menu_.getSelectedItem().toString();
                    if (ptype == PanPlotType.LON_LAT) {
                        PanContourAndVectorControls.this.pmeta_.put("plot:lonlat.map.vector.direction2", (Object)newval);
                    } else if (ptype == PanPlotType.LAT_VERT) {
                        PanContourAndVectorControls.this.pmeta_.put("plot:latvert.vector.direction2", (Object)newval);
                    }
                }
            });
            this.vStyleMenu_.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    JComboBox menu = (JComboBox)e.getSource();
                    PanContourAndVectorControls.this.pmeta_.put("plot:vector.style", (Object)PanContourAndVectorControls.this.vStyleMenu_.getStringValue());
                }
            });
            this.vColorMenu_.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Color cold;
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    Color cnew = PanContourAndVectorControls.this.vColorMenu_.getSelectedColor();
                    if (!cnew.equals(cold = PanContourAndVectorControls.this.pmeta_.getColor("plot:vector.color"))) {
                        PanContourAndVectorControls.this.pmeta_.setColor("plot:vector.color", cnew);
                    }
                }
            });
            this.vOpacitySpinner_.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PanContourAndVectorControls.this.pmeta_.setInt("plot:vector.weight", PanContourAndVectorControls.this.vOpacitySpinner_.getIntValue());
                }
            });
            this.vLengthTF_.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    PanContourAndVectorControls.this.handleVectorLength();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.vLengthTF_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanContourAndVectorControls.this.handleVectorLength();
                }
            });
            this.vSpacingSpinner_.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PanContourAndVectorControls.this.pmeta_.setInt("plot:vector.spacing", PanContourAndVectorControls.this.vSpacingSpinner_.getIntValue());
                }
            });
        }
        this.refresh();
    }

    private void handleVectorLength() {
        boolean badEntry = false;
        try {
            double value = TextUtilities.parseDouble(this.vLengthTF_.getText());
            if (value < 0.0) {
                badEntry = true;
            } else {
                this.pmeta_.setDouble("plot:vector.value", value);
            }
        }
        catch (Exception exc) {
            badEntry = true;
        }
        if (badEntry) {
            this.vLengthTF_.setText(PanConstants.PFORMAT_4G.sprintf(this.pmeta_.getDouble("plot:vector.value")));
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (!this.vectorsAllowed_) {
            return;
        }
        PanCombinationType ctype = (PanCombinationType)this.pmeta_.get("plot:combination");
        this.vectorsEnabled_ = ctype != null && ctype == PanCombinationType.VECTOR_A1_A2;
        this.vStyleMenu_.setEnabled(this.vectorsEnabled_);
        this.vColorMenu_.setEnabled(this.vectorsEnabled_);
        this.vArray1Menu_.setEnabled(this.vectorsEnabled_);
        this.vArray2Menu_.setEnabled(this.vectorsEnabled_);
        this.vOpacitySpinner_.setEnabled(this.vectorsEnabled_);
        this.vLengthTF_.setEnabled(this.vectorsEnabled_);
    }
}

