/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import gov.nasa.giss.panoply.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanPlotSizePopupMenu;
import gov.nasa.giss.panoply.PanWidgetUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanCommonPrefsPanel
extends PanAbstractPrefsPanel {
    private PanPlotSizePopupMenu sizeMenu_;
    private JCheckBox interpolateCB_;
    private JComboBox fontMenu_;
    private ColorMenu backgroundMenu_;

    public PanCommonPrefsPanel() {
        JLabel topText = new JLabel("When creating a new plot, set\u2026", 0);
        topText.setAlignmentX(0.5f);
        this.sizeMenu_ = new PanPlotSizePopupMenu();
        this.interpolateCB_ = PanWidgetUtils.getCheckBox(PanWidgetUtils.Size.NORMAL, null, "On");
        this.backgroundMenu_ = PanWidgetUtils.getColorMenu(PanWidgetUtils.Size.NORMAL, null, PaletteType.BLACK_WHITE);
        this.fontMenu_ = PanWidgetUtils.getFontMenu(PanWidgetUtils.Size.NORMAL, null);
        PanWidgetUtils.applyNormalUI(this.sizeMenu_);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 9, 0, 2);
        fgl.setColumnWeight(0, 9999.0f);
        fgl.setColumnWeight(3, 9999.0f);
        fgl.setRowWeight(8, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 4, 1));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, ++row));
        this.add((Component)new JLabel("Plot Size: "), new FGConstraint(1, ++row, 1.0, 0.5));
        this.add((Component)this.sizeMenu_, new FGConstraint(2, row, 0.0, 0.5));
        this.add((Component)new JLabel("Interpolation: "), new FGConstraint(1, ++row, 1.0, 0.5));
        this.add((Component)this.interpolateCB_, new FGConstraint(2, row, 0.0, 0.5));
        this.add((Component)new JLabel("Background: "), new FGConstraint(1, ++row, 1.0, 0.5));
        this.add((Component)QuickBox.createLeftBox(this.backgroundMenu_), new FGConstraint(2, row, 0.0, 0.5));
        this.add((Component)new JLabel("Labels Typeface: "), new FGConstraint(1, ++row, 1.0, 0.5));
        this.add((Component)this.fontMenu_, new FGConstraint(2, row, 0.0, 0.5));
        this.add(Box.createVerticalGlue(), new Point(0, ++row));
        this.refresh();
        this.interpolateCB_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PanCommonPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setBoolean("plot:scale.interpolate", PanCommonPrefsPanel.this.interpolateCB_.isSelected());
            }
        });
        this.backgroundMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanCommonPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:colors.background", PanCommonPrefsPanel.this.backgroundMenu_.getSelectedColor());
            }
        });
        this.fontMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanCommonPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.set("plot:font.master", PanCommonPrefsPanel.this.fontMenu_.getSelectedItem().toString());
            }
        });
        this.sizeMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (PanCommonPrefsPanel.this.refreshing_) {
                    return;
                }
                PanAbstractPrefsPanel.PREFS.setInt("plot:size.factor", PanCommonPrefsPanel.this.sizeMenu_.getSelectedSizeFactor());
            }
        });
    }

    @Override
    public void refresh() {
        this.refreshing_ = true;
        this.sizeMenu_.setSelectedSize(PREFS.getInt("plot:size.factor"));
        this.interpolateCB_.setSelected(PREFS.getBoolean("plot:scale.interpolate"));
        this.backgroundMenu_.setSelectedColor(PREFS.getColor("plot:colors.background"));
        this.fontMenu_.setSelectedItem(PREFS.getString("plot:font.master"));
        this.refreshing_ = false;
    }
}

