/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.PanWidgetUtils;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class PanCombinePlotDialog
extends JDialog {
    private PanSourcesFrame parent_;
    private JComboBox plotMenu_;
    private boolean success_;

    public PanCombinePlotDialog(PanSourcesFrame f) {
        super(f, "Combine Plot", true);
        this.parent_ = f;
        this.setResizable(false);
        JLabel label = new JLabel("In which existing plot should I combine the variable?");
        this.plotMenu_ = PanWidgetUtils.getComboBox(PanWidgetUtils.Size.NORMAL, null);
        Object pframe = null;
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof PanPlotFrame) || !frame.isVisible()) continue;
            this.plotMenu_.addItem(frame.getTitle());
        }
        JButton cancelButton = new JButton("Cancel");
        JButton combineButton = new JButton("Combine");
        QuickBox buttonBox = PlatformUtilities.isMacintosh() ? QuickBox.createRightBox(cancelButton, combineButton) : QuickBox.createRightBox(combineButton, cancelButton);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 8);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        contentPanel.add((Component)label, new FGConstraint(0, 1, 0.0, 0.5));
        if (label.getPreferredSize().width > this.plotMenu_.getPreferredSize().width) {
            contentPanel.add((Component)this.plotMenu_, new FGConstraint(0, 2, 0.5, 0.5));
        } else {
            contentPanel.add((Component)this.plotMenu_, new FGConstraint(0, 2, 0.0, 0.5));
        }
        contentPanel.add((Component)buttonBox, new FGConstraint(0, 4, 1.0, 0.5));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(combineButton);
        Dimension d = this.plotMenu_.getPreferredSize();
        if (d.width > 400) {
            d.width = 400;
            this.plotMenu_.setMaximumSize(d);
        }
        combineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanCombinePlotDialog.this.success_ = true;
                PanCombinePlotDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanCombinePlotDialog.this.setVisible(false);
            }
        });
        this.pack();
        Rectangle rr = this.parent_.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public String getTarget() {
        return (String)this.plotMenu_.getSelectedItem();
    }
}

