/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.panoply.PanMenuItemEnum;

public enum PanCombinationType implements PanMenuItemEnum
{
    A1_ONLY("A1only", "Array 1 Only"),
    A2_ONLY("A2only", "Array 2 Only"),
    A1_MINUS_A2("A1-A2", "Array 1 - Array 2"),
    A2_MINUS_A1("A2-A1", "Array 2 - Array 1"),
    A1_PLUS_A2("A1+A2", "Array 1 + Array 2"),
    A1_TIMES_A2("A1*A2", "Array 1 \u00d7 Array 2"),
    A1_OVER_A2("A1/A2", "Array 1 / Array 2"),
    A2_OVER_A1("A2/A1", "Array 2 / Array 1"),
    A1_MINUS_A2_OVER_A2("(A1-A2)%", "(Array 1 - Array 2) / Array 2"),
    A2_MINUS_A1_OVER_A1("(A2-A1)%", "(Array 2 - Array 1) / Array 1"),
    AVERAGE_A1_A2("Ave(A1,A2)", "Averaged Arrays"),
    COMBINE_A1_A2("Cmb(A1,A2)", "Combined Arrays"),
    VECTOR_A1_A2("Vec(A1,A2)", "Vector Magnitude");

    public static PanCombinationType ONE_ARRAY_DEFAULT;
    public static PanCombinationType TWO_ARRAYS_DEFAULT;
    private final String value_;
    private final String description_;

    private PanCombinationType(String value, String description) {
        this.value_ = value;
        this.description_ = description;
    }

    @Override
    public String getValue() {
        return this.value_;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    static {
        ONE_ARRAY_DEFAULT = A1_ONLY;
        TWO_ARRAYS_DEFAULT = A1_MINUS_A2;
    }
}

