/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.gui.color.ColorTableComboBoxRenderer;
import gov.nasa.giss.panoply.PanAbstractSupportMenu;
import gov.nasa.giss.panoply.PanColorTableList;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanSupportEvent;
import gov.nasa.giss.panoply.PanSupportListener;
import javax.swing.Icon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanColorTableMenu
extends PanAbstractSupportMenu
implements PanSupportListener {
    private static Logger logger_ = LoggerFactory.getLogger(PanColorTableMenu.class);
    private static final int SAMPLE_WIDTH = 48;
    private static final int GAP = 8;
    private static Icon checkIcon_;

    public PanColorTableMenu(boolean showSample) {
        super(PanColorTableList.getList().toArray());
        if (showSample) {
            this.setRenderer(new ColorTableComboBoxRenderer());
        }
        this.setMaximumSize(this.getPreferredSize());
        Object o = PanPreferences.getPrefs().get("plot:colorbar.name");
        if (o == null) {
            int isize = this.getItemCount();
            for (int i = 0; i < isize; ++i) {
                if (!((AbstractColorTable)this.getItemAt(i)).getName().contains("panoply")) continue;
                this.setSelectedIndex(i);
                break;
            }
        } else {
            this.setSelectedItem((AbstractColorTable)o);
        }
        PanColorTableList.getList().addSupportListener(this);
    }

    public void setSelectedItemByName(String name) {
        if (name == null) {
            return;
        }
        int isize = this.getItemCount();
        for (int i = 0; i < isize; ++i) {
            if (!name.equalsIgnoreCase(this.getItemAt(i).toString())) continue;
            this.setSelectedIndex(i);
            return;
        }
        logger_.warn("Could not find matching item for {}", (Object)name);
    }

    @Override
    public void itemAdded(PanSupportEvent e) {
        PanColorTableList colortableList = PanColorTableList.getList();
        int isize = colortableList.size();
        if (this.getItemCount() >= isize) {
            return;
        }
        Object lastAdded = null;
        for (int i = 0; i < isize; ++i) {
            if ((AbstractColorTable)colortableList.get(i) == (AbstractColorTable)this.getItemAt(i)) continue;
            lastAdded = colortableList.get(i);
            this.insertItemAt((AbstractColorTable)lastAdded, i);
        }
        this.notifyParentOfNewItem(lastAdded);
    }

    public synchronized void flush() {
        PanColorTableList.getList().removeSupportListener(this);
        this.removeAll();
    }
}

