/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.graphics.colortable.ColorTableFactory;
import gov.nasa.giss.graphics.colortable.ColorTableFilenameFilter;
import gov.nasa.giss.graphics.colortable.PalColorTable;
import gov.nasa.giss.panoply.PanAbstractSupportList;
import gov.nasa.giss.panoply.Panoply;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanColorTableList
extends PanAbstractSupportList {
    private static Logger logger_ = LoggerFactory.getLogger(PanColorTableList.class);
    private static PanColorTableList list_;

    public static synchronized PanColorTableList getList() {
        if (list_ == null) {
            list_ = new PanColorTableList();
        }
        return list_;
    }

    private PanColorTableList() {
        super(new ColorTableFilenameFilter());
        try {
            this.add(ColorTableFactory.open(Panoply.class.getResource("resources/colorbars/grayscale.act")));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        try {
            this.add(ColorTableFactory.open(Panoply.class.getResource("resources/colorbars/panoply.gct")));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.readFavorites("colorbars");
        if (this.size() < 1) {
            try {
                this.add(PalColorTable.getPreset(PalColorTable.SampleID.GRAYSCALE));
                this.add(PalColorTable.getPreset(PalColorTable.SampleID.HOTMETAL));
            }
            catch (Exception exc) {
                logger_.warn("Error creating preset color bar(s)");
                exc.printStackTrace();
            }
        }
    }

    @Override
    public Object add(File f) throws IOException, FileNotFoundException, ParseException {
        return this.add(ColorTableFactory.open(f));
    }

    @Override
    public Object add(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof AbstractColorTable)) {
            throw new IllegalArgumentException("Object is not a colortable");
        }
        return super.add(o);
    }
}

