/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.graphics.colortable.ColorTableFilenameFilter;
import gov.nasa.giss.graphics.colortable.ColorTableOutlier;
import gov.nasa.giss.graphics.colortable.gui.ColorTableBinPanel;
import gov.nasa.giss.graphics.colortable.gui.ColorTableSamplePanel;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.panoply.PanColorTableList;
import gov.nasa.giss.panoply.PanColorTableMenu;
import gov.nasa.giss.panoply.PanFileUtilities;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.PanMenuBar;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanWidgetUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanColorTableBrowser
extends PanFrame
implements DropTargetListener,
Printable {
    private static final int LABEL_FHGT = 12;
    private static final int LABEL_HGT = 18;
    private static final Font LABEL_FONT = new Font("SansSerif", 0, 12);
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private static PanColorTableBrowser bframe_;
    private JPanel contentPanel_;
    private PanColorTableMenu cbMenu_;
    private ColorTableBinPanel cbPanel_;
    private ColorTableSamplePanel csPanel_;

    public static PanColorTableBrowser findFrame(boolean create) {
        if (bframe_ == null && create) {
            bframe_ = new PanColorTableBrowser();
        }
        return bframe_;
    }

    private PanColorTableBrowser() {
        super("Color Tables");
        this.setName(this.getTitle());
        this.setResizable(false);
        this.setPanMenuBar(new PanMenuBar(this));
        this.setPanMenuBar(new PanMenuBar(this));
        this.cbMenu_ = PanWidgetUtils.getColorTableMenu(PanWidgetUtils.Size.NORMAL, null, false);
        AbstractColorTable cb = (AbstractColorTable)this.cbMenu_.getSelectedItem();
        this.csPanel_ = new ColorTableSamplePanel(cb);
        this.cbPanel_ = new ColorTableBinPanel(cb);
        this.contentPanel_ = new JPanel();
        this.contentPanel_.setLayout(new BoxLayout(this.contentPanel_, 1));
        this.contentPanel_.setBorder(PanGuiConstants.PADDED_UNFOCUSED_BORDER);
        this.contentPanel_.add(QuickBox.createCenterBox(new JLabel("Show: "), this.cbMenu_));
        this.contentPanel_.add(Box.createVerticalStrut(2));
        this.contentPanel_.add(this.csPanel_);
        this.contentPanel_.add(Box.createVerticalStrut(2));
        this.contentPanel_.add(this.cbPanel_);
        this.contentPanel_.setOpaque(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.contentPanel_);
        contentPane.add(this.createStatusBar());
        this.refresh();
        this.pack();
        Rectangle rr = GuiUtilities.getMainScreenBounds();
        if (rr == null) {
            this.setLocation(25, 25);
        } else {
            Dimension psize = this.getContentPane().getPreferredSize();
            int x = (rr.width - psize.width) / 2;
            int y = (rr.height - psize.height) / 2;
            this.setLocation(rr.x + x, rr.y + y);
        }
        GuiUtilities.makeRecursiveDropTarget(this.csPanel_, this);
        GuiUtilities.makeRecursiveDropTarget(this.cbPanel_, this);
        this.cbMenu_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                Dimension w1 = PanColorTableBrowser.this.getSize();
                Dimension p1 = PanColorTableBrowser.this.cbPanel_.getSize();
                AbstractColorTable cb = (AbstractColorTable)PanColorTableBrowser.this.cbMenu_.getSelectedItem();
                PanColorTableBrowser.this.csPanel_.setColorTable(cb);
                PanColorTableBrowser.this.cbPanel_.setColorTable(cb);
                PanColorTableBrowser.this.pack();
                PanColorTableBrowser.this.repaint();
                Dimension w2 = PanColorTableBrowser.this.getSize();
                Dimension p2 = PanColorTableBrowser.this.cbPanel_.getPreferredSize();
                int dd = p2.height - p1.height - (w2.height - w1.height);
                PanColorTableBrowser.this.setSize(new Dimension(w2.width, w2.height + dd));
            }
        });
    }

    @Override
    public void refresh() {
        if (ColorTableOutlier.TRIANGLE.matches(PREFS.getString("plot:scale.outlier"))) {
            this.csPanel_.setOutlierShape(ColorTableOutlier.TRIANGLE);
        } else {
            this.csPanel_.setOutlierShape(ColorTableOutlier.RECTANGLE);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.contentPanel_.setBorder(PanGuiConstants.PADDED_FOCUSED_BORDER);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            try {
                List flist = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                for (Object fobject : flist) {
                    File f = (File)fobject;
                    String lower = f.getName().toLowerCase();
                    if (!ColorTableFilenameFilter.isColorTableName(f)) continue;
                    try {
                        Object o = PanColorTableList.getList().add(f);
                        if (o == null) continue;
                        this.cbMenu_.setSelectedItem(o);
                    }
                    catch (Exception exc) {
                        PanFileUtilities.showFileError((Component)this, f.getName(), exc.toString());
                    }
                }
                e.dropComplete(true);
                this.repaint();
            }
            catch (Exception exc) {
                exc.printStackTrace();
                e.dropComplete(false);
            }
        } else {
            e.rejectDrop();
        }
        this.contentPanel_.setBorder(PanGuiConstants.PADDED_UNFOCUSED_BORDER);
        this.contentPanel_.invalidate();
        this.validate();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.contentPanel_.setBorder(PanGuiConstants.PADDED_UNFOCUSED_BORDER);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.contentPanel_.setBorder(PanGuiConstants.PADDED_FOCUSED_BORDER);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.contentPanel_.setBorder(PanGuiConstants.PADDED_UNFOCUSED_BORDER);
        this.repaint();
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        Dimension size = new Dimension(Math.max(this.csPanel_.getWidth(), this.cbPanel_.getWidth()), this.csPanel_.getHeight() + this.cbPanel_.getHeight() + 18);
        double scaleX = pf.getImageableWidth() / (double)size.width;
        double scaleY = pf.getImageableHeight() / (double)size.height;
        double scale = Math.min(scaleY, scaleX);
        double tranY = 0.5 * (pf.getImageableHeight() - scale * (double)size.height);
        g2d.translate(pf.getImageableX(), pf.getImageableY() + tranY);
        g2d.scale(scale, scale);
        this.csPanel_.print(g2d);
        g2d.translate(0, this.csPanel_.getHeight());
        this.cbPanel_.print(g2d);
        g2d.translate(0, this.cbPanel_.getHeight() + 18);
        this.printLabel(g2d, 0);
        return 0;
    }

    private void printLabel(Graphics2D g2d, int y) {
        g2d.setFont(LABEL_FONT);
        FontMetrics fm = g2d.getFontMetrics();
        String s = this.cbMenu_.getSelectedItem().toString();
        GraphicUtilities.drawString(g2d, s, (int)(0.5 * (double)(this.cbPanel_.getWidth() - fm.stringWidth(s))), y);
    }
}

