/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanClient {
    private static Logger logger_ = LoggerFactory.getLogger(PanClient.class);

    public PanClient(ArrayList<File> files) throws IOException, UnknownHostException {
        Socket socket = new Socket("localhost", 2880);
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        int isize = files.size();
        int sentCount = 0;
        if (isize > 0) {
            String input;
            while ((input = in.readLine()) != null && !input.equals("Bye.")) {
                String output;
                if (input.equalsIgnoreCase("panoply")) {
                    output = "panoply";
                } else if (input.equalsIgnoreCase("version")) {
                    output = "1.4";
                } else if (input.equalsIgnoreCase("filepath")) {
                    output = files.get(sentCount).getAbsolutePath();
                    ++sentCount;
                } else if (input.toLowerCase().startsWith("error")) {
                    output = "acknowledged";
                } else {
                    if (!input.equalsIgnoreCase("continue?")) break;
                    output = sentCount < isize ? "y" : "n";
                }
                out.println(output);
            }
        }
        out.println("Bye.");
        out.close();
        in.close();
        socket.close();
    }
}

