/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.event.TreeTableEvent;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcCatalog;
import gov.nasa.giss.netcdf.NcCatalogDataset;
import gov.nasa.giss.netcdf.NcCatalogNode;
import gov.nasa.giss.netcdf.gui.NcCatalogTreeTablePanel;
import gov.nasa.giss.panoply.PanFileUtilities;
import gov.nasa.giss.panoply.PanHistoryList;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.PanSourcesSplitSubpanel;
import java.awt.Color;
import java.awt.Point;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class PanCatalogsPanel
extends PanSourcesSplitSubpanel
implements HyperlinkListener {
    public PanCatalogsPanel(PanSourcesFrame parent) {
        super(parent);
        this.infoPane_.addHyperlinkListener(this);
    }

    @Override
    protected JComponent makeTreeBox() {
        PanPreferences prefs = PanPreferences.getPrefs();
        this.ttPanel_ = new NcCatalogTreeTablePanel();
        this.ttPanel_.setOpaque(true);
        this.ttPanel_.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
        this.ttPanel_.addTreeTableListener(this);
        ((NcCatalogTreeTablePanel)this.ttPanel_).setExpandNewNodes(prefs.getBoolean("sources:nodes.expanded"));
        return this.ttPanel_;
    }

    @Override
    public synchronized void refreshActions() {
        if (this.ttPanel_ != null) {
            PanPreferences prefs = PanPreferences.getPrefs();
            ((NcCatalogTreeTablePanel)this.ttPanel_).setExpandNewNodes(prefs.getBoolean("sources:nodes.expanded"));
        }
        this.parent_.disableActions();
        this.parent_.enableAction("toggle-info", true);
        this.parent_.enableAction("remove-all", this.getCatalogCount() > 0);
        TreeTableNode node = this.getSelectedNode();
        if (node != null) {
            if (node instanceof NcCatalog) {
                this.parent_.enableAction("add-bookmark", true);
                this.parent_.enableAction("remove-one", true);
            } else if (node instanceof NcCatalogDataset) {
                this.parent_.enableAction("open-catalog-dataset", ((NcCatalogDataset)node).getURI() != null);
                this.parent_.enableAction("add-bookmark", ((NcCatalogDataset)node).getAllowsChildren());
            }
        }
        if (node == null) {
            this.infoPane_.setContentType("text/plain");
            this.infoPane_.setText("");
        } else {
            String oldText = this.infoPane_.getText();
            String newText = ((NcCatalogNode)node).getDetail();
            if (oldText == null || !newText.equals(oldText)) {
                String newType = ((NcCatalogNode)node).getDetailType();
                this.infoPane_.setContentType(newType);
                this.infoPane_.setText(newText);
                this.infoPane_.setCaretPosition(0);
            }
        }
    }

    @Override
    public void clear() {
        for (Object o : ((NcCatalogTreeTablePanel)this.ttPanel_).getCatalogs()) {
            this.removeNode((TreeTableNode)o);
        }
    }

    @Override
    public TreeTableNode getSelectedNode() {
        return this.ttPanel_.getTreeTable().getSelectedNode();
    }

    public synchronized NcCatalogNode addCatalog(URL url) throws MalformedURLException, URISyntaxException {
        if (url == null) {
            return null;
        }
        return ((NcCatalogTreeTablePanel)this.ttPanel_).addCatalog(url);
    }

    @Override
    public void removeNode(TreeTableNode node) {
        if (node == null) {
            return;
        }
        if (!(node instanceof NcCatalog)) {
            throw new IllegalArgumentException("Can only remove a Catalog");
        }
        ((NcCatalogTreeTablePanel)this.ttPanel_).removeCatalog((NcCatalog)node);
        this.refreshActions();
    }

    public synchronized int getCatalogCount() {
        return ((NcCatalogTreeTablePanel)this.ttPanel_).getCatalogCount();
    }

    @Override
    public void removalRequested(TreeTableEvent e) {
    }

    @Override
    public void selectionMade(TreeTableEvent e) {
        this.refreshActions();
        NcCatalogNode node = (NcCatalogNode)e.getNode();
        if (node == null) {
            return;
        }
        int id = e.getID();
        Point pt = e.getPoint();
        if (id == 102 && node instanceof NcCatalogDataset) {
            URI uri = ((NcCatalogDataset)node).getURI();
            if (uri == null) {
                return;
            }
            this.parent_.getAction("open-catalog-dataset").actionPerformed(null);
        } else if (id != 103 || pt != null) {
            // empty if block
        }
    }

    @Override
    public void itemAdded(TreeTableEvent e) {
        this.refreshActions();
        this.repaint();
        TreeTableNode node = e.getNode();
        if (node == null || !(node instanceof NcCatalog)) {
            return;
        }
        PanHistoryList.getList().addBookmark((NcCatalog)node);
        GuiUtilities.refreshFrontFrameMenuBar();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        if (e instanceof HTMLFrameHyperlinkEvent) {
            return;
        }
        try {
            URL url = e.getURL();
            String s = url.toString();
            if (!s.startsWith("http:") && !s.startsWith("ftp:")) {
                throw new RuntimeException("Unknown protocol in " + s);
            }
            PanFileUtilities.openDataset(this.parent_, url);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

