/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.DragGhost;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.event.TreeTableEvent;
import gov.nasa.giss.gui.event.TreeTableListener;
import gov.nasa.giss.gui.treetable.TreeTable;
import gov.nasa.giss.gui.treetable.TreeTableCellRenderer;
import gov.nasa.giss.gui.treetable.TreeTableModel;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.gui.treetable.TreeTablePanel;
import gov.nasa.giss.panoply.PanBookmark;
import gov.nasa.giss.panoply.PanBookmarksFolder;
import gov.nasa.giss.panoply.PanBookmarksList;
import gov.nasa.giss.panoply.PanBookmarksNode;
import gov.nasa.giss.panoply.PanBookmarksNodeSelection;
import gov.nasa.giss.panoply.PanBookmarksTreeTableModel;
import gov.nasa.giss.panoply.PanFrame;
import gov.nasa.giss.panoply.PanSourcesFrame;
import gov.nasa.giss.panoply.PanSourcesSubpanel;
import gov.nasa.giss.panoply.Panoply;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBookmarksTreeTablePanel
extends TreeTablePanel
implements PanSourcesSubpanel,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static Logger logger_ = LoggerFactory.getLogger(PanBookmarksTreeTablePanel.class);
    private PanSourcesFrame parent_;

    public PanBookmarksTreeTablePanel(PanSourcesFrame parent) {
        super(new PanBookmarksTreeTableModel(PanBookmarksList.getList()));
        URL url;
        try {
            url = Panoply.class.getResource("resources/ttbookmark.png");
            this.getTreeTable().setLeafIcon(new ImageIcon(url));
        }
        catch (Exception exc) {
            logger_.warn("Could not load TT bookmark icon.");
        }
        try {
            url = Panoply.class.getResource("resources/ttfolder.png");
            ImageIcon icon = new ImageIcon(url);
            this.getTreeTable().setClosedIcon(icon);
        }
        catch (Exception exc) {
            logger_.warn("Could not load TT folder icon.");
        }
        this.parent_ = parent;
        this.addTreeTableListener(new TTListener());
        this.initDragNDrop();
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
    }

    private void initDragNDrop() {
        TreeTable tt = this.getTreeTable();
        DragGestureRecognizer dgr = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(tt, 1, this);
        DropTarget dt = new DropTarget(this, this);
        DropTarget dtt = new DropTarget(tt, this);
        Component[] c = this.getComponents();
        DropTarget[] dtx = new DropTarget[c.length];
        for (int i = 0; i < c.length; ++i) {
            dtx[i] = new DropTarget(c[i], this);
        }
    }

    public synchronized PanBookmarksNode addNode(final PanBookmarksNode node) {
        if (node == null) {
            return null;
        }
        ((PanBookmarksTreeTableModel)this.getModel()).addToRoot(node);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanBookmarksTreeTablePanel.this.getTreeTable().setSelectedNode(node);
                PanBookmarksTreeTablePanel.this.getTreeTable().makeNodeVisible(node);
                PanBookmarksTreeTablePanel.this.fireItemAdded(node);
            }
        });
        return node;
    }

    public synchronized PanBookmarksNode addFolder(String name) {
        if (name == null) {
            return null;
        }
        PanBookmarksFolder folder = new PanBookmarksFolder(null, name);
        this.addNode(folder);
        return folder;
    }

    @Override
    public void removeNode(TreeTableNode node) {
        if (node == null) {
            return;
        }
        if (!(node instanceof PanBookmark) && !(node instanceof PanBookmarksFolder)) {
            throw new IllegalArgumentException("Can only remove a Catalog");
        }
        PanBookmarksTreeTableModel model = (PanBookmarksTreeTableModel)this.getModel();
        model.removeNode((PanBookmarksNode)node);
        this.refreshActions();
    }

    @Override
    public void refreshActions() {
        this.parent_.disableActions();
        TreeTableNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        this.parent_.enableAction("remove-one", true);
    }

    @Override
    public void remakeLayout() {
    }

    @Override
    public void clear() {
    }

    @Override
    public TreeTableNode getSelectedNode() {
        return this.getTreeTable().getSelectedNode();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TreeTable tt = this.getTreeTable();
        PanBookmarksNode node = (PanBookmarksNode)tt.getSelectedNode();
        if (node == null) {
            return;
        }
        int row = tt.getRowForNode(node);
        TreeTableCellRenderer ttcr = (TreeTableCellRenderer)tt.getCellRenderer(row, 0).getTableCellRendererComponent(tt, node, false, false, row, 0);
        int iconX = ttcr.getIconX(tt, node, null);
        ttcr.setSize(ttcr.getPreferredSize());
        ttcr.setLeftShift(ttcr.getIconX(tt, node, null));
        if (dge.getDragAction() == 1) {
            dge.startDrag(DragSource.DefaultCopyDrop, new DragGhost(ttcr), new Point(5, 5), new PanBookmarksNodeSelection(node), this);
        } else if (dge.getDragAction() == 2) {
            // empty if block
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
        if (!e.getDropSuccess()) {
            return;
        }
        int dropAction = e.getDropAction();
        if (dropAction == 2) {
            // empty if block
        }
        this.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
        DragSourceContext dsc = e.getDragSourceContext();
        int da = e.getDropAction();
        if ((da & 1) != 0) {
            dsc.setCursor(DragSource.DefaultCopyDrop);
        } else if ((da & 2) != 0) {
            dsc.setCursor(DragSource.DefaultMoveNoDrop);
        } else {
            dsc.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (this.isDragOK(e)) {
            e.acceptDrag(1);
            Point p = e.getLocation();
            int row = this.rowAtPoint(p);
            if (row == -99) {
                this.setDragHighlight(this.getTreeTable().getRowCount() - 1, TreeTablePanel.DragMode.END);
            } else {
                this.setDragHighlight(row, this.dragMode(p, row));
            }
            this.repaint();
        } else {
            this.setDragHighlight(-1, TreeTablePanel.DragMode.NONE);
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.setDragHighlight(-1, TreeTablePanel.DragMode.NONE);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (this.isDragOK(e)) {
            e.acceptDrag(1);
            Point p = e.getLocation();
            int row = this.rowAtPoint(p);
            if (row == -99) {
                this.setDragHighlight(this.getTreeTable().getRowCount() - 1, TreeTablePanel.DragMode.END);
            } else {
                this.setDragHighlight(row, this.dragMode(p, row));
            }
            this.repaint();
        } else {
            this.setDragHighlight(-1, TreeTablePanel.DragMode.NONE);
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        PanBookmarksNode newParent;
        boolean inSameTree;
        PanBookmarksNode srcNode;
        this.setDragHighlight(-1, TreeTablePanel.DragMode.NONE);
        TreeTable tt = this.getTreeTable();
        TreeTableModel ttModel = tt.getTreeTableModel();
        Transferable t = e.getTransferable();
        int sa = e.getSourceActions();
        if (!t.isDataFlavorSupported(PanBookmarksNodeSelection.FLAVOR)) {
            e.rejectDrop();
            return;
        }
        if ((sa & 1) == 0) {
            e.rejectDrop();
            return;
        }
        try {
            srcNode = (PanBookmarksNode)t.getTransferData(PanBookmarksNodeSelection.FLAVOR);
        }
        catch (Exception exc) {
            e.rejectDrop();
            return;
        }
        boolean bl = inSameTree = srcNode.getRoot() == ttModel.getRoot();
        if (!inSameTree) {
            e.rejectDrop();
            return;
        }
        Point p = e.getLocation();
        int row = tt.rowAtPoint(p);
        TreeTablePanel.DragMode mode = this.dragMode(p, row);
        int dropIndex = 0;
        if (row == -1) {
            newParent = (PanBookmarksNode)ttModel.getRoot();
            dropIndex = newParent.getChildCount();
            if (ttModel.isRoot(srcNode)) {
                e.rejectDrop();
                return;
            }
        } else {
            PanBookmarksNode targetNode = (PanBookmarksNode)tt.getNodeForRow(row);
            if (targetNode.isNodeAncestor(srcNode)) {
                e.rejectDrop();
                return;
            }
            if (mode == TreeTablePanel.DragMode.BEFORE) {
                newParent = (PanBookmarksNode)targetNode.getParent();
                dropIndex = newParent.getIndexOfChild(targetNode);
            } else if (mode == TreeTablePanel.DragMode.AFTER) {
                newParent = (PanBookmarksNode)targetNode.getParent();
                dropIndex = newParent.getIndexOfChild(targetNode) + 1;
            } else if (mode == TreeTablePanel.DragMode.ONTO) {
                newParent = targetNode;
                dropIndex = 0;
            } else {
                e.dropComplete(false);
                this.repaint();
                return;
            }
        }
        e.acceptDrop(1);
        try {
            int oldIndex;
            PanBookmarksNode oldParent = (PanBookmarksNode)srcNode.getParent();
            if (oldParent == newParent && dropIndex > (oldIndex = newParent.getIndexOfChild(srcNode)) && dropIndex > 0) {
                --dropIndex;
            }
            if ((oldIndex = oldParent.getIndexOfChild(srcNode)) > -1) {
                oldParent.remove(oldIndex);
                ttModel.nodeRemoved(oldParent, oldIndex, srcNode);
            }
            newParent.add(dropIndex, srcNode);
            ttModel.nodeInserted(newParent, dropIndex, srcNode);
            e.dropComplete(true);
        }
        catch (Exception exc) {
            e.dropComplete(false);
        }
        this.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.repaint();
    }

    private boolean isDragOK(DropTargetDragEvent e) {
        return e.isDataFlavorSupported(PanBookmarksNodeSelection.FLAVOR);
    }

    private int rowAtPoint(Point p) {
        int row = this.getTreeTable().rowAtPoint(p);
        if (row == -1) {
            Rectangle r = this.getTreeTable().getCellRect(this.getTreeTable().getRowCount() - 1, 0, true);
            if (p.y > r.y + r.height) {
                row = -99;
            }
        }
        return row;
    }

    private TreeTablePanel.DragMode dragMode(Point p, int row) {
        if (row < 0) {
            return TreeTablePanel.DragMode.BEFORE;
        }
        Rectangle r = this.getTreeTable().getCellRect(row, 0, true);
        float percent = (float)(p.y - r.y) / (float)r.height;
        PanBookmarksNode targetNode = (PanBookmarksNode)this.getTreeTable().getNodeForRow(row);
        if (targetNode instanceof PanBookmark) {
            if (percent < 0.5f) {
                return TreeTablePanel.DragMode.BEFORE;
            }
            return TreeTablePanel.DragMode.AFTER;
        }
        if (percent < 0.2f) {
            return TreeTablePanel.DragMode.BEFORE;
        }
        if (percent < 0.8f) {
            return TreeTablePanel.DragMode.ONTO;
        }
        if (row + 1 >= this.getTreeTable().getRowCount()) {
            return TreeTablePanel.DragMode.AFTER;
        }
        PanBookmarksNode nextNode = (PanBookmarksNode)this.getTreeTable().getNodeForRow(row + 1);
        if (nextNode.getParent().equals(targetNode)) {
            return TreeTablePanel.DragMode.ONTO;
        }
        return TreeTablePanel.DragMode.AFTER;
    }

    class TTListener
    implements TreeTableListener {
        TTListener() {
        }

        @Override
        public void itemAdded(TreeTableEvent e) {
        }

        @Override
        public void itemRemoved(TreeTableEvent e) {
        }

        @Override
        public void removalRequested(TreeTableEvent e) {
            if (e == null) {
                return;
            }
            TreeTableNode node = e.getNode();
            PanBookmarksTreeTablePanel.this.removeNode(node);
        }

        @Override
        public void selectionMade(TreeTableEvent e) {
            PanBookmarksTreeTablePanel.this.refreshActions();
            PanBookmarksNode node = (PanBookmarksNode)e.getNode();
            if (node == null) {
                return;
            }
            int id = e.getID();
            Point pt = e.getPoint();
            if (id == 102 && node instanceof PanBookmark) {
                ((PanBookmark)node).open((PanFrame)GuiUtilities.getParentFrame(PanBookmarksTreeTablePanel.this));
            }
        }
    }
}

