/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.treetable.TreeTableModel;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.panoply.PanBookmark;
import gov.nasa.giss.panoply.PanBookmarkType;
import gov.nasa.giss.panoply.PanBookmarksFolder;
import gov.nasa.giss.panoply.PanBookmarksList;
import gov.nasa.giss.panoply.PanBookmarksNode;
import javax.swing.SwingConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBookmarksTreeTableModel
extends TreeTableModel
implements SwingConstants {
    private static Logger logger_ = LoggerFactory.getLogger(PanBookmarksTreeTableModel.class);
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Type", "Address"};
    private static final Class[] COLUMN_CLASSES = new Class[]{TreeTableModel.class, String.class, String.class};
    private static final int[] COLUMN_ALIGNMENTS = new int[]{2, 2, 2};

    public PanBookmarksTreeTableModel(PanBookmarksList root) {
        super(root);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    public Class getColumnClass(int col) {
        return COLUMN_CLASSES[col];
    }

    @Override
    public int getColumnAlignment(int col) {
        return COLUMN_ALIGNMENTS[col];
    }

    @Override
    public Object getValueAt(TreeTableNode node, int col) {
        if (node == null) {
            return "";
        }
        PanBookmarksNode o = (PanBookmarksNode)node;
        try {
            switch (col) {
                case 0: {
                    return o.getName();
                }
                case 1: {
                    if (o instanceof PanBookmark) {
                        PanBookmarkType btype = ((PanBookmark)o).getAccessType();
                        switch (btype) {
                            case LOCAL_DATASET: {
                                return "Local Dataset";
                            }
                            case REMOTE_DATASET: {
                                return "Remote Dataset";
                            }
                            case CATALOG: {
                                return "Remote Catalog";
                            }
                        }
                        return "\u2026";
                    }
                    return "\u2026";
                }
                case 2: {
                    return o.getAddress();
                }
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, TreeTableNode node, int col) {
        if (col > 0) {
            return;
        }
        PanBookmarksNode bnode = (PanBookmarksNode)node;
        if (value != null) {
            bnode.setName(value.toString());
        } else {
            bnode.setName(null);
        }
    }

    public PanBookmarksNode addToRoot(PanBookmarksNode node) {
        PanBookmarksList root = (PanBookmarksList)this.getRoot();
        root.add(node);
        int index = root.getChildCount() - 1;
        this.nodeInserted(root, index, node);
        return node;
    }

    public void removeNode(PanBookmarksNode node) {
        if (!(node instanceof PanBookmark) && !(node instanceof PanBookmarksFolder)) {
            return;
        }
        TreeTableNode[] ancestry = node.getPath();
        int isize = ancestry.length;
        if (isize < 2) {
            logger_.warn("Apparently trying to remove root of bookmarks tree.");
            return;
        }
        if (!ancestry[0].equals(this.getRoot())) {
            logger_.warn("Apparently trying to remove PanBookmarksNode which is not visible in tree.");
            return;
        }
        TreeTableNode parent = ancestry[isize - 2];
        int index = parent.getIndexOfChild(node);
        try {
            parent.remove(index);
            this.nodeRemoved(parent, index, node);
        }
        catch (Exception exc) {
            logger_.error("PanBookmarksTreeTableModel.removeNode : {}", (Object)exc.toString());
            exc.printStackTrace();
        }
    }
}

