/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.panoply.PanBookmarksNode;

public class PanBookmarksFolder
extends PanBookmarksNode {
    public PanBookmarksFolder(PanBookmarksNode parent, String name) {
        this.setParent(parent);
        this.setName(name);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getName() {
        if (this.isNameSet()) {
            return super.getName();
        }
        return "Unnamed Folder";
    }

    @Override
    public String getAddress() {
        int isize = this.getChildCount();
        if (isize == 1) {
            return "1 item";
        }
        return this.getChildCount() + " items";
    }

    @Override
    public void add(TreeTableNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Can't insert a null.");
        }
        if (!(child instanceof PanBookmarksNode)) {
            throw new IllegalArgumentException("Child must be a PanBookmarksNode.");
        }
        super.add(child);
    }

    @Override
    public void add(int index, TreeTableNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Can't insert a null.");
        }
        if (!(child instanceof PanBookmarksNode)) {
            throw new IllegalArgumentException("Child must be a PanBookmarksNode.");
        }
        super.add(index, child);
    }
}

