/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.panoply.PanBookmarkType;
import gov.nasa.giss.panoply.PanBookmarksNode;
import gov.nasa.giss.panoply.PanFileUtilities;
import gov.nasa.giss.panoply.PanFrame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBookmark
extends PanBookmarksNode {
    private static Logger logger_ = LoggerFactory.getLogger(PanBookmark.class);
    public static final String UNNAMED = "Unnamed";
    private static String homeDir_ = System.getProperty("user.home");
    private PanBookmarkType btype_;
    private URI uri_;

    private PanBookmark() {
    }

    public PanBookmark(PanBookmarksNode parent, PanBookmarkType btype, Object o, String name) throws IOException, URISyntaxException {
        this(btype, o, name);
        super.setParent(parent);
    }

    public PanBookmark(String btype, Object o, String name) throws IOException, URISyntaxException {
        if (btype == null) {
            throw new IllegalArgumentException("Null bookmark type");
        }
        if (btype.equals("local") || btype.equals("file")) {
            this.initMe(PanBookmarkType.LOCAL_DATASET, o, name);
        } else if (btype.equals("remote")) {
            this.initMe(PanBookmarkType.REMOTE_DATASET, o, name);
        } else if (btype.equals("catalog")) {
            this.initMe(PanBookmarkType.CATALOG, o, name);
        } else {
            throw new IllegalArgumentException("Uknown bookmark type");
        }
    }

    public PanBookmark(PanBookmarkType btype, Object o, String name) throws IOException, URISyntaxException {
        this.initMe(btype, o, name);
    }

    private void initMe(PanBookmarkType btype, Object o, String name) throws IOException, URISyntaxException {
        this.btype_ = btype;
        this.setName(name);
        if (o instanceof URI) {
            this.uri_ = (URI)o;
        } else if (o instanceof URL) {
            this.uri_ = ((URL)o).toURI();
        } else if (o instanceof File) {
            this.uri_ = ((File)o).toURI();
        } else if (o instanceof String) {
            String address = (String)o;
            switch (btype) {
                case LOCAL_DATASET: {
                    address = address.replaceFirst("file:", "");
                    address = address.replaceAll("/+", "/");
                    URI uri = new URI("file:" + address);
                    File f = new File(uri);
                    if (!f.exists()) {
                        throw new FileNotFoundException("No local file for address " + address);
                    }
                    this.uri_ = uri;
                    break;
                }
                case REMOTE_DATASET: 
                case CATALOG: {
                    this.uri_ = new URI(address);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown bookmark type");
                }
            }
        } else {
            throw new IllegalArgumentException("PanBookmark must be a File, URL, URI or parseable String");
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public Object getObject() {
        return this.uri_;
    }

    @Override
    public String getName() {
        if (this.isNameSet()) {
            return super.getName();
        }
        String s = null;
        try {
            s = this.uri_.toURL().getFile();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return "URI Error";
        }
        if (s != null) {
            if (s.startsWith("file:")) {
                s = s.substring(5);
            }
            if (s.startsWith(homeDir_)) {
                s = "~" + s.substring(homeDir_.length());
            }
            return s;
        }
        s = s.replaceAll("%20", " ");
        return UNNAMED;
    }

    public String getSetName() {
        if (this.isNameSet()) {
            return super.getName();
        }
        return null;
    }

    @Override
    public String getAddress() {
        if (this.uri_ == null) {
            return "Null address";
        }
        String s = this.uri_.toString();
        if (s == null) {
            return "Null address";
        }
        if (s.startsWith("file:") && (s = s.substring(5)).startsWith(homeDir_)) {
            s = "~" + s.substring(homeDir_.length());
        }
        s = s.replaceAll("%20", " ");
        return s;
    }

    public PanBookmarkType getAccessType() {
        return this.btype_;
    }

    public void open(PanFrame pframe) {
        switch (this.btype_) {
            case LOCAL_DATASET: {
                PanFileUtilities.openLocalFile(pframe, this.uri_);
                break;
            }
            case REMOTE_DATASET: {
                PanFileUtilities.openDataset(pframe, this.uri_);
                break;
            }
            case CATALOG: {
                PanFileUtilities.openRemoteCatalog(pframe, this.uri_);
            }
        }
    }

    public PanBookmark copy() {
        try {
            return new PanBookmark(this.getAccessType(), this.getObject(), this.getName());
        }
        catch (Exception exc) {
            logger_.warn("Could not copy bookmark: {}", exc);
            return null;
        }
    }
}

